/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.gui.server.core;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.openmole.core.event.Event;
import org.openmole.core.workflow.builder.DefinitionScope;
import org.openmole.core.workflow.execution.Environment;
import org.openmole.core.workflow.execution.Environment$;
import org.openmole.core.workflow.execution.ExceptionEvent;
import org.openmole.core.workflow.mole.MoleCapsule;
import org.openmole.core.workflow.mole.MoleExecution;
import org.openmole.core.workflow.task.MoleTask;
import org.openmole.core.workflow.task.MoleTask$;
import org.openmole.core.workflow.task.Task;
import org.openmole.gui.server.core.RunningEnvironment;
import org.openmole.gui.server.core.RunningEnvironment$;
import org.openmole.gui.server.core.ServerState$ExecutionInfo$;
import org.openmole.gui.server.ext.utils$;
import org.openmole.gui.shared.data.EnvironmentError;
import org.openmole.gui.shared.data.EnvironmentError$;
import org.openmole.gui.shared.data.EnvironmentId;
import org.openmole.gui.shared.data.EnvironmentState;
import org.openmole.gui.shared.data.EnvironmentState$;
import org.openmole.gui.shared.data.ErrorData;
import org.openmole.gui.shared.data.ErrorData$;
import org.openmole.gui.shared.data.ExecutionActivity;
import org.openmole.gui.shared.data.ExecutionData;
import org.openmole.gui.shared.data.ExecutionData$;
import org.openmole.gui.shared.data.ExecutionId;
import org.openmole.gui.shared.data.ExecutionState;
import org.openmole.gui.shared.data.MessageErrorData;
import org.openmole.gui.shared.data.MessageErrorData$;
import org.openmole.gui.shared.data.NetworkActivity;
import org.openmole.gui.shared.data.NotificationEvent;
import org.openmole.gui.shared.data.NotificationEvent$;
import org.openmole.gui.shared.data.SafePath;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment;
import org.openmole.tool.stream.StringPrintStream;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.stm.InTxn;
import scala.concurrent.stm.MaybeTxn$;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.Ref$;
import scala.concurrent.stm.TMap;
import scala.concurrent.stm.TMap$;
import scala.concurrent.stm.TSet;
import scala.concurrent.stm.TSet$;
import scala.concurrent.stm.package$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class ServerState {
    private final TMap<ExecutionId, ExecutionInfo> executionInfo = (TMap)TMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    private final TMap<ExecutionId, Seq<EnvironmentId>> environmentIds = (TMap)TMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    private final TMap<EnvironmentId, RunningEnvironment> runningEnvironments = (TMap)TMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    private final TSet<NotificationEvent> notificationEvents = (TSet)TSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NotificationEvent[0]));
    private final Ref<Object> notificationEventId = Ref$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L));

    public void org$openmole$gui$server$core$ServerState$$updateRunningEnvironment(EnvironmentId envId, Function1<RunningEnvironment, RunningEnvironment> update) {
        package$.MODULE$.atomic().apply((Function1)(JProcedure1 & Serializable)ctx -> this.runningEnvironments.get((Object)envId, ctx).foreach((Function1)(JProcedure1 & Serializable)env -> this.runningEnvironments.update((Object)envId, update.apply(env), ctx)), MaybeTxn$.MODULE$.unknown());
    }

    public PartialFunction<Tuple2<MoleExecution, Event<MoleExecution>>, BoxedUnit> moleExecutionListener(ExecutionId execId, SafePath script) {
        return new Serializable(execId, script, this){
            private final ExecutionId execId$1;
            private final SafePath script$3;
            private final /* synthetic */ ServerState $outer;
            {
                this.execId$1 = execId$2;
                this.script$3 = script$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    MoleExecution moleExecution = (MoleExecution)tuple2._1();
                    Event event = (Event)tuple2._2();
                    if (moleExecution != null) {
                        MoleExecution ex = moleExecution;
                        if (event instanceof MoleExecution.Finished) {
                            MoleExecution.Finished f = (MoleExecution.Finished)event;
                            return true;
                        }
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    MoleExecution moleExecution = (MoleExecution)tuple2._1();
                    Event event = (Event)tuple2._2();
                    if (moleExecution != null) {
                        MoleExecution ex = moleExecution;
                        if (event instanceof MoleExecution.Finished) {
                            MoleExecution.Finished f = (MoleExecution.Finished)event;
                            if (!ServerState.org$openmole$gui$server$core$ServerState$$anon$1$$_$canceled$1(f, ex)) {
                                long time = System.currentTimeMillis();
                                this.$outer.addNotification((Function1<Object, NotificationEvent>)(Function1 & Serializable)_$1 -> this.applyOrElse$$anonfun$1(ex, time, BoxesRunTime.unboxToLong((Object)_$1)));
                                return BoxedUnit.UNIT;
                            }
                            return BoxedUnit.UNIT;
                        }
                    }
                }
                return function1.apply((Object)x);
            }

            private final /* synthetic */ NotificationEvent applyOrElse$$anonfun$1(MoleExecution ex$2, long time$1, long _$1) {
                return NotificationEvent.MoleExecutionFinished$.MODULE$.apply(this.execId$1, this.script$3, ex$2.exception((MoleExecution.SynchronisationContext)MoleExecution.SynchronisationContext$.MODULE$.default()).map(ServerState::org$openmole$gui$server$core$ServerState$$anon$1$$_$applyOrElse$$anonfun$1$$anonfun$1), utils$.MODULE$.formatDate(time$1), time$1, _$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$adapted$1(org.openmole.core.workflow.mole.MoleExecution long java.lang.Object ), org$openmole$gui$server$core$ServerState$$anon$1$$_$applyOrElse$$anonfun$1$$anonfun$1(org.openmole.core.workflow.mole.MoleExecution$MoleExecutionFailed )}, serializedLambda);
            }
        };
    }

    public PartialFunction<Tuple2<Environment, Event<Environment>>, BoxedUnit> environmentListener(EnvironmentId envId) {
        return new Serializable(envId, this){
            private final EnvironmentId envId$3;
            private final /* synthetic */ ServerState $outer;
            {
                this.envId$3 = envId$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Environment environment = (Environment)tuple2._1();
                    Event event = (Event)tuple2._2();
                    if (environment != null) {
                        Environment environment2;
                        Environment env = environment2 = environment;
                        if (event instanceof BatchEnvironment.BeginDownload) {
                            BatchEnvironment.BeginDownload bdl = (BatchEnvironment.BeginDownload)event;
                            return true;
                        }
                        Environment env2 = environment2;
                        if (event instanceof BatchEnvironment.EndDownload) {
                            BatchEnvironment.EndDownload edl = (BatchEnvironment.EndDownload)event;
                            return true;
                        }
                        Environment env3 = environment2;
                        if (event instanceof BatchEnvironment.BeginUpload) {
                            BatchEnvironment.BeginUpload bul = (BatchEnvironment.BeginUpload)event;
                            return true;
                        }
                        Environment env4 = environment2;
                        if (event instanceof BatchEnvironment.EndUpload) {
                            BatchEnvironment.EndUpload eul = (BatchEnvironment.EndUpload)event;
                            return true;
                        }
                        Environment env5 = environment2;
                        if (event instanceof Environment.JobCompleted) {
                            Environment.JobCompleted j = (Environment.JobCompleted)event;
                            return true;
                        }
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Environment environment = (Environment)tuple2._1();
                    Event event = (Event)tuple2._2();
                    if (environment != null) {
                        Environment environment2;
                        Environment env = environment2 = environment;
                        if (event instanceof BatchEnvironment.BeginDownload) {
                            BatchEnvironment.BeginDownload bdl = (BatchEnvironment.BeginDownload)event;
                            this.$outer.org$openmole$gui$server$core$ServerState$$updateRunningEnvironment(this.envId$3, (Function1<RunningEnvironment, RunningEnvironment>)((Function1 & Serializable)ServerState::org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$2));
                            return BoxedUnit.UNIT;
                        }
                        Environment env2 = environment2;
                        if (event instanceof BatchEnvironment.EndDownload) {
                            BatchEnvironment.EndDownload edl = (BatchEnvironment.EndDownload)event;
                            this.$outer.org$openmole$gui$server$core$ServerState$$updateRunningEnvironment(this.envId$3, (Function1<RunningEnvironment, RunningEnvironment>)((Function1 & Serializable)arg_0 -> ServerState.org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$3(edl, arg_0)));
                            return BoxedUnit.UNIT;
                        }
                        Environment env3 = environment2;
                        if (event instanceof BatchEnvironment.BeginUpload) {
                            BatchEnvironment.BeginUpload bul = (BatchEnvironment.BeginUpload)event;
                            this.$outer.org$openmole$gui$server$core$ServerState$$updateRunningEnvironment(this.envId$3, (Function1<RunningEnvironment, RunningEnvironment>)((Function1 & Serializable)ServerState::org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$4));
                            return BoxedUnit.UNIT;
                        }
                        Environment env4 = environment2;
                        if (event instanceof BatchEnvironment.EndUpload) {
                            BatchEnvironment.EndUpload eul = (BatchEnvironment.EndUpload)event;
                            this.$outer.org$openmole$gui$server$core$ServerState$$updateRunningEnvironment(this.envId$3, (Function1<RunningEnvironment, RunningEnvironment>)((Function1 & Serializable)arg_0 -> ServerState.org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$5(eul, arg_0)));
                            return BoxedUnit.UNIT;
                        }
                        Environment env5 = environment2;
                        if (event instanceof Environment.JobCompleted) {
                            Environment.JobCompleted j = (Environment.JobCompleted)event;
                            this.$outer.org$openmole$gui$server$core$ServerState$$updateRunningEnvironment(this.envId$3, (Function1<RunningEnvironment, RunningEnvironment>)((Function1 & Serializable)arg_0 -> ServerState.org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$6(j, arg_0)));
                            return BoxedUnit.UNIT;
                        }
                    }
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$2(org.openmole.gui.server.core.RunningEnvironment ), org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$3(org.openmole.plugin.environment.batch.environment.BatchEnvironment$EndDownload org.openmole.gui.server.core.RunningEnvironment ), org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$4(org.openmole.gui.server.core.RunningEnvironment ), org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$5(org.openmole.plugin.environment.batch.environment.BatchEnvironment$EndUpload org.openmole.gui.server.core.RunningEnvironment ), org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$6(org.openmole.core.workflow.execution.Environment$JobCompleted org.openmole.gui.server.core.RunningEnvironment )}, serializedLambda);
            }
        };
    }

    public void addRunningEnvironment(ExecutionId id, Seq<Tuple2<EnvironmentId, Environment>> envIds) {
        package$.MODULE$.atomic().apply((Function1)(JProcedure1 & Serializable)ctx -> {
            this.environmentIds.update((Object)id, (Object)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), ctx);
            envIds.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    EnvironmentId envId = (EnvironmentId)tuple2._1();
                    Environment env = (Environment)tuple2._2();
                    this.environmentIds.update((Object)id, ((SeqOps)this.environmentIds.apply((Object)id, ctx)).$colon$plus((Object)envId), ctx);
                    this.runningEnvironments.update((Object)envId, (Object)RunningEnvironment$.MODULE$.apply(env, RunningEnvironment$.MODULE$.$lessinit$greater$default$2(), RunningEnvironment$.MODULE$.$lessinit$greater$default$3()), ctx);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
        }, MaybeTxn$.MODULE$.unknown());
    }

    public Seq<Tuple2<EnvironmentId, RunningEnvironment>> getRunningEnvironments(ExecutionId id) {
        return (Seq)package$.MODULE$.atomic().apply((Function1 & Serializable)ctx -> this.getRunningEnvironments((Seq<EnvironmentId>)((Seq)TMap$.MODULE$.asMap(this.environmentIds, ctx).getOrElse((Object)id, ServerState::getRunningEnvironments$$anonfun$1$$anonfun$1))), MaybeTxn$.MODULE$.unknown());
    }

    public Seq<Tuple2<EnvironmentId, RunningEnvironment>> getRunningEnvironments(Seq<EnvironmentId> envIds) {
        return (Seq)package$.MODULE$.atomic().apply((Function1 & Serializable)ctx -> (Seq)envIds.flatMap((Function1 & Serializable)id -> this.runningEnvironments.get(id, ctx).map((Function1 & Serializable)r -> {
            EnvironmentId environmentId = (EnvironmentId)Predef$.MODULE$.ArrowAssoc(id);
            return Predef.ArrowAssoc$.MODULE$.$u2192$extension((Object)environmentId, r);
        })), MaybeTxn$.MODULE$.unknown());
    }

    public void deleteEnvironmentErrors(EnvironmentId id) {
        ((Option)package$.MODULE$.atomic().apply((Function1 & Serializable)ctx -> this.runningEnvironments.get((Object)id, ctx).map((Function1 & Serializable)x$1 -> {
            RunningEnvironment runningEnvironment = x$1;
            if (runningEnvironment != null) {
                RunningEnvironment runningEnvironment2 = RunningEnvironment$.MODULE$.unapply(runningEnvironment);
                Environment environment = runningEnvironment2._1();
                NetworkActivity networkActivity = runningEnvironment2._2();
                ExecutionActivity executionActivity = runningEnvironment2._3();
                Environment e = environment;
                return e;
            }
            throw new MatchError((Object)runningEnvironment);
        }), MaybeTxn$.MODULE$.unknown())).foreach((Function1 & Serializable)environment -> Environment$.MODULE$.clearErrors(environment));
    }

    public void removeRunningEnvironments(ExecutionId id) {
        package$.MODULE$.atomic().apply((Function1)(JProcedure1 & Serializable)ctx -> this.environmentIds.remove((Object)id, ctx).foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.foreach((Function1 & Serializable)key -> this.runningEnvironments.remove(key, ctx))), MaybeTxn$.MODULE$.unknown());
    }

    public void addExecutionInfo(ExecutionId key, ExecutionInfo info) {
        package$.MODULE$.atomic().apply((Function1)(JProcedure1 & Serializable)ctx -> this.executionInfo.update((Object)key, (Object)info, ctx), MaybeTxn$.MODULE$.unknown());
    }

    public boolean addMoleExecution(ExecutionId key, MoleExecution moleExecution) {
        return BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.atomic().apply((Function1 & Serializable)ctx -> TMap$.MODULE$.asMap(this.executionInfo, ctx).updateWith((Object)key, (Function1 & Serializable)_$3 -> _$3.map((Function1 & Serializable)e -> {
            Some some = Some$.MODULE$.apply((Object)moleExecution);
            SafePath safePath = e.copy$default$1();
            String string = e.copy$default$2();
            long l = e.copy$default$3();
            StringPrintStream stringPrintStream = e.copy$default$4();
            return e.copy(safePath, string, l, stringPrintStream, (Option<Object>)some);
        })).isDefined(), MaybeTxn$.MODULE$.unknown()));
    }

    public boolean addError(ExecutionId key, ExecutionState.Failed error) {
        return BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.atomic().apply((Function1 & Serializable)ctx -> TMap$.MODULE$.asMap(this.executionInfo, ctx).updateWith((Object)key, (Function1 & Serializable)_$4 -> _$4.map((Function1 & Serializable)e -> {
            Some some = Some$.MODULE$.apply((Object)error);
            SafePath safePath = e.copy$default$1();
            String string = e.copy$default$2();
            long l = e.copy$default$3();
            StringPrintStream stringPrintStream = e.copy$default$4();
            return e.copy(safePath, string, l, stringPrintStream, (Option<Object>)some);
        })).isDefined(), MaybeTxn$.MODULE$.unknown()));
    }

    public void cancel(ExecutionId key) {
        Object object;
        Option option = this.executionInfo.single().get((Object)key).flatMap((Function1 & Serializable)_$5 -> _$5.moleExecution());
        if (option instanceof Some && (object = ((Some)option).value()) instanceof MoleExecution) {
            MoleExecution e = (MoleExecution)object;
            e.cancel();
            return;
        }
    }

    public void remove(ExecutionId key) {
        Object object;
        Option exec = (Option)package$.MODULE$.atomic().apply((Function1 & Serializable)ctx -> {
            this.removeRunningEnvironments(key);
            return this.executionInfo.remove((Object)key, ctx);
        }, MaybeTxn$.MODULE$.unknown());
        Option option = exec.flatMap((Function1 & Serializable)_$6 -> _$6.moleExecution());
        if (option instanceof Some && (object = ((Some)option).value()) instanceof MoleExecution) {
            MoleExecution e = (MoleExecution)object;
            e.cancel();
            return;
        }
    }

    public Seq<EnvironmentState> environmentState(ExecutionId id) {
        return (Seq)this.getRunningEnvironments(id).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                EnvironmentId envId = (EnvironmentId)tuple2._1();
                RunningEnvironment e = (RunningEnvironment)tuple2._2();
                return EnvironmentState$.MODULE$.apply(envId, e.environment().simpleName(), e.environment().running(), e.environment().done(), e.environment().submitted(), e.environment().failed(), e.networkActivity(), e.executionActivity(), this.environmentErrors(envId).length());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Seq<EnvironmentError> environmentErrors(EnvironmentId environmentId) {
        Map errorMap = this.getRunningEnvironments((Seq<EnvironmentId>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EnvironmentId[]{environmentId})).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        RunningEnvironment info = (RunningEnvironment)errorMap.apply((Object)environmentId);
        Seq errors = Environment$.MODULE$.errors(info.environment());
        return (Seq)errors.map((Function1 & Serializable)ex -> {
            Option option = ex.detail();
            if (option instanceof Some) {
                String detail = (String)((Some)option).value();
                return EnvironmentError$.MODULE$.apply(environmentId, ex.exception().getMessage(), (ErrorData)MessageErrorData$.MODULE$.apply(ServerState.completeMessage$1(ex, detail), (Option)Some$.MODULE$.apply((Object)ErrorData$.MODULE$.toStackTrace(ex.exception()))), ex.creationTime(), utils$.MODULE$.javaLevelToErrorLevel(ex.level()));
            }
            if (None$.MODULE$.equals(option)) {
                return EnvironmentError$.MODULE$.apply(environmentId, ex.exception().getMessage(), (ErrorData)ErrorData$.MODULE$.apply(ex.exception()), ex.creationTime(), utils$.MODULE$.javaLevelToErrorLevel(ex.level()));
            }
            throw new MatchError((Object)option);
        });
    }

    public ExecutionState state(ExecutionId key) {
        return (ExecutionState)package$.MODULE$.atomic().apply((Function1 & Serializable)ctx -> {
            Object object;
            Option<Object> option = ((ExecutionInfo)this.executionInfo.apply((Object)key, ctx)).moleExecution();
            if (None$.MODULE$.equals(option)) {
                object = ExecutionState.Preparing$.MODULE$.apply();
                return (ExecutionState)object;
            } else {
                if (!(option instanceof Some)) throw new MatchError(option);
                Object object2 = ((Some)option).value();
                if (object2 instanceof ExecutionState.Failed) {
                    ExecutionState.Failed error = (ExecutionState.Failed)object2;
                    object = error;
                    return (ExecutionState)object;
                } else {
                    if (!(object2 instanceof MoleExecution)) throw new MatchError(option);
                    MoleExecution moleExecution = (MoleExecution)object2;
                    LazyRef lazyRef = new LazyRef();
                    Option option2 = moleExecution.exception(ServerState.moleExecutionAccess$1());
                    if (option2 instanceof Some) {
                        MoleExecution.MoleExecutionFailed t = (MoleExecution.MoleExecutionFailed)((Some)option2).value();
                        object = ExecutionState.Failed$.MODULE$.apply((Seq)ServerState.statuses$1(moleExecution, lazyRef), (ErrorData)ErrorData$.MODULE$.apply(t.exception()), this.environmentState(key), BoxesRunTime.unboxToLong((Object)moleExecution.duration(ServerState.moleExecutionAccess$1()).getOrElse(ServerState::state$$anonfun$1$$anonfun$1)), moleExecution.cleaned(ServerState.moleExecutionAccess$1()));
                        return (ExecutionState)object;
                    } else {
                        object = moleExecution.canceled(ServerState.moleExecutionAccess$1()) ? ExecutionState.Canceled$.MODULE$.apply((Seq)ServerState.statuses$1(moleExecution, lazyRef), this.environmentState(key), BoxesRunTime.unboxToLong((Object)moleExecution.duration(ServerState.moleExecutionAccess$1()).getOrElse(ServerState::state$$anonfun$1$$anonfun$2)), moleExecution.cleaned(ServerState.moleExecutionAccess$1())) : (moleExecution.finished(ServerState.moleExecutionAccess$1()) ? ExecutionState.Finished$.MODULE$.apply((Seq)ServerState.statuses$1(moleExecution, lazyRef), BoxesRunTime.unboxToLong((Object)moleExecution.duration(ServerState.moleExecutionAccess$1()).getOrElse(ServerState::state$$anonfun$1$$anonfun$3)), this.environmentState(key), moleExecution.cleaned(ServerState.moleExecutionAccess$1())) : (moleExecution.started(ServerState.moleExecutionAccess$1()) ? ExecutionState.Running$.MODULE$.apply((Seq)ServerState.statuses$1(moleExecution, lazyRef), BoxesRunTime.unboxToLong((Object)moleExecution.duration(ServerState.moleExecutionAccess$1()).getOrElse(ServerState::state$$anonfun$1$$anonfun$4)), this.environmentState(key)) : ExecutionState.Preparing$.MODULE$.apply()));
                    }
                }
            }
            return (ExecutionState)object;
        }, MaybeTxn$.MODULE$.unknown());
    }

    public Seq<ExecutionData> executionData(int outputLines, Seq<ExecutionId> ids) {
        return (Seq)package$.MODULE$.atomic().apply((Function1 & Serializable)ctx -> {
            Iterable executions = (Iterable)(ids.isEmpty() ? TMap$.MODULE$.asMap(this.executionInfo, ctx).keys() : ids).flatMap((Function1 & Serializable)id -> this.executionInfo.get(id, ctx).map((Function1 & Serializable)executionInfo -> {
                Object object = Predef$.MODULE$.refArrayOps(executionInfo.output().toString().lines().toArray());
                String output = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.takeRight$extension(object, outputLines)).mkString("\n");
                ExecutionState stateValue = this.state((ExecutionId)id);
                long executionTime = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.environments$1((InTxn)ctx, (ExecutionId)id).map((Function1 & Serializable)_$7 -> _$7.executionActivity().executionTime())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                return ExecutionData$.MODULE$.apply(id, executionInfo.path(), executionInfo.script(), executionInfo.startDate(), stateValue, output, executionTime);
            }));
            return (Seq)executions.toSeq().sortBy((Function1 & Serializable)_$8 -> _$8.startDate(), (Ordering)Ordering.Long$.MODULE$);
        }, MaybeTxn$.MODULE$.unknown());
    }

    public boolean addNotification(Function1<Object, NotificationEvent> notificationEvent) {
        return BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.atomic().apply((Function1 & Serializable)ctx -> {
            long id = BoxesRunTime.unboxToLong((Object)this.notificationEventId.apply(ctx));
            this.notificationEventId.update((Object)BoxesRunTime.boxToLong((long)(id + 1L)), ctx);
            return this.notificationEvents.add(notificationEvent.apply((Object)BoxesRunTime.boxToLong((long)id)), ctx);
        }, MaybeTxn$.MODULE$.unknown()));
    }

    public Object clearNotification(Seq<Object> ids) {
        return package$.MODULE$.atomic().apply((Function1 & Serializable)ctx -> {
            if (ids.isEmpty()) {
                TSet$.MODULE$.asSet(this.notificationEvents, ctx).clear();
                return BoxedUnit.UNIT;
            }
            Set idSet = ids.toSet();
            return this.notificationEvents.filterInPlace((Function1 & Serializable)e -> !idSet.contains((Object)BoxesRunTime.boxToLong((long)NotificationEvent$.MODULE$.id(e))), ctx);
        }, MaybeTxn$.MODULE$.unknown());
    }

    public Seq<NotificationEvent> listNotification() {
        return this.notificationEvents.single().toSeq();
    }

    public static final boolean org$openmole$gui$server$core$ServerState$$anon$1$$_$canceled$1(MoleExecution.Finished f$1, MoleExecution ex$1) {
        return f$1.canceled() && !ex$1.exception((MoleExecution.SynchronisationContext)MoleExecution.SynchronisationContext$.MODULE$.default()).isDefined();
    }

    public static final /* synthetic */ MessageErrorData org$openmole$gui$server$core$ServerState$$anon$1$$_$applyOrElse$$anonfun$1$$anonfun$1(MoleExecution.MoleExecutionFailed t) {
        return ErrorData$.MODULE$.apply(MoleExecution.MoleExecutionFailed$.MODULE$.exception(t));
    }

    public static final /* synthetic */ RunningEnvironment org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$2(RunningEnvironment env) {
        NetworkActivity na = env.networkActivity();
        NetworkActivity networkActivity = na.copy(na.downloadingFiles() + 1, na.copy$default$2(), na.copy$default$3(), na.copy$default$4(), na.copy$default$5(), na.copy$default$6());
        Environment environment = env.copy$default$1();
        ExecutionActivity executionActivity = env.copy$default$3();
        return env.copy(environment, networkActivity, executionActivity);
    }

    public static final /* synthetic */ RunningEnvironment org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$3(BatchEnvironment.EndDownload edl$1, RunningEnvironment env) {
        NetworkActivity na = env.networkActivity();
        long size = na.downloadedSize() + (edl$1.success() ? edl$1.size() : 0L);
        NetworkActivity networkActivity = na.copy(na.downloadingFiles() - 1, size, org.openmole.tool.file.package$.MODULE$.readableByteCount(size), na.copy$default$4(), na.copy$default$5(), na.copy$default$6());
        Environment environment = env.copy$default$1();
        ExecutionActivity executionActivity = env.copy$default$3();
        return env.copy(environment, networkActivity, executionActivity);
    }

    public static final /* synthetic */ RunningEnvironment org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$4(RunningEnvironment env) {
        NetworkActivity na = env.networkActivity();
        int n = na.uploadingFiles() + 1;
        int n2 = na.copy$default$1();
        long l = na.copy$default$2();
        String string = na.copy$default$3();
        long l2 = na.copy$default$5();
        String string2 = na.copy$default$6();
        NetworkActivity networkActivity = na.copy(n2, l, string, n, l2, string2);
        Environment environment = env.copy$default$1();
        ExecutionActivity executionActivity = env.copy$default$3();
        return env.copy(environment, networkActivity, executionActivity);
    }

    public static final /* synthetic */ RunningEnvironment org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$5(BatchEnvironment.EndUpload eul$1, RunningEnvironment env) {
        NetworkActivity na = env.networkActivity();
        long size = na.uploadedSize() + (eul$1.success() ? eul$1.size() : 0L);
        String string = org.openmole.tool.file.package$.MODULE$.readableByteCount(size);
        int n = na.uploadingFiles() - 1;
        int n2 = na.copy$default$1();
        long l = na.copy$default$2();
        String string2 = na.copy$default$3();
        NetworkActivity networkActivity = na.copy(n2, l, string2, n, size, string);
        Environment environment = env.copy$default$1();
        ExecutionActivity executionActivity = env.copy$default$3();
        return env.copy(environment, networkActivity, executionActivity);
    }

    public static final /* synthetic */ RunningEnvironment org$openmole$gui$server$core$ServerState$$anon$2$$_$applyOrElse$$anonfun$6(Environment.JobCompleted j$1, RunningEnvironment env) {
        ExecutionActivity ex = env.executionActivity();
        ExecutionActivity executionActivity = ex.copy(ex.executionTime() + j$1.log().executionEndTime() - j$1.log().executionBeginTime());
        Environment environment = env.copy$default$1();
        NetworkActivity networkActivity = env.copy$default$2();
        return env.copy(environment, networkActivity, executionActivity);
    }

    private static final Seq getRunningEnvironments$$anonfun$1$$anonfun$1() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    private static final String completeMessage$1(ExceptionEvent ex$3, String detail$1) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(ex$3.exception().getMessage() + "\n               |" + detail$1));
    }

    private static final MoleExecution.SynchronisationContext moleExecutionAccess$1() {
        return MoleExecution.UnsafeAccess$.MODULE$;
    }

    private static final ExecutionState.JobStatuses convertStatuses$1(MoleExecution.JobStatuses s) {
        return ExecutionState.JobStatuses$.MODULE$.apply(s.ready(), s.running(), s.completed());
    }

    private static final String scopeToString$1(DefinitionScope scope) {
        DefinitionScope definitionScope = scope;
        if (DefinitionScope.User$.MODULE$.equals(definitionScope)) {
            return "user";
        }
        if (definitionScope instanceof DefinitionScope.Internal) {
            String string;
            DefinitionScope.Internal internal = DefinitionScope.Internal$.MODULE$.unapply((DefinitionScope.Internal)definitionScope);
            String name = string = internal._1();
            return name;
        }
        throw new MatchError((Object)definitionScope);
    }

    private static final boolean isUser$1(Task t) {
        DefinitionScope definitionScope = t.info().definitionScope();
        DefinitionScope.User$ user$ = DefinitionScope.User$.MODULE$;
        return !(definitionScope != null ? !definitionScope.equals(user$) : user$ != null);
    }

    private static final int cardinality$1(Task t2) {
        Task task = t2;
        if (task instanceof MoleTask) {
            MoleTask m = (MoleTask)task;
            return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)MoleTask$.MODULE$.tasks(m).map((Function1 & Serializable)t -> ServerState.cardinality$1(t))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        Task t3 = task;
        if (ServerState.isUser$1(t3)) {
            return 1;
        }
        Task t4 = task;
        return 0;
    }

    private static final Vector statuses$lzyINIT1$1(MoleExecution moleExecution$6, LazyRef statuses$lzy1$1) {
        Vector vector;
        LazyRef lazyRef = statuses$lzy1$1;
        synchronized (lazyRef) {
            vector = (Vector)(statuses$lzy1$1.initialized() ? statuses$lzy1$1.value() : statuses$lzy1$1.initialize((Object)((Vector)moleExecution$6.capsuleStatuses(ServerState.moleExecutionAccess$1()).toVector().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    MoleCapsule k = (MoleCapsule)tuple2._1();
                    MoleExecution.JobStatuses v = (MoleExecution.JobStatuses)tuple2._2();
                    Task task = k.task(moleExecution$6.mole(), moleExecution$6.sources(), moleExecution$6.hooks());
                    return ExecutionState.CapsuleExecution$.MODULE$.apply(task.simpleName(), ServerState.scopeToString$1(task.info().definitionScope()), ServerState.convertStatuses$1(v), ServerState.isUser$1(task), ServerState.cardinality$1(task));
                }
                throw new MatchError((Object)tuple2);
            }))));
        }
        return vector;
    }

    private static final Vector statuses$1(MoleExecution moleExecution$8, LazyRef statuses$lzy1$2) {
        return (Vector)(statuses$lzy1$2.initialized() ? statuses$lzy1$2.value() : ServerState.statuses$lzyINIT1$1(moleExecution$8, statuses$lzy1$2));
    }

    private static final long state$$anonfun$1$$anonfun$1() {
        return 0L;
    }

    private static final long state$$anonfun$1$$anonfun$2() {
        return 0L;
    }

    private static final long state$$anonfun$1$$anonfun$3() {
        return 0L;
    }

    private static final long state$$anonfun$1$$anonfun$4() {
        return 0L;
    }

    private final Seq environments$1(InTxn ctx$8, ExecutionId id$8) {
        return (Seq)((IterableOps)Option$.MODULE$.option2Iterable(this.environmentIds.get((Object)id$8, ctx$8)).toSeq().flatten(Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable)key -> this.runningEnvironments.get(key, ctx$8));
    }

    public static class ExecutionInfo
    implements Product,
    Serializable {
        private final SafePath path;
        private final String script;
        private final long startDate;
        private final StringPrintStream output;
        private final Option moleExecution;

        public static ExecutionInfo apply(SafePath safePath, String string, long l, StringPrintStream stringPrintStream, Option<Object> option) {
            return ServerState$ExecutionInfo$.MODULE$.apply(safePath, string, l, stringPrintStream, option);
        }

        public static ExecutionInfo fromProduct(Product product) {
            return ServerState$ExecutionInfo$.MODULE$.fromProduct(product);
        }

        public static ExecutionInfo unapply(ExecutionInfo executionInfo) {
            return ServerState$ExecutionInfo$.MODULE$.unapply(executionInfo);
        }

        public ExecutionInfo(SafePath path, String script, long startDate, StringPrintStream output, Option<Object> moleExecution) {
            this.path = path;
            this.script = script;
            this.startDate = startDate;
            this.output = output;
            this.moleExecution = moleExecution;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.script()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.startDate()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.output()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.moleExecution()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ExecutionInfo)) return false;
            ExecutionInfo executionInfo = (ExecutionInfo)object;
            if (this.startDate() != executionInfo.startDate()) return false;
            SafePath safePath = this.path();
            SafePath safePath2 = executionInfo.path();
            if (safePath == null) {
                if (safePath2 != null) {
                    return false;
                }
            } else if (!safePath.equals(safePath2)) return false;
            String string = this.script();
            String string2 = executionInfo.script();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            StringPrintStream stringPrintStream = this.output();
            StringPrintStream stringPrintStream2 = executionInfo.output();
            if (stringPrintStream == null) {
                if (stringPrintStream2 != null) {
                    return false;
                }
            } else if (!stringPrintStream.equals(stringPrintStream2)) return false;
            Option<Object> option = this.moleExecution();
            Option<Object> option2 = executionInfo.moleExecution();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!executionInfo.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ExecutionInfo;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "ExecutionInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "path";
                }
                case 1: {
                    return "script";
                }
                case 2: {
                    return "startDate";
                }
                case 3: {
                    return "output";
                }
                case 4: {
                    return "moleExecution";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SafePath path() {
            return this.path;
        }

        public String script() {
            return this.script;
        }

        public long startDate() {
            return this.startDate;
        }

        public StringPrintStream output() {
            return this.output;
        }

        public Option<Object> moleExecution() {
            return this.moleExecution;
        }

        public ExecutionInfo copy(SafePath path, String script, long startDate, StringPrintStream output, Option<Object> moleExecution) {
            return new ExecutionInfo(path, script, startDate, output, moleExecution);
        }

        public SafePath copy$default$1() {
            return this.path();
        }

        public String copy$default$2() {
            return this.script();
        }

        public long copy$default$3() {
            return this.startDate();
        }

        public StringPrintStream copy$default$4() {
            return this.output();
        }

        public Option<Object> copy$default$5() {
            return this.moleExecution();
        }

        public SafePath _1() {
            return this.path();
        }

        public String _2() {
            return this.script();
        }

        public long _3() {
            return this.startDate();
        }

        public StringPrintStream _4() {
            return this.output();
        }

        public Option<Object> _5() {
            return this.moleExecution();
        }
    }
}

