/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.networkservice;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.openmole.core.exception.InternalProcessingError;
import org.openmole.core.exception.InternalProcessingError$;
import org.openmole.core.networkservice.NetworkService;
import org.openmole.core.networkservice.NetworkService$HttpHost$;
import org.openmole.core.preference.ClearPreferenceLocation;
import org.openmole.core.preference.ConfigurationString$;
import org.openmole.core.preference.Preference;
import org.openmole.core.preference.PreferenceLocation$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class NetworkService$
implements Serializable {
    private static final ClearPreferenceLocation httpProxyEnabled;
    private static final ClearPreferenceLocation httpProxyURI;
    public static final NetworkService$HttpHost$ HttpHost;
    public static final NetworkService$ MODULE$;

    private NetworkService$() {
    }

    static {
        MODULE$ = new NetworkService$();
        httpProxyEnabled = PreferenceLocation$.MODULE$.apply("NetworkService", "HttpProxyEnabled", MODULE$::$init$$$anonfun$1);
        httpProxyURI = PreferenceLocation$.MODULE$.apply("NetworkService", "httpProxyURI", MODULE$::$init$$$anonfun$2);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NetworkService$.class);
    }

    public ClearPreferenceLocation<Object> httpProxyEnabled() {
        return httpProxyEnabled;
    }

    public ClearPreferenceLocation<String> httpProxyURI() {
        return httpProxyURI;
    }

    public Option<NetworkService.HttpHost> httpHostFromPreferences(Preference preference) {
        Option hostURIOpt;
        Option isEnabledOpt = preference.preferenceOption(this.httpProxyEnabled(), ConfigurationString$.MODULE$.given_ConfigurationString_Boolean());
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)isEnabledOpt, (Object)(hostURIOpt = preference.preferenceOption(this.httpProxyURI(), ConfigurationString$.MODULE$.given_ConfigurationString_String())));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some && !BoxesRunTime.unboxToBoolean((Object)((Some)option).value()) || None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                String hostURI;
                String string = (String)((Some)option2).value();
                if (string != null && (hostURI = string).trim().isEmpty()) {
                    return None$.MODULE$;
                }
                String hostURI2 = string;
                return Some$.MODULE$.apply((Object)NetworkService$HttpHost$.MODULE$.apply(hostURI2));
            }
        }
        return None$.MODULE$;
    }

    public NetworkService apply(Option<String> hostURI, Preference preference) {
        return new NetworkService((Option<NetworkService.HttpHost>)hostURI.map((Function1 & Serializable)_$1 -> NetworkService$HttpHost$.MODULE$.apply((String)_$1)).orElse(() -> this.apply$$anonfun$2(preference)));
    }

    public String get(String url, Seq<Tuple2<String, String>> headers, NetworkService networkService) {
        InputStream is = this.getInputStream(url, headers, networkService);
        String res = Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString();
        is.close();
        return res;
    }

    public Seq<Tuple2<String, String>> get$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private CloseableHttpClient newClient(NetworkService networkService) {
        NetworkService.HttpHost httpHost;
        Option<NetworkService.HttpHost> option = networkService.httpProxy();
        if (option instanceof Some && (httpHost = (NetworkService.HttpHost)((Some)option).value()) != null) {
            NetworkService.HttpHost httpHost2 = httpHost;
            return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager()).setProxy(httpHost2.toHost()).build();
        }
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager()).build();
    }

    public <T> T withResponse(String url, Seq<Tuple2<String, String>> headers, Function1<CloseableHttpResponse, T> f, NetworkService x$4) {
        Object object;
        CloseableHttpClient client = this.newClient(x$4);
        HttpGet getReq = new HttpGet(url);
        headers.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            String string = (String)x$1._1();
            String string2 = (String)x$1._2();
            getReq.setHeader((Header)new BasicHeader(string, string2));
        });
        try {
            try (CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)getReq);){
                object = f.apply((Object)httpResponse);
            }
            catch (Throwable t) {
                throw new InternalProcessingError("HTTP GET for " + url + " failed", t);
            }
        }
        finally {
            client.close();
        }
        return (T)object;
    }

    public <T> Seq<Tuple2<String, String>> withResponse$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public InputStream getInputStream(String url, Seq<Tuple2<String, String>> headers, NetworkService x$3) {
        InputStream inputStream;
        CloseableHttpClient client = this.newClient(x$3);
        HttpGet getReq = new HttpGet(url);
        headers.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            String string = (String)x$1._1();
            String string2 = (String)x$1._2();
            getReq.setHeader((Header)new BasicHeader(string, string2));
        });
        try {
            CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)getReq);
            if (httpResponse.getStatusLine().getStatusCode() >= 300) {
                throw new InternalProcessingError("HTTP GET for " + url + " responded with " + httpResponse, InternalProcessingError$.MODULE$.$lessinit$greater$default$2());
            }
            inputStream = httpResponse.getEntity().getContent();
        }
        catch (Throwable t) {
            throw new InternalProcessingError("HTTP GET for " + url + " failed", t);
        }
        return inputStream;
    }

    public Seq<Tuple2<String, String>> getInputStream$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public String urlProtocol(String url) {
        return new URI(url).getScheme();
    }

    public Seq<Tuple2<String, String>> proxyVariables(NetworkService networkService) {
        Option<NetworkService.HttpHost> option = networkService.httpProxy();
        if (option instanceof Some) {
            NetworkService.HttpHost proxy = (NetworkService.HttpHost)((Some)option).value();
            Object[] objectArray = new Tuple2[4];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"http_proxy");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)proxy.hostURI());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"HTTP_PROXY");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)proxy.hostURI());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"https_proxy");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)proxy.hostURI());
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"HTTPS_PROXY");
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)proxy.hostURI());
            return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (None$.MODULE$.equals(option)) {
            return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }
        throw new MatchError(option);
    }

    private final Option $init$$$anonfun$1() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    private final Option $init$$$anonfun$2() {
        return Option$.MODULE$.empty();
    }

    private final Option apply$$anonfun$2(Preference preference$1) {
        return this.httpHostFromPreferences(preference$1);
    }
}

