/*
 * Decompiled with CFR 0.152.
 */
package squants;

import scala.Option;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.runtime.BoxesRunTime;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.UnitOfMeasure;

public abstract class AbstractQuantityNumeric<A extends Quantity<A>>
implements Numeric<A> {
    private final PrimaryUnit unit;

    public <A extends Quantity<A>> AbstractQuantityNumeric(PrimaryUnit unit) {
        this.unit = unit;
        PartialOrdering.$init$((PartialOrdering)this);
        Ordering.$init$((Ordering)this);
        Numeric.$init$((Numeric)this);
    }

    public PrimaryUnit unit() {
        return this.unit;
    }

    public A plus(A x, A y) {
        return ((Quantity)x).$plus(y);
    }

    public A minus(A x, A y) {
        return ((Quantity)x).$minus(y);
    }

    public A times(A x, A y) {
        throw new UnsupportedOperationException("Numeric.times not supported for Quantities");
    }

    public A negate(A x) {
        return ((Quantity)x).unary_$minus();
    }

    public A fromInt(int x) {
        return ((UnitOfMeasure)((Object)this.unit())).apply(BoxesRunTime.boxToInteger((int)x), Numeric.IntIsIntegral$.MODULE$);
    }

    public int toInt(A x) {
        return (int)((Quantity)x).to((UnitOfMeasure)((Object)this.unit()));
    }

    public long toLong(A x) {
        return (long)((Quantity)x).to((UnitOfMeasure)((Object)this.unit()));
    }

    public float toFloat(A x) {
        return (float)((Quantity)x).to((UnitOfMeasure)((Object)this.unit()));
    }

    public double toDouble(A x) {
        return ((Quantity)x).to((UnitOfMeasure)((Object)this.unit()));
    }

    public int compare(A x, A y) {
        return ((Quantity)x).to((UnitOfMeasure)((Object)this.unit())) > ((Quantity)y).to((UnitOfMeasure)((Object)this.unit())) ? 1 : (((Quantity)x).to((UnitOfMeasure)((Object)this.unit())) < ((Quantity)y).to((UnitOfMeasure)((Object)this.unit())) ? -1 : 0);
    }

    public Option<A> parseString(String str) {
        return ((Quantity)((UnitOfMeasure)((Object)this.unit())).apply(BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$)).dimension().parseString(str).toOption();
    }
}

