/*
 * Decompiled with CFR 0.152.
 */
package squants;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.matching.Regex;
import squants.Platform$;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.QuantityParseException$;
import squants.SiUnit;
import squants.UnitOfMeasure;

public interface Dimension<A extends Quantity<A>> {
    public static void $init$(Dimension $this) {
        $this.squants$Dimension$_setter_$dimensionImplicit_$eq($this);
    }

    public String name();

    public Set<UnitOfMeasure<A>> units();

    public PrimaryUnit primaryUnit();

    public SiUnit siUnit();

    public static Option symbolToUnit$(Dimension $this, String symbol) {
        return $this.symbolToUnit(symbol);
    }

    default public Option<UnitOfMeasure<A>> symbolToUnit(String symbol) {
        return this.units().find((Function1 & Serializable)u -> {
            String string = u.symbol();
            String string2 = symbol;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public static Try parse$(Dimension $this, Object value) {
        return $this.parse(value);
    }

    /*
     * Enabled aggressive block sorting
     */
    default public Try<A> parse(Object value) {
        Try<A> try_;
        Object object = value;
        if (object instanceof String) {
            String s = (String)object;
            try_ = this.parseString(s);
            return try_;
        }
        if (object instanceof Tuple2) {
            Tuple2 tuple2 = (Tuple2)object;
            Object object2 = tuple2._1();
            Object object3 = tuple2._2();
            if (object2 instanceof Byte) {
                byte v = BoxesRunTime.unboxToByte((Object)object2);
                if (object3 instanceof String) {
                    String u = (String)object3;
                    try_ = this.parseTuple((Tuple2)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)v), (Object)u), (Numeric)Numeric.ByteIsIntegral$.MODULE$);
                    return try_;
                }
            }
            if (object2 instanceof Short) {
                short v = BoxesRunTime.unboxToShort((Object)object2);
                if (object3 instanceof String) {
                    String u = (String)object3;
                    try_ = this.parseTuple((Tuple2)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)v), (Object)u), (Numeric)Numeric.ShortIsIntegral$.MODULE$);
                    return try_;
                }
            }
            if (object2 instanceof Integer) {
                int v = BoxesRunTime.unboxToInt((Object)object2);
                if (object3 instanceof String) {
                    String u = (String)object3;
                    try_ = this.parseTuple((Tuple2)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)v), (Object)u), (Numeric)Numeric.IntIsIntegral$.MODULE$);
                    return try_;
                }
            }
            if (object2 instanceof Long) {
                long v = BoxesRunTime.unboxToLong((Object)object2);
                if (object3 instanceof String) {
                    String u = (String)object3;
                    try_ = this.parseTuple((Tuple2)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)v), (Object)u), (Numeric)Numeric.LongIsIntegral$.MODULE$);
                    return try_;
                }
            }
            if (object2 instanceof Float) {
                float v = BoxesRunTime.unboxToFloat((Object)object2);
                if (object3 instanceof String) {
                    String u = (String)object3;
                    try_ = this.parseTuple((Tuple2)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)v), (Object)u), (Numeric)Numeric.FloatIsFractional$.MODULE$);
                    return try_;
                }
            }
            if (object2 instanceof Double) {
                double v = BoxesRunTime.unboxToDouble((Object)object2);
                if (object3 instanceof String) {
                    String u = (String)object3;
                    try_ = this.parseTuple((Tuple2)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)v), (Object)u), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
                    return try_;
                }
            }
        }
        try_ = Failure$.MODULE$.apply((Throwable)QuantityParseException$.MODULE$.apply("Unable to parse " + this.name(), value.toString()));
        return try_;
    }

    public static Try parseString$(Dimension $this, String s) {
        return $this.parseString(s);
    }

    default public Try<A> parseString(String s) {
        Failure failure;
        List list;
        Option option;
        String string = s;
        if (string != null && !(option = this.squants$Dimension$$QuantityString().unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(2) == 0) {
            String string2 = (String)list.apply(0);
            String string3 = (String)list.apply(1);
            String value = string2;
            String symbol = string3;
            failure = Success$.MODULE$.apply(((UnitOfMeasure)this.symbolToUnit(symbol).get()).apply(package$.MODULE$.BigDecimal().apply(value), Numeric.BigDecimalIsFractional$.MODULE$));
        } else {
            failure = Failure$.MODULE$.apply((Throwable)QuantityParseException$.MODULE$.apply("Unable to parse " + this.name(), s));
        }
        return failure;
    }

    public static Regex squants$Dimension$$QuantityString$(Dimension $this) {
        return $this.squants$Dimension$$QuantityString();
    }

    default public Regex squants$Dimension$$QuantityString() {
        return StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?) *(" + ((IterableOnceOps)this.units().map((Function1 & Serializable)u -> u.symbol())).reduceLeft((Function2 & Serializable)(_$1, _$2) -> _$1 + "|" + _$2) + ")$"));
    }

    public static Try parseTuple$(Dimension $this, Tuple2 t, Numeric num) {
        return $this.parseTuple(t, num);
    }

    default public <N> Try<A> parseTuple(Tuple2<N, String> t, Numeric<N> num) {
        Success success;
        Object value = t._1();
        String symbol = (String)t._2();
        Option<UnitOfMeasure<A>> option = this.symbolToUnit(symbol);
        if (option instanceof Some) {
            UnitOfMeasure unit = (UnitOfMeasure)((Some)option).value();
            success = Success$.MODULE$.apply(unit.apply(value, num));
        } else if (None$.MODULE$.equals(option)) {
            success = Failure$.MODULE$.apply((Throwable)QuantityParseException$.MODULE$.apply("Unable to identify " + this.name() + " unit " + symbol, "(" + Platform$.MODULE$.crossFormat(num.toDouble(value)) + "," + symbol + ")"));
        } else {
            throw new MatchError(option);
        }
        return success;
    }

    public Dimension<A> dimensionImplicit();

    public void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension var1);

    public static boolean equals$(Dimension $this, Object that) {
        return $this.equals(that);
    }

    default public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof Dimension) {
            Dimension dimension = (Dimension)object;
            String string = dimension.getClass().getName();
            String string2 = this.getClass().getName();
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public static int hashCode$(Dimension $this) {
        return $this.hashCode();
    }

    default public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

