/*
 * Decompiled with CFR 0.152.
 */
package squants;

import java.io.Serializable;
import java.util.Objects;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.Numeric;
import scala.math.Ordered;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import squants.Dimension;
import squants.Platform$;
import squants.QuantityRange;
import squants.QuantityRange$;
import squants.UnitOfMeasure;
import squants.market.Money;
import squants.market.Price;

public abstract class Quantity<A extends Quantity<A>>
implements Serializable,
Ordered<A> {
    public <A extends Quantity<A>> Quantity() {
        Ordered.$init$((Ordered)this);
    }

    public abstract double value();

    public abstract UnitOfMeasure<A> unit();

    public abstract Dimension<A> dimension();

    public A plus(A that) {
        return this.unit().apply(BoxesRunTime.boxToDouble((double)(this.value() + ((Quantity)that).to(this.unit()))), Numeric.DoubleIsFractional$.MODULE$);
    }

    public A $plus(A that) {
        return this.plus(that);
    }

    public A minus(A that) {
        return this.plus(((Quantity)that).negate());
    }

    public A $minus(A that) {
        return this.minus(that);
    }

    public A times(double that) {
        return this.unit().apply(BoxesRunTime.boxToDouble((double)(this.value() * that)), Numeric.DoubleIsFractional$.MODULE$);
    }

    public A $times(double that) {
        return this.times(that);
    }

    public Money $times(Price<A> that) {
        return that.$times(this);
    }

    public A divide(double that) {
        return this.unit().apply(BoxesRunTime.boxToDouble((double)(this.value() / that)), Numeric.DoubleIsFractional$.MODULE$);
    }

    public A $div(double that) {
        return this.divide(that);
    }

    public double divide(A that) {
        return this.value() / ((Quantity)that).to(this.unit());
    }

    public double $div(A that) {
        return this.divide(that);
    }

    public A remainder(double that) {
        return this.unit().apply(BoxesRunTime.boxToDouble((double)(this.value() % that)), Numeric.DoubleIsFractional$.MODULE$);
    }

    public A $percent(double that) {
        return this.remainder(that);
    }

    public double remainder(A that) {
        return this.value() % ((Quantity)that).to(this.unit());
    }

    public double $percent(A that) {
        return this.remainder(that);
    }

    public Tuple2<A, A> divideAndRemainder(double that) {
        Tuple2 tuple2 = scala.package$.MODULE$.BigDecimal().apply(this.value()).$div$percent(BigDecimal$.MODULE$.double2bigDecimal(that));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BigDecimal q = (BigDecimal)tuple2._1();
        BigDecimal r = (BigDecimal)tuple2._2();
        return Tuple2$.MODULE$.apply(this.unit().apply(BoxesRunTime.boxToDouble((double)q.toDouble()), Numeric.DoubleIsFractional$.MODULE$), this.unit().apply(BoxesRunTime.boxToDouble((double)r.toDouble()), Numeric.DoubleIsFractional$.MODULE$));
    }

    public Tuple2<A, A> $div$percent(double that) {
        return this.divideAndRemainder((A)that);
    }

    public Tuple2<Object, A> divideAndRemainder(A that) {
        Tuple2 tuple2 = scala.package$.MODULE$.BigDecimal().apply(this.value()).$div$percent(BigDecimal$.MODULE$.double2bigDecimal(((Quantity)that).to(this.unit())));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BigDecimal q = (BigDecimal)tuple2._1();
        BigDecimal r = (BigDecimal)tuple2._2();
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)q.toDouble()), this.unit().apply(BoxesRunTime.boxToDouble((double)r.toDouble()), Numeric.DoubleIsFractional$.MODULE$));
    }

    public Tuple2<Object, A> $div$percent(A that) {
        return this.divideAndRemainder(that);
    }

    public A negate() {
        return this.unit().apply(BoxesRunTime.boxToDouble((double)(-this.value())), Numeric.DoubleIsFractional$.MODULE$);
    }

    public A unary_$minus() {
        return this.negate();
    }

    public A abs() {
        return this.unit().apply(BoxesRunTime.boxToDouble((double)package$.MODULE$.abs(this.value())), Numeric.DoubleIsFractional$.MODULE$);
    }

    public A ceil() {
        return this.unit().apply(BoxesRunTime.boxToDouble((double)package$.MODULE$.ceil(this.value())), Numeric.DoubleIsFractional$.MODULE$);
    }

    public A floor() {
        return this.unit().apply(BoxesRunTime.boxToDouble((double)package$.MODULE$.floor(this.value())), Numeric.DoubleIsFractional$.MODULE$);
    }

    public A rint() {
        return this.unit().apply(BoxesRunTime.boxToDouble((double)package$.MODULE$.rint(this.value())), Numeric.DoubleIsFractional$.MODULE$);
    }

    public A rounded(int scale, Enumeration.Value mode) {
        return this.unit().apply(scala.package$.MODULE$.BigDecimal().apply(this.value()).setScale(scale, mode), Numeric.BigDecimalIsFractional$.MODULE$);
    }

    public Enumeration.Value rounded$default$2() {
        return BigDecimal.RoundingMode$.MODULE$.HALF_EVEN();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Quantity)) return false;
        Quantity x = (Quantity)object;
        Dimension<A> dimension = x.dimension();
        Dimension<A> dimension2 = this.dimension();
        if (dimension == null) {
            if (dimension2 != null) {
                return false;
            }
        } else if (!((Object)dimension).equals(dimension2)) return false;
        if (this.value() != x.to(this.unit())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.dimension(), BoxesRunTime.boxToDouble((double)this.to((UnitOfMeasure)((Object)this.dimension().primaryUnit()))));
    }

    public boolean approx(A that, A tolerance) {
        return ((Quantity)that).within(this.plusOrMinus(tolerance));
    }

    public boolean $eq$tilde(A that, A tolerance) {
        return this.approx(that, tolerance);
    }

    public boolean $u2248(A that, A tolerance) {
        return this.approx(that, tolerance);
    }

    public boolean $tilde$eq(A that, A tolerance) {
        return this.approx(that, tolerance);
    }

    public int compare(A that) {
        return this.value() > ((Quantity)that).to(this.unit()) ? 1 : (this.value() < ((Quantity)that).to(this.unit()) ? -1 : 0);
    }

    public A max(A that) {
        return (A)(this.value() >= ((Quantity)that).to(this.unit()) ? this : that);
    }

    public A min(A that) {
        return (A)(this.value() <= ((Quantity)that).to(this.unit()) ? this : that);
    }

    public QuantityRange<A> plusOrMinus(A that) {
        return QuantityRange$.MODULE$.apply(this.$minus(that), this.$plus(that));
    }

    public QuantityRange<A> $plus$minus(A that) {
        return this.plusOrMinus(that);
    }

    public QuantityRange<A> to(A that) {
        return QuantityRange$.MODULE$.apply(this.$div(1.0), that);
    }

    public boolean within(QuantityRange<A> range) {
        return range.contains(this);
    }

    public boolean notWithin(QuantityRange<A> range) {
        return !range.contains(this);
    }

    public double to(UnitOfMeasure<A> uom) {
        UnitOfMeasure<A> unitOfMeasure;
        UnitOfMeasure<A> u;
        UnitOfMeasure<A> unitOfMeasure2 = u = (unitOfMeasure = uom);
        UnitOfMeasure<A> unitOfMeasure3 = this.unit();
        return !(unitOfMeasure2 != null ? !unitOfMeasure2.equals(unitOfMeasure3) : unitOfMeasure3 != null) ? this.value() : uom.convertTo(BoxesRunTime.boxToDouble((double)this.unit().convertFrom(BoxesRunTime.boxToDouble((double)this.value()), Numeric.DoubleIsFractional$.MODULE$)), Numeric.DoubleIsFractional$.MODULE$);
    }

    public A in(UnitOfMeasure<A> uom) {
        UnitOfMeasure<A> unitOfMeasure;
        UnitOfMeasure<A> u;
        UnitOfMeasure<A> unitOfMeasure2 = u = (unitOfMeasure = uom);
        UnitOfMeasure<A> unitOfMeasure3 = this.unit();
        return (A)(!(unitOfMeasure2 != null ? !unitOfMeasure2.equals(unitOfMeasure3) : unitOfMeasure3 != null) ? this : uom.apply(BoxesRunTime.boxToDouble((double)uom.convertTo(BoxesRunTime.boxToDouble((double)this.unit().convertFrom(BoxesRunTime.boxToDouble((double)this.value()), Numeric.DoubleIsFractional$.MODULE$)), Numeric.DoubleIsFractional$.MODULE$)), Numeric.DoubleIsFractional$.MODULE$));
    }

    public String toString() {
        return this.toString(this.unit());
    }

    public String toString(UnitOfMeasure<A> uom) {
        return "" + Platform$.MODULE$.crossFormat(this.to(uom)) + " " + uom.symbol();
    }

    public String toString(UnitOfMeasure<A> uom, String format) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(format), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.to(uom))})), uom.symbol()}));
    }

    public Tuple2<Object, String> toTuple() {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)this.value()), (Object)this.unit().symbol());
    }

    public Tuple2<Object, String> toTuple(UnitOfMeasure<A> uom) {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)this.to(uom)), (Object)uom.symbol());
    }

    public A map(Function1<Object, Object> f) {
        return this.unit().apply(BoxesRunTime.boxToDouble((double)f.apply$mcDD$sp(this.value())), Numeric.DoubleIsFractional$.MODULE$);
    }
}

