/*
 * Decompiled with CFR 0.152.
 */
package squants;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import squants.DoubleVector;
import squants.DoubleVector$;
import squants.Quantity;
import squants.QuantityVector$;
import squants.SVector;
import squants.UnitOfMeasure;
import squants.package$;
import squants.space.Angle;
import squants.space.AngleUnit;

public class QuantityVector<A extends Quantity<A>>
implements SVector<A>,
Product,
Serializable {
    private final Seq coordinates;

    public static <A extends Quantity<A>> QuantityVector<A> apply(Seq<A> seq) {
        return QuantityVector$.MODULE$.apply(seq);
    }

    public static QuantityVector fromProduct(Product product) {
        return QuantityVector$.MODULE$.fromProduct(product);
    }

    public static <A extends Quantity<A>> QuantityVector<A> unapplySeq(QuantityVector<A> quantityVector) {
        return QuantityVector$.MODULE$.unapplySeq(quantityVector);
    }

    public <A extends Quantity<A>> QuantityVector(Seq<A> coordinates) {
        this.coordinates = coordinates;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof QuantityVector)) return false;
        QuantityVector quantityVector = (QuantityVector)object;
        Seq<A> seq = this.coordinates();
        Seq<A> seq2 = quantityVector.coordinates();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!quantityVector.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof QuantityVector;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "QuantityVector";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return this._1();
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return "coordinates";
    }

    @Override
    public Seq<A> coordinates() {
        return this.coordinates;
    }

    public UnitOfMeasure<A> valueUnit() {
        return ((Quantity)this.coordinates().apply(0)).unit();
    }

    @Override
    public A magnitude() {
        return this.valueUnit().apply(BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)this.coordinates().map((Function1 & Serializable)v -> v.to(this.valueUnit()) * v.to(this.valueUnit()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)))), Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Angle angle(int coordinateX, int coordinateY, AngleUnit unit) {
        return package$.MODULE$.Radians().apply(BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.atan(((Quantity)this.coordinates().apply(coordinateY)).$div((Quantity)this.coordinates().apply(coordinateX)))), (Numeric)Numeric.DoubleIsFractional$.MODULE$).in(unit);
    }

    @Override
    public int angle$default$1() {
        return 0;
    }

    @Override
    public int angle$default$2() {
        return 1;
    }

    @Override
    public AngleUnit angle$default$3() {
        return package$.MODULE$.Radians();
    }

    @Override
    public QuantityVector normalize() {
        return (QuantityVector)this.$div(((Quantity)this.magnitude()).to(this.valueUnit()));
    }

    public QuantityVector<A> normalize(UnitOfMeasure<A> unit) {
        return (QuantityVector)this.$div(((Quantity)this.magnitude()).to(unit));
    }

    public <B> DoubleVector map(Function1<A, Object> f) {
        return DoubleVector$.MODULE$.apply((Seq<Object>)((Seq)this.coordinates().map(f)));
    }

    public <B extends Quantity<B>> QuantityVector<B> map(Function1<A, B> f) {
        return QuantityVector$.MODULE$.apply((Seq)this.coordinates().map(f));
    }

    public QuantityVector plus(QuantityVector that) {
        return QuantityVector$.MODULE$.apply((Seq)((IterableOps)this.coordinates().zipAll(that.coordinates(), this.valueUnit().apply(BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$), this.valueUnit().apply(BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$))).map((Function1 & Serializable)v -> ((Quantity)v._1()).$plus((Quantity)v._2())));
    }

    public QuantityVector minus(QuantityVector that) {
        return QuantityVector$.MODULE$.apply((Seq)((IterableOps)this.coordinates().zipAll(that.coordinates(), this.valueUnit().apply(BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$), this.valueUnit().apply(BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$))).map((Function1 & Serializable)v -> ((Quantity)v._1()).$minus((Quantity)v._2())));
    }

    @Override
    public QuantityVector times(double that) {
        return this.map((Function1<A, B>)(Function1 & Serializable)_$4 -> _$4.$times(that));
    }

    public <B extends Quantity<B>, C extends Quantity<C>> QuantityVector<C> times(Function1<A, C> quantTimes) {
        return this.map((Function1<A, B>)quantTimes);
    }

    @Override
    public QuantityVector divide(double that) {
        return this.map((Function1<A, B>)(Function1 & Serializable)_$5 -> _$5.$div(that));
    }

    public DoubleVector divide(A that) {
        return this.map((Function1<A, Object>)(Function1 & Serializable)_$6 -> _$6.$div(that));
    }

    public DoubleVector $div(A that) {
        return this.divide(that);
    }

    public <B extends Quantity<B>, C extends Quantity<C>> QuantityVector<C> divide(Function1<A, C> quantDiv) {
        return this.map((Function1<A, B>)(Function1 & Serializable)_$7 -> (Quantity)quantDiv.apply(_$7));
    }

    @Override
    public A dotProduct(DoubleVector that) {
        return this.valueUnit().apply(((IterableOnceOps)((IterableOps)this.coordinates().zipAll(that.coordinates(), this.valueUnit().apply(BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$), (Object)BoxesRunTime.boxToDouble((double)0.0))).map((Function1 & Serializable)v -> ((Quantity)v._1()).to(this.valueUnit()) * BoxesRunTime.unboxToDouble((Object)v._2()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$), Numeric.DoubleIsFractional$.MODULE$);
    }

    public <B extends Quantity<B>, C extends Quantity<C>> C dotProduct(SVector<B> that, Function2<A, B, C> quantTimes, Numeric<C> num) {
        return (C)((Quantity)((IterableOnceOps)((IterableOps)this.coordinates().zipAll(that.coordinates(), this.valueUnit().apply(BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$), ((Quantity)that.coordinates().head()).unit().apply(BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$))).map((Function1 & Serializable)v -> (Quantity)quantTimes.apply(v._1(), v._2()))).sum(num));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public QuantityVector crossProduct(DoubleVector that) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.coordinates().length()), (Object)BoxesRunTime.boxToInteger((int)that.coordinates().length()));
        if (tuple2 == null) throw new UnsupportedOperationException("Cross Product is not supported on vectors with an arbitrary number of dimensions");
        int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
        int n2 = BoxesRunTime.unboxToInt((Object)tuple2._2());
        if (3 == n && 3 == n2) return QuantityVector$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Quantity[]{((Quantity)((Quantity)this.coordinates().apply(1)).$times(BoxesRunTime.unboxToDouble((Object)that.coordinates().apply(2)))).$minus(((Quantity)this.coordinates().apply(2)).$times(BoxesRunTime.unboxToDouble((Object)that.coordinates().apply(1)))), ((Quantity)((Quantity)this.coordinates().apply(2)).$times(BoxesRunTime.unboxToDouble((Object)that.coordinates().apply(0)))).$minus(((Quantity)this.coordinates().apply(0)).$times(BoxesRunTime.unboxToDouble((Object)that.coordinates().apply(2)))), ((Quantity)((Quantity)this.coordinates().apply(0)).$times(BoxesRunTime.unboxToDouble((Object)that.coordinates().apply(1)))).$minus(((Quantity)this.coordinates().apply(1)).$times(BoxesRunTime.unboxToDouble((Object)that.coordinates().apply(0))))}));
        if (7 != n || 7 != n2) throw new UnsupportedOperationException("Cross Product is not supported on vectors with an arbitrary number of dimensions");
        throw new UnsupportedOperationException("Seven-dimensional Cross Product is not currently supported");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <B extends Quantity<B>, C extends Quantity<C>> QuantityVector<C> crossProduct(SVector<B> that, Function2<A, B, C> quantTimes) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.coordinates().length()), (Object)BoxesRunTime.boxToInteger((int)that.coordinates().length()));
        if (tuple2 == null) throw new UnsupportedOperationException("Cross Product is not supported on vectors with an arbitrary number of dimensions");
        int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
        int n2 = BoxesRunTime.unboxToInt((Object)tuple2._2());
        if (3 == n && 3 == n2) return QuantityVector$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Quantity[]{((Quantity)quantTimes.apply(this.coordinates().apply(1), that.coordinates().apply(2))).$minus((Quantity)quantTimes.apply(this.coordinates().apply(2), that.coordinates().apply(1))), ((Quantity)quantTimes.apply(this.coordinates().apply(2), that.coordinates().apply(0))).$minus((Quantity)quantTimes.apply(this.coordinates().apply(0), that.coordinates().apply(2))), ((Quantity)quantTimes.apply(this.coordinates().apply(0), that.coordinates().apply(1))).$minus((Quantity)quantTimes.apply(this.coordinates().apply(1), that.coordinates().apply(0)))}));
        if (7 != n || 7 != n2) throw new UnsupportedOperationException("Cross Product is not supported on vectors with an arbitrary number of dimensions");
        throw new UnsupportedOperationException("Seven-dimensional Cross Product is not currently supported");
    }

    public DoubleVector to(UnitOfMeasure<A> uom) {
        return this.$div(uom.apply(BoxesRunTime.boxToInteger((int)1), Numeric.IntIsIntegral$.MODULE$));
    }

    public QuantityVector<A> in(UnitOfMeasure<A> uom) {
        return this.map((Function1<A, B>)(Function1 & Serializable)_$8 -> _$8.in(uom));
    }

    public Seq<A> _1() {
        return this.coordinates();
    }
}

