/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.electro.Conductivity$;
import squants.electro.ConductivityUnit;
import squants.electro.ElectricalConductance;
import squants.electro.OhmMeters$;
import squants.electro.Resistivity;
import squants.electro.Siemens$;
import squants.electro.SiemensPerMeter$;
import squants.space.Length;

public final class Conductivity
extends Quantity<Conductivity> {
    private final double value;
    private final ConductivityUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Conductivity$.class, "0bitmap$1");

    public static Try<Conductivity> apply(Object object) {
        return Conductivity$.MODULE$.apply(object);
    }

    public static <A> Conductivity apply(A a, ConductivityUnit conductivityUnit, Numeric<A> numeric) {
        return Conductivity$.MODULE$.apply(a, conductivityUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Conductivity$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Conductivity$.MODULE$.name();
    }

    public static Try<Conductivity> parseString(String string) {
        return Conductivity$.MODULE$.parseString(string);
    }

    public static <N> Try<Conductivity> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Conductivity$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Conductivity$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Conductivity$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Conductivity>> symbolToUnit(String string) {
        return Conductivity$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Conductivity$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Conductivity$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Conductivity(double value, ConductivityUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public ConductivityUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Conductivity> dimension() {
        return Conductivity$.MODULE$;
    }

    public ElectricalConductance $times(Length that) {
        return Siemens$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSiemensPerMeter() * that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toSiemensPerMeter() {
        return this.to(SiemensPerMeter$.MODULE$);
    }

    public Resistivity inOhmMeters() {
        return OhmMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(1.0 / this.toSiemensPerMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }
}

