/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.electro.Abcoulombs$;
import squants.electro.AmpereHours$;
import squants.electro.AreaElectricChargeDensity;
import squants.electro.Capacitance;
import squants.electro.Coulombs$;
import squants.electro.CoulombsPerCubicMeter$;
import squants.electro.CoulombsPerKilogram$;
import squants.electro.CoulombsPerMeter$;
import squants.electro.CoulombsPerSquareMeter$;
import squants.electro.ElectricCharge$;
import squants.electro.ElectricChargeDensity;
import squants.electro.ElectricChargeMassRatio;
import squants.electro.ElectricChargeUnit;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricPotential;
import squants.electro.Farads$;
import squants.electro.LinearElectricChargeDensity;
import squants.electro.Microcoulombs$;
import squants.electro.MilliampereHours$;
import squants.electro.MilliampereSeconds$;
import squants.electro.Millicoulombs$;
import squants.electro.Nanocoulombs$;
import squants.electro.Picocoulombs$;
import squants.electro.Volts$;
import squants.energy.Energy;
import squants.energy.Joules$;
import squants.mass.Mass;
import squants.package$;
import squants.space.Area;
import squants.space.Length;
import squants.space.Volume;
import squants.time.Time;
import squants.time.TimeIntegral;

public final class ElectricCharge
extends Quantity<ElectricCharge>
implements TimeIntegral<ElectricCurrent> {
    private final double value;
    private final ElectricChargeUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(ElectricCharge$.class, "0bitmap$1");

    public static Try<ElectricCharge> apply(Object object) {
        return ElectricCharge$.MODULE$.apply(object);
    }

    public static <A> ElectricCharge apply(A a, ElectricChargeUnit electricChargeUnit, Numeric<A> numeric) {
        return ElectricCharge$.MODULE$.apply(a, electricChargeUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return ElectricCharge$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return ElectricCharge$.MODULE$.name();
    }

    public static Try<ElectricCharge> parseString(String string) {
        return ElectricCharge$.MODULE$.parseString(string);
    }

    public static <N> Try<ElectricCharge> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return ElectricCharge$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return ElectricCharge$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return ElectricCharge$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<ElectricCharge>> symbolToUnit(String string) {
        return ElectricCharge$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return ElectricCharge$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        ElectricCharge$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public ElectricCharge(double value, ElectricChargeUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public ElectricChargeUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<ElectricCharge> dimension() {
        return ElectricCharge$.MODULE$;
    }

    @Override
    public ElectricCurrent timeDerived() {
        return package$.MODULE$.Amperes().apply(BoxesRunTime.boxToDouble((double)this.toCoulombs()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return package$.MODULE$.Seconds().apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Energy $times(ElectricPotential that) {
        return Joules$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toCoulombs() * that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Capacitance $div(ElectricPotential that) {
        return Farads$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toCoulombs() / that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricPotential $div(Capacitance that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toCoulombs() / that.toFarads())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public LinearElectricChargeDensity $div(Length that) {
        return CoulombsPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toCoulombs() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public AreaElectricChargeDensity $div(Area that) {
        return CoulombsPerSquareMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toCoulombs() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricChargeDensity $div(Volume that) {
        return CoulombsPerCubicMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toCoulombs() / that.toCubicMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricChargeMassRatio $div(Mass that) {
        return CoulombsPerKilogram$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toCoulombs() / that.toKilograms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toCoulombs() {
        return this.to(Coulombs$.MODULE$);
    }

    public double toPicocoulombs() {
        return this.to(Picocoulombs$.MODULE$);
    }

    public double toNanocoulombs() {
        return this.to(Nanocoulombs$.MODULE$);
    }

    public double toMicrocoulombs() {
        return this.to(Microcoulombs$.MODULE$);
    }

    public double toMillcoulombs() {
        return this.to(Millicoulombs$.MODULE$);
    }

    public double toAbcoulombs() {
        return this.to(Abcoulombs$.MODULE$);
    }

    public double toAmpereHours() {
        return this.to(AmpereHours$.MODULE$);
    }

    public double toMilliampereHours() {
        return this.to(MilliampereHours$.MODULE$);
    }

    public double toMilliampereSeconds() {
        return this.to(MilliampereSeconds$.MODULE$);
    }
}

