/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.math.Numeric;
import squants.electro.ElectricPotential;
import squants.electro.ElectricPotentialConversions$;
import squants.electro.Kilovolts$;
import squants.electro.Megavolts$;
import squants.electro.Microvolts$;
import squants.electro.Millivolts$;
import squants.electro.Volts$;

public final class ElectricPotentialConversions {
    public static <A> ElectricPotentialConversions<A> ElectricPotentialConversions(A a, Numeric<A> numeric) {
        return ElectricPotentialConversions$.MODULE$.ElectricPotentialConversions(a, numeric);
    }

    public static ElectricPotential kilovolt() {
        return ElectricPotentialConversions$.MODULE$.kilovolt();
    }

    public static ElectricPotential megavolt() {
        return ElectricPotentialConversions$.MODULE$.megavolt();
    }

    public static ElectricPotential microvolt() {
        return ElectricPotentialConversions$.MODULE$.microvolt();
    }

    public static ElectricPotential millivolt() {
        return ElectricPotentialConversions$.MODULE$.millivolt();
    }

    public static ElectricPotential volt() {
        return ElectricPotentialConversions$.MODULE$.volt();
    }

    public static class ElectricPotentialConversions<A> {
        private final A n;
        private final Numeric<A> num;

        public <A> ElectricPotentialConversions(A n, Numeric<A> num) {
            this.n = n;
            this.num = num;
        }

        public ElectricPotential V() {
            return Volts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public ElectricPotential volts() {
            return Volts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public ElectricPotential microvolts() {
            return Microvolts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public ElectricPotential millivolts() {
            return Millivolts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public ElectricPotential kilovolts() {
            return Kilovolts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public ElectricPotential megavolts() {
            return Megavolts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }
    }
}

