/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.electro.Conductivity;
import squants.electro.ElectricalConductance$;
import squants.electro.ElectricalConductanceUnit;
import squants.electro.ElectricalResistance;
import squants.electro.Ohms$;
import squants.electro.Siemens$;
import squants.electro.SiemensPerMeter$;
import squants.package$;
import squants.space.Length;

public final class ElectricalConductance
extends Quantity<ElectricalConductance> {
    private final double value;
    private final ElectricalConductanceUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(ElectricalConductance$.class, "0bitmap$1");

    public static Try<ElectricalConductance> apply(Object object) {
        return ElectricalConductance$.MODULE$.apply(object);
    }

    public static <A> ElectricalConductance apply(A a, ElectricalConductanceUnit electricalConductanceUnit, Numeric<A> numeric) {
        return ElectricalConductance$.MODULE$.apply(a, electricalConductanceUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return ElectricalConductance$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return ElectricalConductance$.MODULE$.name();
    }

    public static Try<ElectricalConductance> parseString(String string) {
        return ElectricalConductance$.MODULE$.parseString(string);
    }

    public static <N> Try<ElectricalConductance> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return ElectricalConductance$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return ElectricalConductance$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return ElectricalConductance$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<ElectricalConductance>> symbolToUnit(String string) {
        return ElectricalConductance$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return ElectricalConductance$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        ElectricalConductance$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public ElectricalConductance(double value, ElectricalConductanceUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public ElectricalConductanceUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<ElectricalConductance> dimension() {
        return ElectricalConductance$.MODULE$;
    }

    public Conductivity $div(Length that) {
        return SiemensPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSiemens() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Length $div(Conductivity that) {
        return package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)(this.toSiemens() / that.toSiemensPerMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toSiemens() {
        return this.to(Siemens$.MODULE$);
    }

    public ElectricalResistance inOhms() {
        return Ohms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(1.0 / this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }
}

