/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricPotential;
import squants.electro.ElectricalConductance;
import squants.electro.ElectricalResistance$;
import squants.electro.ElectricalResistanceUnit;
import squants.electro.Gigohms$;
import squants.electro.Kilohms$;
import squants.electro.Megohms$;
import squants.electro.Microohms$;
import squants.electro.Milliohms$;
import squants.electro.Nanohms$;
import squants.electro.OhmMeters$;
import squants.electro.Ohms$;
import squants.electro.Resistivity;
import squants.electro.Siemens$;
import squants.electro.Volts$;
import squants.space.Length;

public final class ElectricalResistance
extends Quantity<ElectricalResistance> {
    private final double value;
    private final ElectricalResistanceUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(ElectricalResistance$.class, "0bitmap$1");

    public static Try<ElectricalResistance> apply(Object object) {
        return ElectricalResistance$.MODULE$.apply(object);
    }

    public static <A> ElectricalResistance apply(A a, ElectricalResistanceUnit electricalResistanceUnit, Numeric<A> numeric) {
        return ElectricalResistance$.MODULE$.apply(a, electricalResistanceUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return ElectricalResistance$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return ElectricalResistance$.MODULE$.name();
    }

    public static Try<ElectricalResistance> parseString(String string) {
        return ElectricalResistance$.MODULE$.parseString(string);
    }

    public static <N> Try<ElectricalResistance> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return ElectricalResistance$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return ElectricalResistance$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return ElectricalResistance$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<ElectricalResistance>> symbolToUnit(String string) {
        return ElectricalResistance$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return ElectricalResistance$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        ElectricalResistance$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public ElectricalResistance(double value, ElectricalResistanceUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public ElectricalResistanceUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<ElectricalResistance> dimension() {
        return ElectricalResistance$.MODULE$;
    }

    public ElectricPotential $times(ElectricCurrent that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toOhms() * that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Resistivity $times(Length that) {
        return OhmMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toOhms() * that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toOhms() {
        return this.to(Ohms$.MODULE$);
    }

    public double toNanohms() {
        return this.to(Nanohms$.MODULE$);
    }

    public double toMicrohms() {
        return this.to(Microohms$.MODULE$);
    }

    public double toMillohms() {
        return this.to(Milliohms$.MODULE$);
    }

    public double toKilohms() {
        return this.to(Kilohms$.MODULE$);
    }

    public double toMegohms() {
        return this.to(Megohms$.MODULE$);
    }

    public double toGigohms() {
        return this.to(Gigohms$.MODULE$);
    }

    public ElectricalConductance inSiemens() {
        return Siemens$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(1.0 / this.to(Ohms$.MODULE$))), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }
}

