/*
 * Decompiled with CFR 0.152.
 */
package squants.energy;

import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.electro.Coulombs$;
import squants.electro.ElectricCharge;
import squants.electro.ElectricPotential;
import squants.electro.Volts$;
import squants.energy.BritishThermalUnits$;
import squants.energy.ElectronVolt$;
import squants.energy.Energy$;
import squants.energy.EnergyDensity;
import squants.energy.EnergyUnit;
import squants.energy.Ergs$;
import squants.energy.ExaElectronVolt$;
import squants.energy.GigaElectronVolt$;
import squants.energy.Gigajoules$;
import squants.energy.GigawattHours$;
import squants.energy.Grays$;
import squants.energy.Joules$;
import squants.energy.JoulesPerCubicMeter$;
import squants.energy.JoulesPerMole$;
import squants.energy.KiloElectronVolt$;
import squants.energy.Kilojoules$;
import squants.energy.KilowattHours$;
import squants.energy.MBtus$;
import squants.energy.MMBtus$;
import squants.energy.MegaElectronVolt$;
import squants.energy.Megajoules$;
import squants.energy.MegawattHours$;
import squants.energy.Microjoules$;
import squants.energy.MilliElectronVolt$;
import squants.energy.Millijoules$;
import squants.energy.MilliwattHours$;
import squants.energy.MolarEnergy;
import squants.energy.Nanojoules$;
import squants.energy.PetaElectronVolt$;
import squants.energy.Picojoules$;
import squants.energy.Power;
import squants.energy.PowerRamp;
import squants.energy.SpecificEnergy;
import squants.energy.TeraElectronVolt$;
import squants.energy.Terajoules$;
import squants.energy.WattHours$;
import squants.energy.Watts$;
import squants.mass.ChemicalAmount;
import squants.mass.Kilograms$;
import squants.mass.Mass;
import squants.motion.Force;
import squants.motion.NewtonMeters$;
import squants.motion.Newtons$;
import squants.motion.Torque;
import squants.package$;
import squants.radio.Irradiance;
import squants.radio.ParticleFlux;
import squants.radio.WattsPerSquareMeter$;
import squants.space.Angle;
import squants.space.Area;
import squants.space.CubicMeters$;
import squants.space.Length;
import squants.space.Volume;
import squants.thermal.JoulesPerKelvin$;
import squants.thermal.Kelvin$;
import squants.thermal.Temperature;
import squants.thermal.ThermalCapacity;
import squants.time.Hours$;
import squants.time.SecondTimeIntegral;
import squants.time.Time;
import squants.time.TimeIntegral;
import squants.time.TimeSquared;

public final class Energy
extends Quantity<Energy>
implements TimeIntegral<Power>,
SecondTimeIntegral<PowerRamp> {
    private final double value;
    private final EnergyUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Energy$.class, "0bitmap$1");

    public static Try<Energy> apply(Object object) {
        return Energy$.MODULE$.apply(object);
    }

    public static <A> Energy apply(A a, EnergyUnit energyUnit, Numeric<A> numeric) {
        return Energy$.MODULE$.apply(a, energyUnit, numeric);
    }

    public static Energy apply(Power power, Time time) {
        return Energy$.MODULE$.apply(power, time);
    }

    public static Dimension dimensionImplicit() {
        return Energy$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Energy$.MODULE$.name();
    }

    public static Try<Energy> parseString(String string) {
        return Energy$.MODULE$.parseString(string);
    }

    public static <N> Try<Energy> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Energy$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Energy$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Energy$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Energy>> symbolToUnit(String string) {
        return Energy$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Energy$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Energy$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Energy(double value, EnergyUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public EnergyUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Energy> dimension() {
        return Energy$.MODULE$;
    }

    @Override
    public Power timeDerived() {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toWattHours()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Hours$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Irradiance $times(ParticleFlux that) {
        return WattsPerSquareMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(Hours$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$).toSeconds() * this.toWattHours() * that.toBecquerelsPerSquareMeterSecond())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Force $div(Length that) {
        return Newtons$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Length $div(Force that) {
        return package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toNewtons())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public SpecificEnergy $div(Mass that) {
        return Grays$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toKilograms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Mass $div(SpecificEnergy that) {
        return Kilograms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toGrays())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public EnergyDensity $div(Volume that) {
        return JoulesPerCubicMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toCubicMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Volume $div(EnergyDensity that) {
        return CubicMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toJoulesPerCubicMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricPotential $div(ElectricCharge that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toCoulombs())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCharge $div(ElectricPotential that) {
        return Coulombs$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ThermalCapacity $div(Temperature that) {
        return JoulesPerKelvin$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toKelvinDegrees())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Temperature $div(ThermalCapacity that) {
        return Kelvin$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toJoulesPerKelvin())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public MolarEnergy $div(ChemicalAmount that) {
        return JoulesPerMole$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toMoles())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Torque $div(Angle that) {
        return NewtonMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toRadians())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Nothing$ $div(Area that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public PowerRamp $div(TimeSquared that) {
        return (PowerRamp)((TimeIntegral)((Object)this.$div(that.time1()))).$div(that.time2());
    }

    @Override
    public TimeSquared $div(PowerRamp that) {
        return this.$div(that.timeIntegrated()).$times(this.time());
    }

    public double toWattHours() {
        return this.to(WattHours$.MODULE$);
    }

    public double toMilliwattHours() {
        return this.to(MilliwattHours$.MODULE$);
    }

    public double toKilowattHours() {
        return this.to(KilowattHours$.MODULE$);
    }

    public double toMegawattHours() {
        return this.to(MegawattHours$.MODULE$);
    }

    public double toGigawattHours() {
        return this.to(GigawattHours$.MODULE$);
    }

    public double toJoules() {
        return this.to(Joules$.MODULE$);
    }

    public double toPicojoules() {
        return this.to(Picojoules$.MODULE$);
    }

    public double toNanojoules() {
        return this.to(Nanojoules$.MODULE$);
    }

    public double toMicrojoules() {
        return this.to(Microjoules$.MODULE$);
    }

    public double toMillijoules() {
        return this.to(Millijoules$.MODULE$);
    }

    public double toKilojoules() {
        return this.to(Kilojoules$.MODULE$);
    }

    public double toMegajoules() {
        return this.to(Megajoules$.MODULE$);
    }

    public double toGigajoules() {
        return this.to(Gigajoules$.MODULE$);
    }

    public double toTerajoules() {
        return this.to(Terajoules$.MODULE$);
    }

    public double toeV() {
        return this.to(ElectronVolt$.MODULE$);
    }

    public double tomeV() {
        return this.to(MilliElectronVolt$.MODULE$);
    }

    public double tokeV() {
        return this.to(KiloElectronVolt$.MODULE$);
    }

    public double toMeV() {
        return this.to(MegaElectronVolt$.MODULE$);
    }

    public double toGeV() {
        return this.to(GigaElectronVolt$.MODULE$);
    }

    public double toTeV() {
        return this.to(TeraElectronVolt$.MODULE$);
    }

    public double toPeV() {
        return this.to(PetaElectronVolt$.MODULE$);
    }

    public double toEeV() {
        return this.to(ExaElectronVolt$.MODULE$);
    }

    public double toBtus() {
        return this.to(BritishThermalUnits$.MODULE$);
    }

    public double toMBtus() {
        return this.to(MBtus$.MODULE$);
    }

    public double toMMBtus() {
        return this.to(MMBtus$.MODULE$);
    }

    public double toErgs() {
        return this.to(Ergs$.MODULE$);
    }

    public Torque asTorque() {
        return NewtonMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toJoules()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }
}

