/*
 * Decompiled with CFR 0.152.
 */
package squants.energy;

import scala.math.Numeric;
import scala.util.Try;
import squants.energy.BritishThermalUnits$;
import squants.energy.ElectronVolt$;
import squants.energy.Energy;
import squants.energy.Energy$;
import squants.energy.EnergyConversions$;
import squants.energy.Ergs$;
import squants.energy.ExaElectronVolt$;
import squants.energy.GigaElectronVolt$;
import squants.energy.Gigajoules$;
import squants.energy.GigawattHours$;
import squants.energy.Joules$;
import squants.energy.KiloElectronVolt$;
import squants.energy.Kilojoules$;
import squants.energy.KilowattHours$;
import squants.energy.MBtus$;
import squants.energy.MMBtus$;
import squants.energy.MegaElectronVolt$;
import squants.energy.Megajoules$;
import squants.energy.MegawattHours$;
import squants.energy.Microjoules$;
import squants.energy.MilliElectronVolt$;
import squants.energy.Millijoules$;
import squants.energy.MilliwattHours$;
import squants.energy.Nanojoules$;
import squants.energy.PetaElectronVolt$;
import squants.energy.Picojoules$;
import squants.energy.TeraElectronVolt$;
import squants.energy.Terajoules$;
import squants.energy.WattHours$;

public final class EnergyConversions {
    public static Energy EeV() {
        return EnergyConversions$.MODULE$.EeV();
    }

    public static <A> EnergyConversions<A> EnergyConversions(A a, Numeric<A> numeric) {
        return EnergyConversions$.MODULE$.EnergyConversions(a, numeric);
    }

    public static EnergyStringConversions EnergyStringConversions(String string) {
        return EnergyConversions$.MODULE$.EnergyStringConversions(string);
    }

    public static Energy GWh() {
        return EnergyConversions$.MODULE$.GWh();
    }

    public static Energy GeV() {
        return EnergyConversions$.MODULE$.GeV();
    }

    public static Energy MWh() {
        return EnergyConversions$.MODULE$.MWh();
    }

    public static Energy MeV() {
        return EnergyConversions$.MODULE$.MeV();
    }

    public static Energy PeV() {
        return EnergyConversions$.MODULE$.PeV();
    }

    public static Energy TeV() {
        return EnergyConversions$.MODULE$.TeV();
    }

    public static Energy Wh() {
        return EnergyConversions$.MODULE$.Wh();
    }

    public static Energy btu() {
        return EnergyConversions$.MODULE$.btu();
    }

    public static double btuMultiplier() {
        return EnergyConversions$.MODULE$.btuMultiplier();
    }

    public static Energy eV() {
        return EnergyConversions$.MODULE$.eV();
    }

    public static Energy gigajoule() {
        return EnergyConversions$.MODULE$.gigajoule();
    }

    public static Energy gigawattHour() {
        return EnergyConversions$.MODULE$.gigawattHour();
    }

    public static Energy joule() {
        return EnergyConversions$.MODULE$.joule();
    }

    public static Energy kWh() {
        return EnergyConversions$.MODULE$.kWh();
    }

    public static Energy keV() {
        return EnergyConversions$.MODULE$.keV();
    }

    public static Energy kilojoule() {
        return EnergyConversions$.MODULE$.kilojoule();
    }

    public static Energy kilowattHour() {
        return EnergyConversions$.MODULE$.kilowattHour();
    }

    public static Energy mWh() {
        return EnergyConversions$.MODULE$.mWh();
    }

    public static Energy meV() {
        return EnergyConversions$.MODULE$.meV();
    }

    public static Energy megajoule() {
        return EnergyConversions$.MODULE$.megajoule();
    }

    public static Energy megawattHour() {
        return EnergyConversions$.MODULE$.megawattHour();
    }

    public static Energy microjoule() {
        return EnergyConversions$.MODULE$.microjoule();
    }

    public static Energy millijoule() {
        return EnergyConversions$.MODULE$.millijoule();
    }

    public static Energy milliwattHour() {
        return EnergyConversions$.MODULE$.milliwattHour();
    }

    public static Energy nanojoule() {
        return EnergyConversions$.MODULE$.nanojoule();
    }

    public static Energy picojoule() {
        return EnergyConversions$.MODULE$.picojoule();
    }

    public static Energy terajoule() {
        return EnergyConversions$.MODULE$.terajoule();
    }

    public static Energy wattHour() {
        return EnergyConversions$.MODULE$.wattHour();
    }

    public static class EnergyConversions<A> {
        private final A n;
        private final Numeric<A> num;

        public <A> EnergyConversions(A n, Numeric<A> num) {
            this.n = n;
            this.num = num;
        }

        public Energy J() {
            return Joules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy joules() {
            return Joules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy pJ() {
            return Picojoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy picojoules() {
            return Picojoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy nJ() {
            return Nanojoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy nanojoules() {
            return Nanojoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy \u00b5J() {
            return Microjoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy microjoules() {
            return Microjoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy mJ() {
            return Millijoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy milljoules() {
            return Millijoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy kJ() {
            return Kilojoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy kilojoules() {
            return Kilojoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy MJ() {
            return Megajoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy megajoules() {
            return Megajoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy GJ() {
            return Gigajoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy gigajoules() {
            return Gigajoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy TJ() {
            return Terajoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy terajoules() {
            return Terajoules$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy Wh() {
            return WattHours$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy mWh() {
            return MilliwattHours$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy kWh() {
            return KilowattHours$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy MWh() {
            return MegawattHours$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy GWh() {
            return GigawattHours$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy Btu() {
            return BritishThermalUnits$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy MBtu() {
            return MBtus$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy MMBtu() {
            return MMBtus$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy ergs() {
            return Ergs$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy wattHours() {
            return WattHours$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy kilowattHours() {
            return KilowattHours$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy megawattHours() {
            return MegawattHours$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy gigawattHours() {
            return GigawattHours$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy eV() {
            return ElectronVolt$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy meV() {
            return MilliElectronVolt$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy keV() {
            return KiloElectronVolt$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy MeV() {
            return MegaElectronVolt$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy GeV() {
            return GigaElectronVolt$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy TeV() {
            return TeraElectronVolt$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy PeV() {
            return PetaElectronVolt$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Energy EeV() {
            return ExaElectronVolt$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }
    }

    public static class EnergyStringConversions {
        private final String s;

        public EnergyStringConversions(String s) {
            this.s = s;
        }

        public Try<Energy> toEnergy() {
            return Energy$.MODULE$.apply(this.s);
        }
    }
}

