/*
 * Decompiled with CFR 0.152.
 */
package squants.energy;

import scala.math.Numeric;
import scala.util.Try;
import squants.energy.BtusPerHour$;
import squants.energy.ErgsPerSecond$;
import squants.energy.Gigawatts$;
import squants.energy.Kilowatts$;
import squants.energy.Megawatts$;
import squants.energy.Milliwatts$;
import squants.energy.Power;
import squants.energy.Power$;
import squants.energy.PowerConversions$;
import squants.energy.SolarLuminosities$;
import squants.energy.Watts$;

public final class PowerConversions {
    public static Power GW() {
        return PowerConversions$.MODULE$.GW();
    }

    public static Power MW() {
        return PowerConversions$.MODULE$.MW();
    }

    public static <A> PowerConversions<A> PowerConversions(A a, Numeric<A> numeric) {
        return PowerConversions$.MODULE$.PowerConversions(a, numeric);
    }

    public static PowerStringConversions PowerStringConversions(String string) {
        return PowerConversions$.MODULE$.PowerStringConversions(string);
    }

    public static Power W() {
        return PowerConversions$.MODULE$.W();
    }

    public static Power gigawatt() {
        return PowerConversions$.MODULE$.gigawatt();
    }

    public static Power kW() {
        return PowerConversions$.MODULE$.kW();
    }

    public static Power kilowatt() {
        return PowerConversions$.MODULE$.kilowatt();
    }

    public static Power mW() {
        return PowerConversions$.MODULE$.mW();
    }

    public static Power megawatt() {
        return PowerConversions$.MODULE$.megawatt();
    }

    public static Power milliwatt() {
        return PowerConversions$.MODULE$.milliwatt();
    }

    public static Power solarLuminosity() {
        return PowerConversions$.MODULE$.solarLuminosity();
    }

    public static Power watt() {
        return PowerConversions$.MODULE$.watt();
    }

    public static class PowerConversions<A> {
        private final A n;
        private final Numeric<A> num;

        public <A> PowerConversions(A n, Numeric<A> num) {
            this.n = n;
            this.num = num;
        }

        public Power mW() {
            return Milliwatts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Power W() {
            return Watts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Power kW() {
            return Kilowatts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Power MW() {
            return Megawatts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Power GW() {
            return Gigawatts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Power milliwatts() {
            return Milliwatts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Power watts() {
            return Watts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Power kilowatts() {
            return Kilowatts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Power megawatts() {
            return Megawatts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Power gigawatts() {
            return Gigawatts$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Power BTUph() {
            return BtusPerHour$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Power ergsPerSecond() {
            return ErgsPerSecond$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Power solarLuminosities() {
            return SolarLuminosities$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }
    }

    public static class PowerStringConversions {
        private final String s;

        public PowerStringConversions(String s) {
            this.s = s;
        }

        public Try<Power> toPower() {
            return Power$.MODULE$.apply(this.s);
        }
    }
}

