/*
 * Decompiled with CFR 0.152.
 */
package squants.market;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import squants.UnitOfMeasure;
import squants.market.CurrencyExchangeRate;
import squants.market.Money;
import squants.market.Money$;

public abstract class Currency
implements UnitOfMeasure<Money> {
    private final String code;
    private final String name;
    private final String symbol;
    private final int formatDecimals;

    public Currency(String code, String name, String symbol, int formatDecimals) {
        this.code = code;
        this.name = name;
        this.symbol = symbol;
        this.formatDecimals = formatDecimals;
    }

    public String code() {
        return this.code;
    }

    public String name() {
        return this.name;
    }

    @Override
    public String symbol() {
        return this.symbol;
    }

    public int formatDecimals() {
        return this.formatDecimals;
    }

    public Money apply(BigDecimal d) {
        return Money$.MODULE$.apply(d, this);
    }

    @Override
    public <A> Money apply(A n, Numeric<A> num) {
        return Money$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(num.toDouble(n)), this);
    }

    @Override
    public Function1<Object, Object> converterFrom() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public Function1<Object, Object> converterTo() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public CurrencyExchangeRate $div(Money that) {
        return that.toThe(Money$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), this, Numeric.IntIsIntegral$.MODULE$));
    }

    public String toString() {
        return this.code();
    }

    public boolean canEqual(Object other) {
        return other instanceof Currency;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof Currency)) return false;
        Currency that = (Currency)object;
        if (!that.canEqual(this)) return false;
        String string = this.code();
        String string2 = that.code();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.name();
        String string4 = that.name();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.symbol();
        String string6 = that.symbol();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        if (this.formatDecimals() != that.formatDecimals()) return false;
        return true;
    }

    public int hashCode() {
        Seq state = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.code(), this.name(), this.symbol(), BoxesRunTime.boxToInteger((int)this.formatDecimals())}));
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)state.map((Function1 & Serializable)_$7 -> _$7.hashCode())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
    }
}

