/*
 * Decompiled with CFR 0.152.
 */
package squants.market;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.BigDecimal;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import squants.market.Currency;
import squants.market.CurrencyExchangeRate;
import squants.market.CurrencyExchangeRate$;
import squants.market.Money;
import squants.market.MoneyContext$;
import squants.market.package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MoneyContext
implements Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(MoneyContext.class, "0bitmap$1");
    public long 0bitmap$1;
    private final Currency defaultCurrency;
    private final Set currencies;
    private final Seq rates;
    private final boolean allowIndirectConversions;
    public Map currencyMap$lzy1;
    private String string$lzy1;

    public static MoneyContext apply(Currency currency, Set<Currency> set, Seq<CurrencyExchangeRate> seq, boolean bl) {
        return MoneyContext$.MODULE$.apply(currency, set, seq, bl);
    }

    public static MoneyContext fromProduct(Product product) {
        return MoneyContext$.MODULE$.fromProduct(product);
    }

    public static MoneyContext unapply(MoneyContext moneyContext) {
        return MoneyContext$.MODULE$.unapply(moneyContext);
    }

    public static boolean $lessinit$greater$default$4() {
        return MoneyContext$.MODULE$.$lessinit$greater$default$4();
    }

    public MoneyContext(Currency defaultCurrency, Set<Currency> currencies, Seq<CurrencyExchangeRate> rates, boolean allowIndirectConversions) {
        this.defaultCurrency = defaultCurrency;
        this.currencies = currencies;
        this.rates = rates;
        this.allowIndirectConversions = allowIndirectConversions;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.defaultCurrency()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.currencies()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.rates()));
        n = Statics.mix((int)n, (int)(this.allowIndirectConversions() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof MoneyContext)) return false;
        MoneyContext moneyContext = (MoneyContext)object;
        if (this.allowIndirectConversions() != moneyContext.allowIndirectConversions()) return false;
        Currency currency = this.defaultCurrency();
        Currency currency2 = moneyContext.defaultCurrency();
        if (currency == null) {
            if (currency2 != null) {
                return false;
            }
        } else if (!((Object)currency).equals(currency2)) return false;
        Set<Currency> set = this.currencies();
        Set<Currency> set2 = moneyContext.currencies();
        if (set == null) {
            if (set2 != null) {
                return false;
            }
        } else if (!set.equals(set2)) return false;
        Seq<CurrencyExchangeRate> seq = this.rates();
        Seq<CurrencyExchangeRate> seq2 = moneyContext.rates();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!moneyContext.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof MoneyContext;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "MoneyContext";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = this._2();
                break;
            }
            case 2: {
                object = this._3();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this._4());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "defaultCurrency";
                break;
            }
            case 1: {
                string = "currencies";
                break;
            }
            case 2: {
                string = "rates";
                break;
            }
            case 3: {
                string = "allowIndirectConversions";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public Currency defaultCurrency() {
        return this.defaultCurrency;
    }

    public Set<Currency> currencies() {
        return this.currencies;
    }

    public Seq<CurrencyExchangeRate> rates() {
        return this.rates;
    }

    public boolean allowIndirectConversions() {
        return this.allowIndirectConversions;
    }

    public Map<String, Currency> currencyMap() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    Map map;
                    this.currencyMap$lzy1 = map = ((IterableOnceOps)this.currencies().map((Function1 & Serializable)c -> {
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)c.code());
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, c);
                    })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return map;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.currencyMap$lzy1;
    }

    public String toString() {
        return this.string();
    }

    private String string() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                try {
                    String string;
                    String cSet = ((IterableOnceOps)((IterableOnceOps)this.currencies().map((Function1 & Serializable)_$1 -> _$1.toString())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
                    String rSet = ((IterableOnceOps)((SeqOps)this.rates().map((Function1 & Serializable)_$2 -> _$2.toString())).sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
                    this.string$lzy1 = string = "MoneyContext(DefaultCurrency(" + this.defaultCurrency().code() + "),Currencies(" + cSet + "),ExchangeRates(" + rSet + "),AllowIndirectConversions(" + this.allowIndirectConversions() + "))";
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                    return string;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
        }
        return this.string$lzy1;
    }

    public Option<CurrencyExchangeRate> directRateFor(Currency curA, Currency curB) {
        return this.rates().find((Function1 & Serializable)r -> {
            Currency currency = r.base().currency();
            Currency currency2 = curA;
            if (!(currency != null ? !((Object)currency).equals(currency2) : currency2 != null)) {
                Currency currency3 = r.counter().currency();
                Currency currency4 = curB;
                if (currency3 == null) {
                    if (currency4 == null) return true;
                } else if (((Object)currency3).equals(currency4)) return true;
            }
            Currency currency5 = r.base().currency();
            Currency currency6 = curB;
            if (currency5 == null) {
                if (currency6 != null) {
                    return false;
                }
            } else if (!((Object)currency5).equals(currency6)) return false;
            Currency currency7 = r.counter().currency();
            Currency currency8 = curA;
            if (currency7 == null) {
                if (currency8 == null) return true;
                return false;
            } else {
                if (!((Object)currency7).equals(currency8)) return false;
                return true;
            }
        });
    }

    public Option<CurrencyExchangeRate> indirectRateFor(Currency curA, Currency curB) {
        Some some;
        Option<CurrencyExchangeRate> option = this.directRateFor(curA, curB);
        if (option instanceof Some) {
            CurrencyExchangeRate rate = (CurrencyExchangeRate)((Some)option).value();
            some = Some$.MODULE$.apply((Object)rate);
        } else {
            Seq ratesWithCurA = (Seq)this.rates().filter((Function1 & Serializable)r -> {
                Currency currency = r.base().currency();
                Currency currency2 = curA;
                if (currency == null) {
                    if (currency2 == null) return true;
                } else if (((Object)currency).equals(currency2)) return true;
                Currency currency3 = r.counter().currency();
                Currency currency4 = curA;
                if (currency3 != null) {
                    if (!((Object)currency3).equals(currency4)) return false;
                    return true;
                }
                if (currency4 == null) return true;
                return false;
            });
            Seq ratesWithCurB = (Seq)this.rates().filter((Function1 & Serializable)r -> {
                Currency currency = r.base().currency();
                Currency currency2 = curB;
                if (currency == null) {
                    if (currency2 == null) return true;
                } else if (((Object)currency).equals(currency2)) return true;
                Currency currency3 = r.counter().currency();
                Currency currency4 = curB;
                if (currency3 != null) {
                    if (!((Object)currency3).equals(currency4)) return false;
                    return true;
                }
                if (currency4 == null) return true;
                return false;
            });
            Set curs = (Set)this.currencies().withFilter((Function1 & Serializable)cur -> ((SeqOps)ratesWithCurA.map((Function1 & Serializable)_$3 -> _$3.base().currency())).contains(cur) || ((SeqOps)ratesWithCurA.map((Function1 & Serializable)_$4 -> _$4.counter().currency())).contains(cur)).withFilter((Function1 & Serializable)cur -> ((SeqOps)ratesWithCurB.map((Function1 & Serializable)_$5 -> _$5.base().currency())).contains(cur) || ((SeqOps)ratesWithCurB.map((Function1 & Serializable)_$6 -> _$6.counter().currency())).contains(cur)).map((Function1 & Serializable)cur -> cur);
            Option option2 = curs.headOption();
            if (option2 instanceof Some) {
                Currency cur2 = (Currency)((Some)option2).value();
                some = Some$.MODULE$.apply((Object)CurrencyExchangeRate$.MODULE$.apply(this.convert((Money)cur2.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$), curA), this.convert((Money)cur2.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$), curB)));
            } else if (None$.MODULE$.equals(option2)) {
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)option2);
            }
        }
        return some;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Money convert(Money money, Currency currency) {
        Money money2;
        Currency currency2 = money.currency();
        Currency currency3 = currency;
        if (!(currency2 != null ? !((Object)currency2).equals(currency3) : currency3 != null)) {
            money2 = money;
            return money2;
        } else {
            Option<CurrencyExchangeRate> option = this.directRateFor(money.currency(), currency);
            if (option instanceof Some) {
                CurrencyExchangeRate rate = (CurrencyExchangeRate)((Some)option).value();
                money2 = rate.convert(money);
                return money2;
            } else {
                if (!this.allowIndirectConversions()) throw new package.NoSuchExchangeRateException("Rate for currency pair (" + money.currency() + " / " + currency + ")");
                Option<CurrencyExchangeRate> option2 = this.indirectRateFor(money.currency(), currency);
                if (option2 instanceof Some) {
                    CurrencyExchangeRate crossRate = (CurrencyExchangeRate)((Some)option2).value();
                    money2 = crossRate.convert(money);
                    return money2;
                } else {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                    throw new package.NoSuchExchangeRateException("Rate for currency pair (" + money.currency() + " / " + currency + ")");
                }
            }
        }
    }

    public Money add(Money moneyA, Money moneyB) {
        return moneyA.currency().apply(moneyA.amount().$plus(this.convert(moneyB, moneyA.currency()).amount()));
    }

    public Money subtract(Money moneyA, Money moneyB) {
        return moneyA.currency().apply(moneyA.amount().$minus(this.convert(moneyB, moneyA.currency()).amount()));
    }

    public BigDecimal divide(Money moneyA, Money moneyB) {
        return moneyA.amount().$div(this.convert(moneyB, moneyA.currency()).amount());
    }

    public int compare(Money moneyA, Money moneyB) {
        return moneyA.amount().$greater((Object)this.convert(moneyB, moneyA.currency()).amount()) ? 1 : (moneyA.amount().$less((Object)this.convert(moneyB, moneyA.currency()).amount()) ? -1 : 0);
    }

    public MoneyContext withAdditionalCurrencies(Set<Currency> additionalCurrencies) {
        Set set = (Set)this.currencies().$plus$plus(additionalCurrencies);
        Currency currency = this.copy$default$1();
        Seq<CurrencyExchangeRate> seq = this.copy$default$3();
        boolean bl = this.copy$default$4();
        return this.copy(currency, (Set<Currency>)set, seq, bl);
    }

    public MoneyContext withExchangeRates(List<CurrencyExchangeRate> rates) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), (Seq<CurrencyExchangeRate>)rates, this.copy$default$4());
    }

    public MoneyContext copy(Currency defaultCurrency, Set<Currency> currencies, Seq<CurrencyExchangeRate> rates, boolean allowIndirectConversions) {
        return new MoneyContext(defaultCurrency, currencies, rates, allowIndirectConversions);
    }

    public Currency copy$default$1() {
        return this.defaultCurrency();
    }

    public Set<Currency> copy$default$2() {
        return this.currencies();
    }

    public Seq<CurrencyExchangeRate> copy$default$3() {
        return this.rates();
    }

    public boolean copy$default$4() {
        return this.allowIndirectConversions();
    }

    public Currency _1() {
        return this.defaultCurrency();
    }

    public Set<Currency> _2() {
        return this.currencies();
    }

    public Seq<CurrencyExchangeRate> _3() {
        return this.rates();
    }

    public boolean _4() {
        return this.allowIndirectConversions();
    }
}

