/*
 * Decompiled with CFR 0.152.
 */
package squants.market;

import java.io.Serializable;
import scala.Product;
import scala.math.BigDecimal;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import squants.Quantity;
import squants.Ratio;
import squants.UnitOfMeasure;
import squants.market.Currency;
import squants.market.Money;
import squants.market.MoneyContext;
import squants.market.Price$;

public class Price<A extends Quantity<A>>
implements Ratio<Money, A>,
Serializable,
Product {
    private final Money money;
    private final Quantity quantity;

    public static <A extends Quantity<A>> Price<A> apply(Money money, A a) {
        return Price$.MODULE$.apply(money, a);
    }

    public static Price fromProduct(Product product) {
        return Price$.MODULE$.fromProduct(product);
    }

    public static <A extends Quantity<A>> Price<A> unapply(Price<A> price) {
        return Price$.MODULE$.unapply(price);
    }

    public <A extends Quantity<A>> Price(Money money, A quantity) {
        this.money = money;
        this.quantity = quantity;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Price)) return false;
        Price price = (Price)object;
        Money money = this.money();
        Money money2 = price.money();
        if (money == null) {
            if (money2 != null) {
                return false;
            }
        } else if (!((Object)money).equals(money2)) return false;
        A a = this.quantity();
        A a2 = price.quantity();
        if (a == null) {
            if (a2 != null) {
                return false;
            }
        } else if (!a.equals(a2)) return false;
        if (!price.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Price;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Price";
    }

    public Object productElement(int n) {
        Money money;
        int n2 = n;
        if (0 == n2) {
            money = this._1();
        } else if (1 == n2) {
            money = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return money;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "money";
        } else if (1 == n2) {
            string = "quantity";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public Money money() {
        return this.money;
    }

    public A quantity() {
        return (A)this.quantity;
    }

    @Override
    public Money base() {
        return this.money();
    }

    @Override
    public A counter() {
        return this.quantity();
    }

    public Price<A> plus(Price<A> that) {
        return Price$.MODULE$.apply(this.money().$plus(that.money(), this.money().$plus$default$2(that.money())), this.quantity());
    }

    public Price<A> $plus(Price<A> that) {
        return this.plus(that);
    }

    public Price<A> minus(Price<A> that) {
        return Price$.MODULE$.apply(this.money().$minus(that.money(), this.money().$minus$default$2(that.money())), this.quantity());
    }

    public Price<A> $minus(Price<A> that) {
        return this.minus(that);
    }

    public Price<A> times(double that) {
        return Price$.MODULE$.apply(this.money().$times(that), this.quantity());
    }

    public Price<A> $times(double that) {
        return Price$.MODULE$.apply(this.money().$times(that), this.quantity());
    }

    public Price<A> times(BigDecimal that) {
        return Price$.MODULE$.apply(this.money().$times(that), this.quantity());
    }

    public Price<A> $times(BigDecimal that) {
        return Price$.MODULE$.apply(this.money().$times(that), this.quantity());
    }

    public Price<A> divide(double that) {
        return Price$.MODULE$.apply(this.money().$div(that), this.quantity());
    }

    public Price<A> $div(double that) {
        return this.divide(that);
    }

    public Price<A> divide(BigDecimal that) {
        return Price$.MODULE$.apply(this.money().$div(that), this.quantity());
    }

    public Price<A> $div(BigDecimal that) {
        return this.divide(that);
    }

    public BigDecimal divide(Price<A> that) {
        return this.money().amount().$div(that.money().amount());
    }

    public BigDecimal $div(Price<A> that) {
        return this.divide(that);
    }

    public Price<A> in(Currency currency, MoneyContext moneyContext) {
        return this.money().in(currency, moneyContext).$div(this.quantity());
    }

    public Money $times(A that) {
        return (Money)this.convertToBase((Quantity)that);
    }

    public A $times(Money that) {
        return that.$div(this);
    }

    public String toString() {
        return this.money().toString() + "/" + ((Quantity)this.quantity()).toString();
    }

    public String toString(UnitOfMeasure<A> unit) {
        return this.money().toString() + "/" + ((Quantity)this.quantity()).toString(unit);
    }

    public String toString(Currency currency, UnitOfMeasure<A> unit, MoneyContext moneyContext) {
        return this.money().in(currency, moneyContext).toString() + "/" + ((Quantity)this.quantity()).toString(unit);
    }

    public <A extends Quantity<A>> Price<A> copy(Money money, A quantity) {
        return new Price<A>(money, quantity);
    }

    public <A extends Quantity<A>> Money copy$default$1() {
        return this.money();
    }

    public <A extends Quantity<A>> A copy$default$2() {
        return this.quantity();
    }

    public Money _1() {
        return this.money();
    }

    public A _2() {
        return this.quantity();
    }
}

