/*
 * Decompiled with CFR 0.152.
 */
package squants.mass;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiBaseUnit;
import squants.UnitOfMeasure;
import squants.energy.Energy;
import squants.energy.Joules$;
import squants.energy.SpecificEnergy;
import squants.mass.AreaDensity;
import squants.mass.Carats$;
import squants.mass.Density;
import squants.mass.Density$;
import squants.mass.ElectronVoltMass$;
import squants.mass.ExaElectronVoltMass$;
import squants.mass.GigaElectronVoltMass$;
import squants.mass.Grams$;
import squants.mass.KiloElectronVoltMass$;
import squants.mass.Kilograms$;
import squants.mass.KilogramsMetersSquared$;
import squants.mass.KilogramsPerSquareMeter$;
import squants.mass.Kilopounds$;
import squants.mass.Mass$;
import squants.mass.MassUnit;
import squants.mass.MegaElectronVoltMass$;
import squants.mass.Megapounds$;
import squants.mass.Micrograms$;
import squants.mass.MilliElectronVoltMass$;
import squants.mass.Milligrams$;
import squants.mass.MomentOfInertia;
import squants.mass.Nanograms$;
import squants.mass.Ounces$;
import squants.mass.Pennyweights$;
import squants.mass.PetaElectronVoltMass$;
import squants.mass.Pounds$;
import squants.mass.SolarMasses$;
import squants.mass.Stone$;
import squants.mass.TeraElectronVoltMass$;
import squants.mass.Tolas$;
import squants.mass.Tonnes$;
import squants.mass.TroyGrains$;
import squants.mass.TroyOunces$;
import squants.mass.TroyPounds$;
import squants.motion.Acceleration;
import squants.motion.Force;
import squants.motion.KilogramsPerSecond$;
import squants.motion.MassFlow;
import squants.motion.Momentum;
import squants.motion.Momentum$;
import squants.motion.Newtons$;
import squants.motion.Velocity;
import squants.package$;
import squants.space.Area;
import squants.space.CubicMeters$;
import squants.space.Length;
import squants.space.SquareMeters$;
import squants.space.Volume;
import squants.time.Time;
import squants.time.TimeIntegral;

public final class Mass
extends Quantity<Mass>
implements TimeIntegral<MassFlow> {
    private final double value;
    private final MassUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Mass$.class, "0bitmap$1");

    public static Try<Mass> apply(Object object) {
        return Mass$.MODULE$.apply(object);
    }

    public static <A> Mass apply(A a, MassUnit massUnit, Numeric<A> numeric) {
        return Mass$.MODULE$.apply(a, massUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Mass$.MODULE$.dimensionImplicit();
    }

    public static String dimensionSymbol() {
        return Mass$.MODULE$.dimensionSymbol();
    }

    public static String name() {
        return Mass$.MODULE$.name();
    }

    public static Try<Mass> parseString(String string) {
        return Mass$.MODULE$.parseString(string);
    }

    public static <N> Try<Mass> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Mass$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Mass$.MODULE$.primaryUnit();
    }

    public static SiBaseUnit siUnit() {
        return Mass$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Mass>> symbolToUnit(String string) {
        return Mass$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Mass$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Mass$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Mass(double value, MassUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public MassUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Mass> dimension() {
        return Mass$.MODULE$;
    }

    @Override
    public MassFlow timeDerived() {
        return KilogramsPerSecond$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toKilograms()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return package$.MODULE$.Seconds().apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Energy $times(SpecificEnergy that) {
        return Joules$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() * that.toGrays())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Momentum $times(Velocity that) {
        return Momentum$.MODULE$.apply(this, that);
    }

    public Force $times(Acceleration that) {
        return Newtons$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() * that.toMetersPerSecondSquared())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Volume $div(Density that) {
        return CubicMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() / that.toKilogramsPerCubicMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Density $div(Volume that) {
        return Density$.MODULE$.apply(this, that);
    }

    public Area $div(AreaDensity that) {
        return SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() / that.toKilogramsPerSquareMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public AreaDensity $div(Area that) {
        return KilogramsPerSquareMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public MomentOfInertia onRadius(Length radius) {
        return KilogramsMetersSquared$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() * radius.squared().toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toNanograms() {
        return this.to(Nanograms$.MODULE$);
    }

    public double toMicrograms() {
        return this.to(Micrograms$.MODULE$);
    }

    public double toMilligrams() {
        return this.to(Milligrams$.MODULE$);
    }

    public double toGrams() {
        return this.to(Grams$.MODULE$);
    }

    public double toKilograms() {
        return this.to(Kilograms$.MODULE$);
    }

    public double toTonnes() {
        return this.to(Tonnes$.MODULE$);
    }

    public double toOunces() {
        return this.to(Ounces$.MODULE$);
    }

    public double toPounds() {
        return this.to(Pounds$.MODULE$);
    }

    public double toKilopounds() {
        return this.to(Kilopounds$.MODULE$);
    }

    public double toMegapounds() {
        return this.to(Megapounds$.MODULE$);
    }

    public double toStone() {
        return this.to(Stone$.MODULE$);
    }

    public double toTroyGrains() {
        return this.to(TroyGrains$.MODULE$);
    }

    public double toPennyweights() {
        return this.to(Pennyweights$.MODULE$);
    }

    public double toTroyOunces() {
        return this.to(TroyOunces$.MODULE$);
    }

    public double toTroyPounds() {
        return this.to(TroyPounds$.MODULE$);
    }

    public double toTolas() {
        return this.to(Tolas$.MODULE$);
    }

    public double toCarats() {
        return this.to(Carats$.MODULE$);
    }

    public double toSolarMasses() {
        return this.to(SolarMasses$.MODULE$);
    }

    public double toeV() {
        return this.to(ElectronVoltMass$.MODULE$);
    }

    public double tomeV() {
        return this.to(MilliElectronVoltMass$.MODULE$);
    }

    public double tokeV() {
        return this.to(KiloElectronVoltMass$.MODULE$);
    }

    public double toMeV() {
        return this.to(MegaElectronVoltMass$.MODULE$);
    }

    public double toGeV() {
        return this.to(GigaElectronVoltMass$.MODULE$);
    }

    public double toTeV() {
        return this.to(TeraElectronVoltMass$.MODULE$);
    }

    public double toPeV() {
        return this.to(PetaElectronVoltMass$.MODULE$);
    }

    public double toEeV() {
        return this.to(ExaElectronVoltMass$.MODULE$);
    }
}

