/*
 * Decompiled with CFR 0.152.
 */
package squants.motion;

import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.energy.Energy;
import squants.energy.Joules$;
import squants.mass.Kilograms$;
import squants.mass.Mass;
import squants.motion.Acceleration;
import squants.motion.Force$;
import squants.motion.ForceUnit;
import squants.motion.KiloElectronVoltsPerMicrometer$;
import squants.motion.KilogramForce$;
import squants.motion.MegaElectronVoltsPerCentimeter$;
import squants.motion.MetersPerSecondSquared$;
import squants.motion.Momentum;
import squants.motion.NewtonSeconds$;
import squants.motion.Newtons$;
import squants.motion.NewtonsPerSecond$;
import squants.motion.Pascals$;
import squants.motion.PoundForce$;
import squants.motion.Pressure;
import squants.motion.Yank;
import squants.space.Area;
import squants.space.Length;
import squants.space.SquareMeters$;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeDerivative;
import squants.time.TimeIntegral;

public final class Force
extends Quantity<Force>
implements TimeDerivative<Momentum>,
TimeIntegral<Yank> {
    private final double value;
    private final ForceUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Force$.class, "0bitmap$1");

    public static Try<Force> apply(Object object) {
        return Force$.MODULE$.apply(object);
    }

    public static <A> Force apply(A a, ForceUnit forceUnit, Numeric<A> numeric) {
        return Force$.MODULE$.apply(a, forceUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Force$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Force$.MODULE$.name();
    }

    public static Try<Force> parseString(String string) {
        return Force$.MODULE$.parseString(string);
    }

    public static <N> Try<Force> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Force$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Force$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Force$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Force>> symbolToUnit(String string) {
        return Force$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Force$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Force$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Force(double value, ForceUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public ForceUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Force> dimension() {
        return Force$.MODULE$;
    }

    @Override
    public Momentum timeIntegrated() {
        return NewtonSeconds$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toNewtons()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Yank timeDerived() {
        return NewtonsPerSecond$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toNewtons()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Energy $times(Length that) {
        return Joules$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() * that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Nothing$ $div(Length that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Acceleration $div(Mass that) {
        return MetersPerSecondSquared$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() / that.toKilograms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Mass $div(Acceleration that) {
        return Kilograms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() / that.toMetersPerSecondSquared())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Pressure $div(Area that) {
        return Pascals$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Area $div(Pressure that) {
        return SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() / that.toPascals())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toNewtons() {
        return this.to(Newtons$.MODULE$);
    }

    public double toKilogramForce() {
        return this.to(KilogramForce$.MODULE$);
    }

    public double toPoundForce() {
        return this.to(PoundForce$.MODULE$);
    }

    public double toKiloElectronVoltsPerMicrometer() {
        return this.to(KiloElectronVoltsPerMicrometer$.MODULE$);
    }

    public double toMegaElectronVoltsPerCentimeter() {
        return this.to(MegaElectronVoltsPerCentimeter$.MODULE$);
    }
}

