/*
 * Decompiled with CFR 0.152.
 */
package squants.motion;

import scala.math.Numeric;
import squants.motion.Force;
import squants.motion.ForceConversions$;
import squants.motion.KiloElectronVoltsPerMicrometer$;
import squants.motion.KilogramForce$;
import squants.motion.MegaElectronVoltsPerCentimeter$;
import squants.motion.Newtons$;
import squants.motion.PoundForce$;

public final class ForceConversions {
    public static <A> ForceConversions<A> ForceConversions(A a, Numeric<A> numeric) {
        return ForceConversions$.MODULE$.ForceConversions(a, numeric);
    }

    public static Force kiloElectronVoltsPerMicrometer() {
        return ForceConversions$.MODULE$.kiloElectronVoltsPerMicrometer();
    }

    public static Force kilogramForce() {
        return ForceConversions$.MODULE$.kilogramForce();
    }

    public static Force megaElectronVoltsPerCentimeter() {
        return ForceConversions$.MODULE$.megaElectronVoltsPerCentimeter();
    }

    public static Force newton() {
        return ForceConversions$.MODULE$.newton();
    }

    public static Force poundForce() {
        return ForceConversions$.MODULE$.poundForce();
    }

    public static class ForceConversions<A> {
        private final A n;
        private final Numeric<A> num;

        public <A> ForceConversions(A n, Numeric<A> num) {
            this.n = n;
            this.num = num;
        }

        public Force newtons() {
            return Newtons$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Force kilogramForce() {
            return KilogramForce$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Force poundForce() {
            return PoundForce$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Force lbf() {
            return PoundForce$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Force kiloElectronVoltsPerMicrometer() {
            return KiloElectronVoltsPerMicrometer$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Force megaElectronVoltsPerCentimeter() {
            return MegaElectronVoltsPerCentimeter$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }
    }
}

