/*
 * Decompiled with CFR 0.152.
 */
package squants.motion;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.mass.Kilograms$;
import squants.mass.Mass;
import squants.motion.Force;
import squants.motion.MetersPerSecond$;
import squants.motion.Momentum$;
import squants.motion.MomentumUnit;
import squants.motion.NewtonSeconds$;
import squants.motion.Newtons$;
import squants.motion.Velocity;
import squants.motion.Yank;
import squants.time.SecondTimeIntegral;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeIntegral;
import squants.time.TimeSquared;

public final class Momentum
extends Quantity<Momentum>
implements TimeIntegral<Force>,
SecondTimeIntegral<Yank> {
    private final double value;
    private final MomentumUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Momentum$.class, "0bitmap$1");

    public static Momentum apply(Mass mass, Velocity velocity) {
        return Momentum$.MODULE$.apply(mass, velocity);
    }

    public static Try<Momentum> apply(Object object) {
        return Momentum$.MODULE$.apply(object);
    }

    public static <A> Momentum apply(A a, MomentumUnit momentumUnit, Numeric<A> numeric) {
        return Momentum$.MODULE$.apply(a, momentumUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Momentum$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Momentum$.MODULE$.name();
    }

    public static Try<Momentum> parseString(String string) {
        return Momentum$.MODULE$.parseString(string);
    }

    public static <N> Try<Momentum> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Momentum$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Momentum$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Momentum$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Momentum>> symbolToUnit(String string) {
        return Momentum$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Momentum$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Momentum$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Momentum(double value, MomentumUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public MomentumUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Momentum> dimension() {
        return Momentum$.MODULE$;
    }

    @Override
    public Force timeDerived() {
        return Newtons$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toNewtonSeconds()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Mass $div(Velocity that) {
        return Kilograms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtonSeconds() / that.toMetersPerSecond())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Velocity $div(Mass that) {
        return MetersPerSecond$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtonSeconds() / that.toKilograms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Yank $div(TimeSquared that) {
        return (Yank)((TimeIntegral)((Object)this.$div(that.time1()))).$div(that.time2());
    }

    @Override
    public TimeSquared $div(Yank that) {
        return this.$div(that.timeIntegrated()).$times(this.time());
    }

    public double toNewtonSeconds() {
        return this.to(NewtonSeconds$.MODULE$);
    }
}

