/*
 * Decompiled with CFR 0.152.
 */
package squants.motion;

import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.motion.Bars$;
import squants.motion.Force;
import squants.motion.InchesOfMercury$;
import squants.motion.MillimetersOfMercury$;
import squants.motion.Newtons$;
import squants.motion.Pascals$;
import squants.motion.PascalsPerSecond$;
import squants.motion.PoundsPerSquareInch$;
import squants.motion.Pressure$;
import squants.motion.PressureChange;
import squants.motion.PressureUnit;
import squants.motion.StandardAtmospheres$;
import squants.motion.Torrs$;
import squants.package$;
import squants.space.Area;
import squants.time.Time;
import squants.time.TimeIntegral;

public final class Pressure
extends Quantity<Pressure>
implements TimeIntegral<PressureChange> {
    private final double value;
    private final PressureUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Pressure$.class, "0bitmap$1");

    public static Try<Pressure> apply(Object object) {
        return Pressure$.MODULE$.apply(object);
    }

    public static <A> Pressure apply(A a, PressureUnit pressureUnit, Numeric<A> numeric) {
        return Pressure$.MODULE$.apply(a, pressureUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Pressure$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Pressure$.MODULE$.name();
    }

    public static Try<Pressure> parseString(String string) {
        return Pressure$.MODULE$.parseString(string);
    }

    public static <N> Try<Pressure> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Pressure$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Pressure$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Pressure$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Pressure>> symbolToUnit(String string) {
        return Pressure$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Pressure$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Pressure$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Pressure(double value, PressureUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public PressureUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Pressure> dimension() {
        return Pressure$.MODULE$;
    }

    @Override
    public PressureChange timeDerived() {
        return PascalsPerSecond$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toPascals()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return package$.MODULE$.Seconds().apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Force $times(Area that) {
        return Newtons$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toPascals() * that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Nothing$ $times(Time that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public double toPascals() {
        return this.to(Pascals$.MODULE$);
    }

    public double toBars() {
        return this.to(Bars$.MODULE$);
    }

    public double toPoundsPerSquareInch() {
        return this.to(PoundsPerSquareInch$.MODULE$);
    }

    public double toStandardAtmospheres() {
        return this.to(StandardAtmospheres$.MODULE$);
    }

    public double toMillimetersOfMercury() {
        return this.to(MillimetersOfMercury$.MODULE$);
    }

    public double toInchesOfMercury() {
        return this.to(InchesOfMercury$.MODULE$);
    }

    public double toTorr() {
        return this.to(Torrs$.MODULE$);
    }
}

