/*
 * Decompiled with CFR 0.152.
 */
package squants.motion;

import scala.math.Numeric;
import squants.motion.Bars$;
import squants.motion.InchesOfMercury$;
import squants.motion.MillimetersOfMercury$;
import squants.motion.Pascals$;
import squants.motion.PoundsPerSquareInch$;
import squants.motion.Pressure;
import squants.motion.PressureConversions$;
import squants.motion.StandardAtmospheres$;
import squants.motion.Torrs$;

public final class PressureConversions {
    public static <A> PressureConversions<A> PressureConversions(A a, Numeric<A> numeric) {
        return PressureConversions$.MODULE$.PressureConversions(a, numeric);
    }

    public static Pressure atm() {
        return PressureConversions$.MODULE$.atm();
    }

    public static Pressure bar() {
        return PressureConversions$.MODULE$.bar();
    }

    public static Pressure inHg() {
        return PressureConversions$.MODULE$.inHg();
    }

    public static Pressure mmHg() {
        return PressureConversions$.MODULE$.mmHg();
    }

    public static Pressure pascal() {
        return PressureConversions$.MODULE$.pascal();
    }

    public static Pressure psi() {
        return PressureConversions$.MODULE$.psi();
    }

    public static Pressure torr() {
        return PressureConversions$.MODULE$.torr();
    }

    public static class PressureConversions<A> {
        private final A n;
        private final Numeric<A> num;

        public <A> PressureConversions(A n, Numeric<A> num) {
            this.n = n;
            this.num = num;
        }

        public Pressure pascals() {
            return Pascals$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Pressure bars() {
            return Bars$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Pressure psi() {
            return PoundsPerSquareInch$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Pressure atm() {
            return StandardAtmospheres$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Pressure mmHg() {
            return MillimetersOfMercury$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Pressure inHg() {
            return InchesOfMercury$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Pressure torr() {
            return Torrs$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }
    }
}

