/*
 * Decompiled with CFR 0.152.
 */
package squants.motion;

import scala.math.Numeric;
import squants.motion.FeetPerSecond$;
import squants.motion.KilometersPerHour$;
import squants.motion.KilometersPerSecond$;
import squants.motion.Knots$;
import squants.motion.MetersPerSecond$;
import squants.motion.UsMilesPerHour$;
import squants.motion.Velocity;
import squants.motion.VelocityConversions$;

public final class VelocityConversions {
    public static <A> VelocityConversions<A> VelocityConversions(A a, Numeric<A> numeric) {
        return VelocityConversions$.MODULE$.VelocityConversions(a, numeric);
    }

    public static Velocity footPerSecond() {
        return VelocityConversions$.MODULE$.footPerSecond();
    }

    public static Velocity kilometerPerHour() {
        return VelocityConversions$.MODULE$.kilometerPerHour();
    }

    public static Velocity kilometerPerSecond() {
        return VelocityConversions$.MODULE$.kilometerPerSecond();
    }

    public static Velocity knot() {
        return VelocityConversions$.MODULE$.knot();
    }

    public static Velocity meterPerSecond() {
        return VelocityConversions$.MODULE$.meterPerSecond();
    }

    public static Velocity milePerHour() {
        return VelocityConversions$.MODULE$.milePerHour();
    }

    public static Velocity millimeterPerSecond() {
        return VelocityConversions$.MODULE$.millimeterPerSecond();
    }

    public static class VelocityConversions<A> {
        private final A n;
        private final Numeric<A> num;

        public <A> VelocityConversions(A n, Numeric<A> num) {
            this.n = n;
            this.num = num;
        }

        public Velocity fps() {
            return FeetPerSecond$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Velocity mps() {
            return MetersPerSecond$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Velocity kps() {
            return KilometersPerSecond$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Velocity kph() {
            return KilometersPerHour$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Velocity mph() {
            return UsMilesPerHour$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Velocity knots() {
            return Knots$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }
    }
}

