/*
 * Decompiled with CFR 0.152.
 */
package squants.radio;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.energy.Energy;
import squants.energy.Power;
import squants.energy.WattHours$;
import squants.energy.Watts$;
import squants.radio.AreaTime;
import squants.radio.BecquerelsPerSquareMeterSecond$;
import squants.radio.ErgsPerSecondPerSquareCentimeter$;
import squants.radio.Irradiance$;
import squants.radio.IrradianceUnit;
import squants.radio.ParticleFlux;
import squants.radio.WattsPerSquareMeter$;
import squants.space.Area;
import squants.time.Hours$;

public final class Irradiance
extends Quantity<Irradiance> {
    private final double value;
    private final IrradianceUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Irradiance$.class, "0bitmap$1");

    public static Try<Irradiance> apply(Object object) {
        return Irradiance$.MODULE$.apply(object);
    }

    public static <A> Irradiance apply(A a, IrradianceUnit irradianceUnit, Numeric<A> numeric) {
        return Irradiance$.MODULE$.apply(a, irradianceUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Irradiance$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Irradiance$.MODULE$.name();
    }

    public static Try<Irradiance> parseString(String string) {
        return Irradiance$.MODULE$.parseString(string);
    }

    public static <N> Try<Irradiance> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Irradiance$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Irradiance$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Irradiance$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Irradiance>> symbolToUnit(String string) {
        return Irradiance$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Irradiance$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Irradiance$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Irradiance(double value, IrradianceUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public IrradianceUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Irradiance> dimension() {
        return Irradiance$.MODULE$;
    }

    public Power $times(Area that) {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWattsPerSquareMeter() * that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Energy $times(AreaTime that) {
        return WattHours$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWattsPerSquareMeter() * that.toSquareMeterSeconds() / Hours$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$).toSeconds())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ParticleFlux $div(Energy that) {
        return BecquerelsPerSquareMeterSecond$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWattsPerSquareMeter() / (that.toWattHours() * Hours$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$).toSeconds()))), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Energy $div(ParticleFlux that) {
        return WattHours$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWattsPerSquareMeter() / that.toBecquerelsPerSquareMeterSecond() / Hours$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$).toSeconds())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toWattsPerSquareMeter() {
        return this.to(WattsPerSquareMeter$.MODULE$);
    }

    public double toErgsPerSecondPerSquareCentimeter() {
        return this.to(ErgsPerSecondPerSquareCentimeter$.MODULE$);
    }
}

