/*
 * Decompiled with CFR 0.152.
 */
package squants.radio;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.energy.Energy;
import squants.radio.Activity;
import squants.radio.AreaTime;
import squants.radio.Becquerels$;
import squants.radio.BecquerelsPerSquareCentimeterSecond$;
import squants.radio.BecquerelsPerSquareMeterSecond$;
import squants.radio.Irradiance;
import squants.radio.ParticleFlux$;
import squants.radio.ParticleFluxUnit;
import squants.radio.WattsPerSquareMeter$;
import squants.time.Hours$;

public final class ParticleFlux
extends Quantity<ParticleFlux> {
    private final double value;
    private final ParticleFluxUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(ParticleFlux$.class, "0bitmap$1");

    public static Try<ParticleFlux> apply(Object object) {
        return ParticleFlux$.MODULE$.apply(object);
    }

    public static <A> ParticleFlux apply(A a, ParticleFluxUnit particleFluxUnit, Numeric<A> numeric) {
        return ParticleFlux$.MODULE$.apply(a, particleFluxUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return ParticleFlux$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return ParticleFlux$.MODULE$.name();
    }

    public static Try<ParticleFlux> parseString(String string) {
        return ParticleFlux$.MODULE$.parseString(string);
    }

    public static <N> Try<ParticleFlux> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return ParticleFlux$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return ParticleFlux$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return ParticleFlux$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<ParticleFlux>> symbolToUnit(String string) {
        return ParticleFlux$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return ParticleFlux$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        ParticleFlux$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public ParticleFlux(double value, ParticleFluxUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public ParticleFluxUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<ParticleFlux> dimension() {
        return ParticleFlux$.MODULE$;
    }

    public Activity $times(AreaTime that) {
        return Becquerels$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toBecquerelsPerSquareMeterSecond() * that.toSquareMeterSeconds())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Irradiance $times(Energy that) {
        return WattsPerSquareMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(Hours$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$).toSeconds() * that.toWattHours() * this.toBecquerelsPerSquareMeterSecond())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toBecquerelsPerSquareMeterSecond() {
        return this.to(BecquerelsPerSquareMeterSecond$.MODULE$);
    }

    public double toBecquerelsPerSquareCentimeterSecond() {
        return this.to(BecquerelsPerSquareCentimeterSecond$.MODULE$);
    }
}

