/*
 * Decompiled with CFR 0.152.
 */
package squants.radio;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.energy.Power;
import squants.energy.Watts$;
import squants.package$;
import squants.radio.Radiance;
import squants.radio.RadiantIntensity$;
import squants.radio.RadiantIntensityUnit;
import squants.radio.SpectralIntensity;
import squants.radio.WattsPerSteradian$;
import squants.radio.WattsPerSteradianPerMeter$;
import squants.radio.WattsPerSteradianPerSquareMeter$;
import squants.space.Area;
import squants.space.Length;
import squants.space.SolidAngle;
import squants.space.SquareMeters$;

public final class RadiantIntensity
extends Quantity<RadiantIntensity> {
    private final double value;
    private final RadiantIntensityUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(RadiantIntensity$.class, "0bitmap$1");

    public static Try<RadiantIntensity> apply(Object object) {
        return RadiantIntensity$.MODULE$.apply(object);
    }

    public static <A> RadiantIntensity apply(A a, RadiantIntensityUnit radiantIntensityUnit, Numeric<A> numeric) {
        return RadiantIntensity$.MODULE$.apply(a, radiantIntensityUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return RadiantIntensity$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return RadiantIntensity$.MODULE$.name();
    }

    public static Try<RadiantIntensity> parseString(String string) {
        return RadiantIntensity$.MODULE$.parseString(string);
    }

    public static <N> Try<RadiantIntensity> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return RadiantIntensity$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return RadiantIntensity$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return RadiantIntensity$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<RadiantIntensity>> symbolToUnit(String string) {
        return RadiantIntensity$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return RadiantIntensity$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        RadiantIntensity$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public RadiantIntensity(double value, RadiantIntensityUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public RadiantIntensityUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<RadiantIntensity> dimension() {
        return RadiantIntensity$.MODULE$;
    }

    public Power $times(SolidAngle that) {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWattsPerSteradian() * that.toSquaredRadians())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public SolidAngle $div(Power that) {
        return package$.MODULE$.SquareRadians().apply(BoxesRunTime.boxToDouble((double)(this.toWattsPerSteradian() / that.toWatts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public SpectralIntensity $div(Length that) {
        return WattsPerSteradianPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWattsPerSteradian() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Length $div(SpectralIntensity that) {
        return package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)(this.toWattsPerSteradian() / that.toWattsPerSteradianPerMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Radiance $div(Area that) {
        return WattsPerSteradianPerSquareMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWattsPerSteradian() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Area $div(Radiance that) {
        return SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWattsPerSteradian() / that.toWattsPerSteradianPerSquareMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toWattsPerSteradian() {
        return this.to(WattsPerSteradian$.MODULE$);
    }
}

