/*
 * Decompiled with CFR 0.152.
 */
package squants.space;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.electro.MagneticFlux;
import squants.electro.MagneticFluxDensity;
import squants.electro.Webers$;
import squants.energy.Power;
import squants.energy.Watts$;
import squants.mass.AreaDensity;
import squants.mass.Mass;
import squants.motion.Force;
import squants.motion.Newtons$;
import squants.motion.Pressure;
import squants.package$;
import squants.photo.Candelas$;
import squants.photo.Illuminance;
import squants.photo.Lumens$;
import squants.photo.Luminance;
import squants.photo.LuminousFlux;
import squants.photo.LuminousIntensity;
import squants.radio.AreaTime;
import squants.radio.Irradiance;
import squants.radio.Radiance;
import squants.radio.RadiantIntensity;
import squants.radio.SquareMeterSeconds$;
import squants.radio.WattsPerSteradian$;
import squants.space.Acres$;
import squants.space.Area$;
import squants.space.AreaUnit;
import squants.space.Barnes$;
import squants.space.CubicFeet$;
import squants.space.CubicInches$;
import squants.space.CubicMeters$;
import squants.space.CubicUsMiles$;
import squants.space.CubicYards$;
import squants.space.Feet$;
import squants.space.Hectares$;
import squants.space.Inches$;
import squants.space.Length;
import squants.space.SquareCentimeters$;
import squants.space.SquareFeet$;
import squants.space.SquareInches$;
import squants.space.SquareKilometers$;
import squants.space.SquareMeters$;
import squants.space.SquareUsMiles$;
import squants.space.SquareYards$;
import squants.space.UsMiles$;
import squants.space.Volume;
import squants.space.Yards$;
import squants.time.Time;

public final class Area
extends Quantity<Area> {
    private final double value;
    private final AreaUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Area$.class, "0bitmap$1");

    public static Try<Area> apply(Object object) {
        return Area$.MODULE$.apply(object);
    }

    public static <A> Area apply(A a, AreaUnit areaUnit, Numeric<A> numeric) {
        return Area$.MODULE$.apply(a, areaUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Area$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Area$.MODULE$.name();
    }

    public static Try<Area> parseString(String string) {
        return Area$.MODULE$.parseString(string);
    }

    public static <N> Try<Area> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Area$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Area$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Area$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Area>> symbolToUnit(String string) {
        return Area$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Area$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Area$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Area(double value, AreaUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public AreaUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Area> dimension() {
        return Area$.MODULE$;
    }

    public Volume $times(Length that) {
        AreaUnit areaUnit = this.unit();
        return SquareUsMiles$.MODULE$.equals(areaUnit) ? CubicUsMiles$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toUsMiles())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (SquareYards$.MODULE$.equals(areaUnit) ? CubicYards$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toYards())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (SquareFeet$.MODULE$.equals(areaUnit) ? CubicFeet$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toFeet())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (SquareInches$.MODULE$.equals(areaUnit) ? CubicInches$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toInches())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : CubicMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$))));
    }

    public Mass $times(AreaDensity that) {
        return package$.MODULE$.Kilograms().apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toKilogramsPerSquareMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Force $times(Pressure that) {
        return Newtons$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toPascals())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public LuminousFlux $times(Illuminance that) {
        return Lumens$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toLux())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public LuminousIntensity $times(Luminance that) {
        return Candelas$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toCandelasPerSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public MagneticFlux $times(MagneticFluxDensity that) {
        return Webers$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toTeslas())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Power $times(Irradiance that) {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toWattsPerSquareMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public RadiantIntensity $times(Radiance that) {
        return WattsPerSteradian$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toWattsPerSteradianPerSquareMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public AreaTime $times(Time that) {
        return SquareMeterSeconds$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toSeconds())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Length $div(Length that) {
        AreaUnit areaUnit = this.unit();
        return SquareUsMiles$.MODULE$.equals(areaUnit) ? UsMiles$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toUsMiles())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (SquareYards$.MODULE$.equals(areaUnit) ? Yards$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toYards())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (SquareFeet$.MODULE$.equals(areaUnit) ? Feet$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toFeet())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (SquareInches$.MODULE$.equals(areaUnit) ? Inches$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toInches())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$))));
    }

    public Length squareRoot() {
        return package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.sqrt(this.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toSquareMeters() {
        return this.to(SquareMeters$.MODULE$);
    }

    public double toSquareCentimeters() {
        return this.to(SquareCentimeters$.MODULE$);
    }

    public double toSquareKilometers() {
        return this.to(SquareKilometers$.MODULE$);
    }

    public double toSquareUsMiles() {
        return this.to(SquareUsMiles$.MODULE$);
    }

    public double toSquareYards() {
        return this.to(SquareYards$.MODULE$);
    }

    public double toSquareFeet() {
        return this.to(SquareFeet$.MODULE$);
    }

    public double toSquareInches() {
        return this.to(SquareInches$.MODULE$);
    }

    public double toHectares() {
        return this.to(Hectares$.MODULE$);
    }

    public double toAcres() {
        return this.to(Acres$.MODULE$);
    }

    public double toBarnes() {
        return this.to(Barnes$.MODULE$);
    }
}

