/*
 * Decompiled with CFR 0.152.
 */
package squants.space;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiBaseUnit;
import squants.UnitOfMeasure;
import squants.electro.Conductivity;
import squants.electro.ElectricalConductance;
import squants.electro.ElectricalResistance;
import squants.electro.OhmMeters$;
import squants.electro.Resistivity;
import squants.electro.Siemens$;
import squants.energy.Energy;
import squants.energy.Joules$;
import squants.energy.Power;
import squants.energy.Watts$;
import squants.motion.Acceleration;
import squants.motion.Force;
import squants.motion.MetersPerSecond$;
import squants.motion.Velocity;
import squants.package$;
import squants.radio.RadiantIntensity;
import squants.radio.SpectralIntensity;
import squants.radio.SpectralPower;
import squants.radio.WattsPerSteradian$;
import squants.space.Angstroms$;
import squants.space.Area;
import squants.space.AstronomicalUnits$;
import squants.space.Centimeters$;
import squants.space.CubicFeet$;
import squants.space.CubicInches$;
import squants.space.CubicMeters$;
import squants.space.CubicYards$;
import squants.space.Decameters$;
import squants.space.Decimeters$;
import squants.space.ElectronVoltLength$;
import squants.space.ExaElectronVoltLength$;
import squants.space.Feet$;
import squants.space.GigaElectronVoltLength$;
import squants.space.GigaParsecs$;
import squants.space.Hectometers$;
import squants.space.Inches$;
import squants.space.InternationalMiles$;
import squants.space.KiloElectronVoltLength$;
import squants.space.KiloParsecs$;
import squants.space.Kilometers$;
import squants.space.Length$;
import squants.space.LengthUnit;
import squants.space.LightYears$;
import squants.space.MegaElectronVoltLength$;
import squants.space.MegaParsecs$;
import squants.space.Meters$;
import squants.space.Microns$;
import squants.space.MilliElectronVoltLength$;
import squants.space.Millimeters$;
import squants.space.Nanometers$;
import squants.space.NauticalMiles$;
import squants.space.NominalSolarRadii$;
import squants.space.Parsecs$;
import squants.space.PetaElectronVoltLength$;
import squants.space.SolarRadii$;
import squants.space.SquareCentimeters$;
import squants.space.SquareFeet$;
import squants.space.SquareInches$;
import squants.space.SquareKilometers$;
import squants.space.SquareMeters$;
import squants.space.SquareUsMiles$;
import squants.space.SquareYards$;
import squants.space.TeraElectronVoltLength$;
import squants.space.UsMiles$;
import squants.space.Volume;
import squants.space.Yards$;
import squants.time.SecondTimeIntegral;
import squants.time.Time;
import squants.time.TimeIntegral;
import squants.time.TimeSquared;

public final class Length
extends Quantity<Length>
implements TimeIntegral<Velocity>,
SecondTimeIntegral<Acceleration> {
    private final double value;
    private final LengthUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Length$.class, "0bitmap$1");

    public static Try<Length> apply(Object object) {
        return Length$.MODULE$.apply(object);
    }

    public static <A> Length apply(A a, LengthUnit lengthUnit, Numeric<A> numeric) {
        return Length$.MODULE$.apply(a, lengthUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Length$.MODULE$.dimensionImplicit();
    }

    public static String dimensionSymbol() {
        return Length$.MODULE$.dimensionSymbol();
    }

    public static String name() {
        return Length$.MODULE$.name();
    }

    public static Try<Length> parseString(String string) {
        return Length$.MODULE$.parseString(string);
    }

    public static <N> Try<Length> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Length$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Length$.MODULE$.primaryUnit();
    }

    public static SiBaseUnit siUnit() {
        return Length$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Length>> symbolToUnit(String string) {
        return Length$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Length$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Length$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Length(double value, LengthUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public LengthUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Length> dimension() {
        return Length$.MODULE$;
    }

    @Override
    public Velocity timeDerived() {
        return MetersPerSecond$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toMeters()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return package$.MODULE$.Seconds().apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Area $times(Length that) {
        LengthUnit lengthUnit = this.unit();
        return Centimeters$.MODULE$.equals(lengthUnit) ? SquareCentimeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toCentimeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (Kilometers$.MODULE$.equals(lengthUnit) ? SquareKilometers$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toKilometers())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (UsMiles$.MODULE$.equals(lengthUnit) ? SquareUsMiles$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toUsMiles())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (Yards$.MODULE$.equals(lengthUnit) ? SquareYards$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toYards())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (Feet$.MODULE$.equals(lengthUnit) ? SquareFeet$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toFeet())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (Inches$.MODULE$.equals(lengthUnit) ? SquareInches$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toInches())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toMeters() * that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$))))));
    }

    public Volume $times(Area that) {
        LengthUnit lengthUnit = this.unit();
        return Yards$.MODULE$.equals(lengthUnit) ? CubicYards$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toSquareYards())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (Feet$.MODULE$.equals(lengthUnit) ? CubicFeet$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toSquareFeet())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (Inches$.MODULE$.equals(lengthUnit) ? CubicInches$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toSquareInches())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : CubicMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toMeters() * that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$)));
    }

    public Energy $times(Force that) {
        return Joules$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toMeters() * that.toNewtons())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public RadiantIntensity $times(SpectralIntensity that) {
        return WattsPerSteradian$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toMeters() * that.toWattsPerSteradianPerMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Power $times(SpectralPower that) {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toMeters() * that.toWattsPerMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricalConductance $times(Conductivity that) {
        return Siemens$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toMeters() * that.toSiemensPerMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Resistivity $times(ElectricalResistance that) {
        return OhmMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toMeters() * that.toOhms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Acceleration $div(TimeSquared that) {
        return (Acceleration)((TimeIntegral)((Object)this.$div(that.time1()))).$div(that.time2());
    }

    @Override
    public TimeSquared $div(Acceleration that) {
        return this.$div(that.timeIntegrated()).$times(this.time());
    }

    public Area squared() {
        return this.$times(this);
    }

    public Volume cubed() {
        return this.$times(this).$times(this);
    }

    public double toAngstroms() {
        return this.to(Angstroms$.MODULE$);
    }

    public double toNanometers() {
        return this.to(Nanometers$.MODULE$);
    }

    public double toMicrons() {
        return this.to(Microns$.MODULE$);
    }

    public double toMillimeters() {
        return this.to(Millimeters$.MODULE$);
    }

    public double toCentimeters() {
        return this.to(Centimeters$.MODULE$);
    }

    public double toDecimeters() {
        return this.to(Decimeters$.MODULE$);
    }

    public double toMeters() {
        return this.to(Meters$.MODULE$);
    }

    public double toDecameters() {
        return this.to(Decameters$.MODULE$);
    }

    public double toHectometers() {
        return this.to(Hectometers$.MODULE$);
    }

    public double toKilometers() {
        return this.to(Kilometers$.MODULE$);
    }

    public double toInches() {
        return this.to(Inches$.MODULE$);
    }

    public double toFeet() {
        return this.to(Feet$.MODULE$);
    }

    public double toYards() {
        return this.to(Yards$.MODULE$);
    }

    public double toUsMiles() {
        return this.to(UsMiles$.MODULE$);
    }

    public double toInternationalMiles() {
        return this.to(InternationalMiles$.MODULE$);
    }

    public double toNauticalMiles() {
        return this.to(NauticalMiles$.MODULE$);
    }

    public double toAstronomicalUnits() {
        return this.to(AstronomicalUnits$.MODULE$);
    }

    public double toLightYears() {
        return this.to(LightYears$.MODULE$);
    }

    public double toParsecs() {
        return this.to(Parsecs$.MODULE$);
    }

    public double toKiloParsecs() {
        return this.to(KiloParsecs$.MODULE$);
    }

    public double toMegaParsecs() {
        return this.to(MegaParsecs$.MODULE$);
    }

    public double toGigaParsecs() {
        return this.to(GigaParsecs$.MODULE$);
    }

    public double toSolarRadii() {
        return this.to(SolarRadii$.MODULE$);
    }

    public double toNominalSolarRadii() {
        return this.to(NominalSolarRadii$.MODULE$);
    }

    public double toeV() {
        return this.to(ElectronVoltLength$.MODULE$);
    }

    public double tomeV() {
        return this.to(MilliElectronVoltLength$.MODULE$);
    }

    public double tokeV() {
        return this.to(KiloElectronVoltLength$.MODULE$);
    }

    public double toMeV() {
        return this.to(MegaElectronVoltLength$.MODULE$);
    }

    public double toGeV() {
        return this.to(GigaElectronVoltLength$.MODULE$);
    }

    public double toTeV() {
        return this.to(TeraElectronVoltLength$.MODULE$);
    }

    public double toPeV() {
        return this.to(PetaElectronVoltLength$.MODULE$);
    }

    public double toEeV() {
        return this.to(ExaElectronVoltLength$.MODULE$);
    }
}

