/*
 * Decompiled with CFR 0.152.
 */
package squants.thermal;

import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.Platform$;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiBaseUnit;
import squants.UnitOfMeasure;
import squants.energy.Energy;
import squants.energy.Joules$;
import squants.thermal.Celsius$;
import squants.thermal.Fahrenheit$;
import squants.thermal.Kelvin$;
import squants.thermal.Rankine$;
import squants.thermal.Temperature$;
import squants.thermal.TemperatureConversions$;
import squants.thermal.TemperatureScale;
import squants.thermal.ThermalCapacity;

public final class Temperature
extends Quantity<Temperature> {
    private final double value;
    private final TemperatureScale unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Temperature$.class, "0bitmap$1");

    public static <A> Temperature apply(A a, TemperatureScale temperatureScale, Numeric<A> numeric) {
        return Temperature$.MODULE$.apply(a, temperatureScale, numeric);
    }

    public static Try<Temperature> apply(String string) {
        return Temperature$.MODULE$.apply(string);
    }

    public static Dimension dimensionImplicit() {
        return Temperature$.MODULE$.dimensionImplicit();
    }

    public static String dimensionSymbol() {
        return Temperature$.MODULE$.dimensionSymbol();
    }

    public static String name() {
        return Temperature$.MODULE$.name();
    }

    public static Try<Temperature> parseString(String string) {
        return Temperature$.MODULE$.parseString(string);
    }

    public static <N> Try<Temperature> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Temperature$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Temperature$.MODULE$.primaryUnit();
    }

    public static SiBaseUnit siUnit() {
        return Temperature$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Temperature>> symbolToUnit(String string) {
        return Temperature$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Temperature$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Temperature$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Temperature(double value, TemperatureScale unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public TemperatureScale unit() {
        return this.unit;
    }

    @Override
    public Dimension<Temperature> dimension() {
        return Temperature$.MODULE$;
    }

    @Override
    public Temperature plus(Temperature that) {
        return Temperature$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() + that.convert(this.unit(), false).value())), this.unit(), Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Temperature minus(Temperature that) {
        return Temperature$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() - that.convert(this.unit(), false).value())), this.unit(), Numeric.DoubleIsFractional$.MODULE$);
    }

    public Energy $times(ThermalCapacity that) {
        return Joules$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKelvinScale() * that.toJoulesPerKelvin())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public String toString() {
        TemperatureScale temperatureScale = this.unit();
        return Kelvin$.MODULE$.equals(temperatureScale) ? super.toString() : Platform$.MODULE$.crossFormat(this.value()) + this.unit().symbol();
    }

    public String toString(TemperatureScale unit) {
        return this.in(unit).toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Temperature convert(TemperatureScale toScale, boolean withOffset) {
        Temperature temperature;
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)this.unit(), (Object)toScale, (Object)BoxesRunTime.boxToBoolean((boolean)withOffset));
        if (tuple3 == null) throw new MatchError((Object)tuple3);
        TemperatureScale temperatureScale = (TemperatureScale)tuple3._1();
        TemperatureScale temperatureScale2 = (TemperatureScale)tuple3._2();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
        if (Fahrenheit$.MODULE$.equals(temperatureScale) && Fahrenheit$.MODULE$.equals(temperatureScale2)) {
            temperature = this;
            return temperature;
        }
        if (Celsius$.MODULE$.equals(temperatureScale) && Celsius$.MODULE$.equals(temperatureScale2)) {
            temperature = this;
            return temperature;
        }
        if (Kelvin$.MODULE$.equals(temperatureScale) && Kelvin$.MODULE$.equals(temperatureScale2)) {
            temperature = this;
            return temperature;
        }
        if (Rankine$.MODULE$.equals(temperatureScale) && Rankine$.MODULE$.equals(temperatureScale2)) {
            temperature = this;
            return temperature;
        }
        if (Fahrenheit$.MODULE$.equals(temperatureScale) && Celsius$.MODULE$.equals(temperatureScale2) && bl) {
            temperature = Celsius$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.fahrenheitToCelsiusScale(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Celsius$.MODULE$.equals(temperatureScale)) {
            if (Fahrenheit$.MODULE$.equals(temperatureScale2) && bl) {
                temperature = Fahrenheit$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.celsiusToFahrenheitScale(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
                return temperature;
            }
            if (Kelvin$.MODULE$.equals(temperatureScale2) && bl) {
                temperature = Kelvin$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.celsiusToKelvinScale(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
                return temperature;
            }
        }
        if (Kelvin$.MODULE$.equals(temperatureScale) && Celsius$.MODULE$.equals(temperatureScale2) && bl) {
            temperature = Celsius$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.kelvinToCelsiusScale(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Fahrenheit$.MODULE$.equals(temperatureScale) && Kelvin$.MODULE$.equals(temperatureScale2) && bl) {
            temperature = Kelvin$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.fahrenheitToKelvinScale(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Kelvin$.MODULE$.equals(temperatureScale) && Fahrenheit$.MODULE$.equals(temperatureScale2) && bl) {
            temperature = Fahrenheit$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.kelvinToFahrenheitScale(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Fahrenheit$.MODULE$.equals(temperatureScale) && Rankine$.MODULE$.equals(temperatureScale2) && bl) {
            temperature = Rankine$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.fahrenheitToRankineScale(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Rankine$.MODULE$.equals(temperatureScale) && Fahrenheit$.MODULE$.equals(temperatureScale2) && bl) {
            temperature = Fahrenheit$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.rankineToFahrenheitScale(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Celsius$.MODULE$.equals(temperatureScale) && Rankine$.MODULE$.equals(temperatureScale2) && bl) {
            temperature = Rankine$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.celsiusToRankineScale(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Rankine$.MODULE$.equals(temperatureScale) && Celsius$.MODULE$.equals(temperatureScale2) && bl) {
            temperature = Celsius$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.rankineToCelsiusScale(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Kelvin$.MODULE$.equals(temperatureScale) && Rankine$.MODULE$.equals(temperatureScale2) && bl) {
            temperature = Rankine$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.kelvinToRankineScale(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Rankine$.MODULE$.equals(temperatureScale) && Kelvin$.MODULE$.equals(temperatureScale2) && bl) {
            temperature = Kelvin$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.rankineToKelvinScale(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Fahrenheit$.MODULE$.equals(temperatureScale) && Celsius$.MODULE$.equals(temperatureScale2) && !bl) {
            temperature = Celsius$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.fahrenheitToCelsiusDegrees(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Celsius$.MODULE$.equals(temperatureScale)) {
            if (Fahrenheit$.MODULE$.equals(temperatureScale2) && !bl) {
                temperature = Fahrenheit$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.celsiusToFahrenheitDegrees(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
                return temperature;
            }
            if (Kelvin$.MODULE$.equals(temperatureScale2) && !bl) {
                temperature = Kelvin$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.celsiusToKelvinDegrees(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
                return temperature;
            }
        }
        if (Kelvin$.MODULE$.equals(temperatureScale) && Celsius$.MODULE$.equals(temperatureScale2) && !bl) {
            temperature = Celsius$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.kelvinToCelsiusDegrees(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Fahrenheit$.MODULE$.equals(temperatureScale) && Kelvin$.MODULE$.equals(temperatureScale2) && !bl) {
            temperature = Kelvin$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.fahrenheitToKelvinDegrees(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Kelvin$.MODULE$.equals(temperatureScale) && Fahrenheit$.MODULE$.equals(temperatureScale2) && !bl) {
            temperature = Fahrenheit$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.kelvinToFahrenheitDegrees(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Fahrenheit$.MODULE$.equals(temperatureScale) && Rankine$.MODULE$.equals(temperatureScale2) && !bl) {
            temperature = Rankine$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.fahrenheitToRankineDegrees(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Rankine$.MODULE$.equals(temperatureScale) && Fahrenheit$.MODULE$.equals(temperatureScale2) && !bl) {
            temperature = Fahrenheit$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.rankineToFahrenheitDegrees(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Celsius$.MODULE$.equals(temperatureScale) && Rankine$.MODULE$.equals(temperatureScale2) && !bl) {
            temperature = Rankine$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.celsiusToRankineDegrees(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Rankine$.MODULE$.equals(temperatureScale) && Celsius$.MODULE$.equals(temperatureScale2) && !bl) {
            temperature = Celsius$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.rankineToCelsiusDegrees(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (Kelvin$.MODULE$.equals(temperatureScale) && Rankine$.MODULE$.equals(temperatureScale2) && !bl) {
            temperature = Rankine$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.kelvinToRankineDegrees(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
            return temperature;
        }
        if (!Rankine$.MODULE$.equals(temperatureScale)) throw new MatchError((Object)tuple3);
        if (!Kelvin$.MODULE$.equals(temperatureScale2)) throw new MatchError((Object)tuple3);
        if (false != bl) throw new MatchError((Object)tuple3);
        temperature = Kelvin$.MODULE$.apply(BoxesRunTime.boxToDouble((double)TemperatureConversions$.MODULE$.rankineToKelvinDegrees(this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
        return temperature;
    }

    private boolean convert$default$2() {
        return true;
    }

    public Temperature in(TemperatureScale unit) {
        return this.convert(unit, true);
    }

    public Temperature inFahrenheit() {
        return this.convert(Fahrenheit$.MODULE$, this.convert$default$2());
    }

    public Temperature inCelsius() {
        return this.convert(Celsius$.MODULE$, this.convert$default$2());
    }

    public Temperature inKelvin() {
        return this.convert(Kelvin$.MODULE$, this.convert$default$2());
    }

    public double to(TemperatureScale unit) {
        return this.toScale(unit);
    }

    public double toScale(TemperatureScale unit) {
        return this.convert(unit, true).value();
    }

    public double toFahrenheitScale() {
        return this.toScale(Fahrenheit$.MODULE$);
    }

    public double toCelsiusScale() {
        return this.toScale(Celsius$.MODULE$);
    }

    public double toKelvinScale() {
        return this.toScale(Kelvin$.MODULE$);
    }

    public double toDegrees(TemperatureScale unit) {
        return this.convert(unit, false).value();
    }

    public double toFahrenheitDegrees() {
        return this.toDegrees(Fahrenheit$.MODULE$);
    }

    public double toCelsiusDegrees() {
        return this.toDegrees(Celsius$.MODULE$);
    }

    public double toKelvinDegrees() {
        return this.toDegrees(Kelvin$.MODULE$);
    }
}

