/*
 * Decompiled with CFR 0.152.
 */
package squants.time;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.Dimensionless;
import squants.Each$;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.electro.ElectricCharge;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricPotential;
import squants.electro.MagneticFlux;
import squants.energy.Energy;
import squants.energy.Power;
import squants.energy.PowerRamp;
import squants.information.DataRate;
import squants.information.Information;
import squants.mass.Mass;
import squants.motion.Acceleration;
import squants.motion.AngularVelocity;
import squants.motion.Force;
import squants.motion.Jerk;
import squants.motion.MassFlow;
import squants.motion.Momentum;
import squants.motion.Pressure;
import squants.motion.PressureChange;
import squants.motion.Velocity;
import squants.motion.VolumeFlow;
import squants.motion.Yank;
import squants.package$;
import squants.photo.Illuminance;
import squants.photo.LuminousEnergy;
import squants.photo.LuminousExposure;
import squants.photo.LuminousFlux;
import squants.space.Angle;
import squants.space.Length;
import squants.space.Volume;
import squants.time.Frequency$;
import squants.time.FrequencyUnit;
import squants.time.Gigahertz$;
import squants.time.Hertz$;
import squants.time.Kilohertz$;
import squants.time.Megahertz$;
import squants.time.RevolutionsPerMinute$;
import squants.time.Terahertz$;
import squants.time.Time;
import squants.time.TimeDerivative;

public final class Frequency
extends Quantity<Frequency>
implements TimeDerivative<Dimensionless> {
    private final double value;
    private final FrequencyUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Frequency$.class, "0bitmap$1");

    public static Try<Frequency> apply(Object object) {
        return Frequency$.MODULE$.apply(object);
    }

    public static <A> Frequency apply(A a, FrequencyUnit frequencyUnit, Numeric<A> numeric) {
        return Frequency$.MODULE$.apply(a, frequencyUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Frequency$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Frequency$.MODULE$.name();
    }

    public static Try<Frequency> parseString(String string) {
        return Frequency$.MODULE$.parseString(string);
    }

    public static <N> Try<Frequency> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Frequency$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Frequency$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Frequency$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Frequency>> symbolToUnit(String string) {
        return Frequency$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Frequency$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Frequency$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Frequency(double value, FrequencyUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public FrequencyUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Frequency> dimension() {
        return Frequency$.MODULE$;
    }

    @Override
    public Dimensionless timeIntegrated() {
        return Each$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toHertz()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return package$.MODULE$.Seconds().apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Jerk $times(Acceleration that) {
        return (Jerk)that.$times(this);
    }

    public AngularVelocity $times(Angle that) {
        return (AngularVelocity)that.$times(this);
    }

    public Frequency $times(Dimensionless that) {
        return (Frequency)this.$times(that.toEach());
    }

    public ElectricCurrent $times(ElectricCharge that) {
        return (ElectricCurrent)that.$times(this);
    }

    public Power $times(Energy that) {
        return (Power)that.$times(this);
    }

    public Yank $times(Force that) {
        return (Yank)that.$times(this);
    }

    public DataRate $times(Information that) {
        return (DataRate)that.$times(this);
    }

    public Velocity $times(Length that) {
        return (Velocity)that.$times(this);
    }

    public LuminousFlux $times(LuminousEnergy that) {
        return (LuminousFlux)that.$times(this);
    }

    public Illuminance $times(LuminousExposure that) {
        return (Illuminance)that.$times(this);
    }

    public ElectricPotential $times(MagneticFlux that) {
        return (ElectricPotential)that.$times(this);
    }

    public MassFlow $times(Mass that) {
        return (MassFlow)that.$times(this);
    }

    public Force $times(Momentum that) {
        return (Force)that.$times(this);
    }

    public PowerRamp $times(Power that) {
        return (PowerRamp)that.$times(this);
    }

    public PressureChange $times(Pressure that) {
        return (PressureChange)that.$times(this);
    }

    public Acceleration $times(Velocity that) {
        return (Acceleration)that.$times(this);
    }

    public VolumeFlow $times(Volume that) {
        return (VolumeFlow)that.$times(this);
    }

    public double toHertz() {
        return this.to(Hertz$.MODULE$);
    }

    public double toKilohertz() {
        return this.to(Kilohertz$.MODULE$);
    }

    public double toMegahertz() {
        return this.to(Megahertz$.MODULE$);
    }

    public double toGigahertz() {
        return this.to(Gigahertz$.MODULE$);
    }

    public double toTerahertz() {
        return this.to(Terahertz$.MODULE$);
    }

    public double toRevolutionsPerMinute() {
        return this.to(RevolutionsPerMinute$.MODULE$);
    }
}

