/*
 * Decompiled with CFR 0.152.
 */
package squants.time;

import scala.concurrent.duration.Duration;
import scala.math.Numeric;
import scala.util.Try;
import squants.time.Days$;
import squants.time.Hours$;
import squants.time.Microseconds$;
import squants.time.Milliseconds$;
import squants.time.Minutes$;
import squants.time.Nanoseconds$;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.Time$;
import squants.time.TimeConversions$;

public final class TimeConversions {
    public static <A> TimeConversions<A> TimeConversions(A a, Numeric<A> numeric) {
        return TimeConversions$.MODULE$.TimeConversions(a, numeric);
    }

    public static TimeStringConversions TimeStringConversions(String string) {
        return TimeConversions$.MODULE$.TimeStringConversions(string);
    }

    public static Time day() {
        return TimeConversions$.MODULE$.day();
    }

    public static Time halfHour() {
        return TimeConversions$.MODULE$.halfHour();
    }

    public static Time hour() {
        return TimeConversions$.MODULE$.hour();
    }

    public static Time microsecond() {
        return TimeConversions$.MODULE$.microsecond();
    }

    public static Time millisecond() {
        return TimeConversions$.MODULE$.millisecond();
    }

    public static Time minute() {
        return TimeConversions$.MODULE$.minute();
    }

    public static Time nanosecond() {
        return TimeConversions$.MODULE$.nanosecond();
    }

    public static Time scalaDurationToTime(Duration duration) {
        return TimeConversions$.MODULE$.scalaDurationToTime(duration);
    }

    public static Time second() {
        return TimeConversions$.MODULE$.second();
    }

    public static Duration timeToScalaDuration(Time time) {
        return TimeConversions$.MODULE$.timeToScalaDuration(time);
    }

    public static class TimeConversions<A> {
        private final A n;
        private final Numeric<A> num;

        public <A> TimeConversions(A n, Numeric<A> num) {
            this.n = n;
            this.num = num;
        }

        public Time nanoseconds() {
            return Nanoseconds$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Time microseconds() {
            return Microseconds$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Time milliseconds() {
            return Milliseconds$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Time seconds() {
            return Seconds$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Time minutes() {
            return Minutes$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Time hours() {
            return Hours$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Time days() {
            return Days$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }
    }

    public static class TimeStringConversions {
        private final String s;

        public TimeStringConversions(String s) {
            this.s = s;
        }

        public Try<Time> toTime() {
            return Time$.MODULE$.apply(this.s);
        }
    }
}

