/*
 * Decompiled with CFR 0.152.
 */
package com.raquo.airstream.core;

import com.raquo.airstream.core.Observable;
import com.raquo.airstream.core.Signal;
import com.raquo.airstream.core.Source;
import com.raquo.airstream.debug.Debugger;
import com.raquo.airstream.debug.DebuggerEventStream;
import com.raquo.airstream.misc.FilterEventStream;
import com.raquo.airstream.misc.FoldLeftSignal;
import com.raquo.airstream.misc.MapEventStream;
import com.raquo.airstream.split.SignalFromEventStream;
import com.raquo.airstream.timing.DebounceEventStream;
import com.raquo.airstream.timing.DelayEventStream;
import com.raquo.airstream.timing.SyncDelayEventStream;
import com.raquo.airstream.timing.ThrottleEventStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;

public interface EventStream<A>
extends Observable<A>,
Source.EventSource<A> {
    public static EventStream map$(EventStream $this, Function1 project) {
        return $this.map(project);
    }

    @Override
    default public <B> EventStream<B> map(Function1<A, B> project) {
        return new MapEventStream<A, B>(this, project, None$.MODULE$);
    }

    public static EventStream filter$(EventStream $this, Function1 passes) {
        return $this.filter(passes);
    }

    default public EventStream<A> filter(Function1<A, Object> passes) {
        return new FilterEventStream<A>(this, passes);
    }

    public static EventStream filterNot$(EventStream $this, Function1 predicate) {
        return $this.filterNot(predicate);
    }

    default public EventStream<A> filterNot(Function1<A, Object> predicate) {
        return this.filter((Function1 & Serializable)_$1 -> !BoxesRunTime.unboxToBoolean((Object)predicate.apply(_$1)));
    }

    public static EventStream collect$(EventStream $this, PartialFunction pf) {
        return $this.collect(pf);
    }

    default public <B> EventStream<B> collect(PartialFunction<A, B> pf) {
        return this.filter((Function1 & Serializable)x -> pf.isDefinedAt(x)).map((Function1<A, B>)pf);
    }

    public static EventStream delay$(EventStream $this, int ms) {
        return $this.delay(ms);
    }

    default public EventStream<A> delay(int ms) {
        return new DelayEventStream(this, ms);
    }

    public static int delay$default$1$(EventStream $this) {
        return $this.delay$default$1();
    }

    default public int delay$default$1() {
        return 0;
    }

    public static EventStream delaySync$(EventStream $this, EventStream after) {
        return $this.delaySync(after);
    }

    default public EventStream<A> delaySync(EventStream<?> after) {
        return new SyncDelayEventStream(this, after);
    }

    public static EventStream throttle$(EventStream $this, int ms, boolean leading) {
        return $this.throttle(ms, leading);
    }

    default public EventStream<A> throttle(int ms, boolean leading) {
        return new ThrottleEventStream(this, ms, leading);
    }

    public static boolean throttle$default$2$(EventStream $this) {
        return $this.throttle$default$2();
    }

    default public boolean throttle$default$2() {
        return true;
    }

    public static EventStream debounce$(EventStream $this, int ms) {
        return $this.debounce(ms);
    }

    default public EventStream<A> debounce(int ms) {
        return new DebounceEventStream(this, ms);
    }

    public static Signal foldLeft$(EventStream $this, Object initial, Function2 fn) {
        return $this.foldLeft(initial, fn);
    }

    default public <B> Signal<B> foldLeft(B initial, Function2<B, A, B> fn) {
        return this.foldLeftRecover((Try<B>)Success$.MODULE$.apply(initial), (Function2<Try<B>, Try<A>, Try<B>>)(Function2 & Serializable)(currentValue, nextParentValue) -> Try$.MODULE$.apply(() -> EventStream.foldLeft$$anonfun$2$$anonfun$1(fn, currentValue, nextParentValue)));
    }

    public static Signal foldLeftRecover$(EventStream $this, Try initial, Function2 fn) {
        return $this.foldLeftRecover(initial, fn);
    }

    default public <B> Signal<B> foldLeftRecover(Try<B> initial, Function2<Try<B>, Try<A>, Try<B>> fn) {
        return new FoldLeftSignal<A, B>(this, (Function0 & Serializable)() -> initial, fn);
    }

    public static Signal startWith$(EventStream $this, Function0 initial) {
        return $this.startWith(initial);
    }

    default public <B> Signal<B> startWith(Function0<B> initial) {
        return this.toSignal(initial);
    }

    public static Signal startWithTry$(EventStream $this, Function0 initial) {
        return $this.startWithTry(initial);
    }

    default public <B> Signal<B> startWithTry(Function0<Try<B>> initial) {
        return this.toSignalWithTry(initial);
    }

    public static Signal startWithNone$(EventStream $this) {
        return $this.startWithNone();
    }

    default public Signal<Option<A>> startWithNone() {
        return this.toWeakSignal();
    }

    public static Signal toSignal$(EventStream $this, Function0 initial) {
        return $this.toSignal(initial);
    }

    default public <B> Signal<B> toSignal(Function0<B> initial) {
        return this.toSignalWithTry(() -> EventStream.toSignal$$anonfun$1(initial));
    }

    public static Signal toSignalWithTry$(EventStream $this, Function0 initial) {
        return $this.toSignalWithTry(initial);
    }

    default public <B> Signal<B> toSignalWithTry(Function0<Try<B>> initial) {
        return new SignalFromEventStream<B>(this, initial);
    }

    public static EventStream compose$(EventStream $this, Function1 operator) {
        return $this.compose(operator);
    }

    default public <B> EventStream<B> compose(Function1<EventStream<A>, EventStream<B>> operator) {
        return (EventStream)operator.apply((Object)this);
    }

    public static EventStream recover$(EventStream $this, PartialFunction pf) {
        return $this.recover(pf);
    }

    @Override
    default public <B> EventStream<B> recover(PartialFunction<Throwable, Option<B>> pf) {
        return new MapEventStream(this, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x), Some$.MODULE$.apply(pf));
    }

    public static EventStream recoverToTry$(EventStream $this) {
        return $this.recoverToTry();
    }

    @Override
    default public EventStream<Try<A>> recoverToTry() {
        return this.map((Function1 & Serializable)_$2 -> Try$.MODULE$.apply(() -> EventStream.recoverToTry$$anonfun$2$$anonfun$1(_$2))).recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable err = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable err = throwable = x;
                return Some$.MODULE$.apply((Object)Failure$.MODULE$.apply(err));
            }
        });
    }

    public static EventStream debugWith$(EventStream $this, Debugger debugger) {
        return $this.debugWith(debugger);
    }

    @Override
    default public EventStream<A> debugWith(Debugger<A> debugger) {
        return new DebuggerEventStream<A>(this, debugger);
    }

    public static EventStream toObservable$(EventStream $this) {
        return $this.toObservable();
    }

    @Override
    default public EventStream<A> toObservable() {
        return this;
    }

    private static Object foldLeft$$anonfun$2$$anonfun$1(Function2 fn$2, Try currentValue$1, Try nextParentValue$1) {
        return fn$2.apply(currentValue$1.get(), nextParentValue$1.get());
    }

    private static Success toSignal$$anonfun$1(Function0 initial$2) {
        return Success$.MODULE$.apply(initial$2.apply());
    }

    private static Object recoverToTry$$anonfun$2$$anonfun$1(Object _$2$1) {
        return _$2$1;
    }
}

