/*
 * Decompiled with CFR 0.152.
 */
package com.raquo.airstream.debug;

import com.raquo.airstream.core.BaseObservable;
import com.raquo.airstream.core.Observable;
import com.raquo.airstream.core.Protected$;
import com.raquo.airstream.debug.Debugger;
import com.raquo.airstream.debug.Debugger$;
import com.raquo.airstream.util.package$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class DebuggableObservable<Self extends Observable<?>, A> {
    private final BaseObservable observable;

    public DebuggableObservable(BaseObservable<Self, A> observable) {
        this.observable = observable;
    }

    public BaseObservable<Self, A> observable() {
        return this.observable;
    }

    public int debugTopoRank() {
        return Protected$.MODULE$.topoRank(this.observable());
    }

    public Self debugWithName(String displayName) {
        Debugger emptyDebugger = Debugger$.MODULE$.apply(Debugger$.MODULE$.$lessinit$greater$default$1(), Debugger$.MODULE$.$lessinit$greater$default$2(), Debugger$.MODULE$.$lessinit$greater$default$3(), Debugger$.MODULE$.$lessinit$greater$default$4());
        return (Self)((Observable)this.observable().debugWith(emptyDebugger).setDisplayName(displayName));
    }

    public Self debugSpy(Function1<Try<A>, BoxedUnit> fn) {
        Debugger<A> debugger = Debugger$.MODULE$.apply(Debugger$.MODULE$.$lessinit$greater$default$1(), Debugger$.MODULE$.$lessinit$greater$default$2(), fn, Debugger$.MODULE$.$lessinit$greater$default$4());
        return this.observable().debugWith(debugger);
    }

    public Self debugSpyEvents(Function1<A, BoxedUnit> fn) {
        return this.debugSpy((Function1 & Serializable)x$1 -> {
            DebuggableObservable.debugSpyEvents$$anonfun$1(fn, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Self debugSpyErrors(Function1<Throwable, BoxedUnit> fn) {
        return this.debugSpy((Function1 & Serializable)x$1 -> {
            DebuggableObservable.debugSpyErrors$$anonfun$1(fn, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Self debugSpyLifecycle(Function1<Object, BoxedUnit> startFn, Function0<BoxedUnit> stopFn) {
        Debugger debugger = Debugger$.MODULE$.apply((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$anonfun$3(startFn);
            return BoxedUnit.UNIT;
        }, stopFn, Debugger$.MODULE$.$lessinit$greater$default$3(), Debugger$.MODULE$.$lessinit$greater$default$4());
        return this.observable().debugWith(debugger);
    }

    public Self debugSpyStarts(Function1<Object, BoxedUnit> fn) {
        return this.debugSpyLifecycle(fn, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            DebuggableObservable.debugSpyStarts$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public Self debugSpyStops(Function0<BoxedUnit> fn) {
        return this.debugSpyLifecycle((Function1<Object, BoxedUnit>)(Function1 & Serializable)v1 -> {
            DebuggableObservable.debugSpyStops$$anonfun$1(BoxesRunTime.unboxToInt((Object)v1));
            return BoxedUnit.UNIT;
        }, fn);
    }

    public Self debugLog(Function1<Try<A>, Object> when, boolean useJsLogger) {
        return this.debugSpy((Function1 & Serializable)value -> {
            this.debugLog$$anonfun$1((Function1)when, useJsLogger, (Try)value);
            return BoxedUnit.UNIT;
        });
    }

    public Function1<Try<A>, Object> debugLog$default$1() {
        return package$.MODULE$.always();
    }

    public boolean debugLog$default$2() {
        return false;
    }

    public Self debugLogEvents(Function1<A, Object> when, boolean useJsLogger) {
        Function1 & Serializable whenEvent = (Function1 & Serializable)value -> {
            Object ev;
            Try try_ = value;
            return try_ instanceof Success && BoxesRunTime.unboxToBoolean((Object)when.apply(ev = ((Success)try_).value()));
        };
        return this.debugLog(whenEvent, useJsLogger);
    }

    public Function1<A, Object> debugLogEvents$default$1() {
        return package$.MODULE$.always();
    }

    public boolean debugLogEvents$default$2() {
        return false;
    }

    public Self debugLogErrors(Function1<Throwable, Object> when) {
        Function1 & Serializable whenEvent = (Function1 & Serializable)value -> {
            Throwable err;
            Try try_ = value;
            return try_ instanceof Failure && BoxesRunTime.unboxToBoolean((Object)when.apply((Object)(err = ((Failure)try_).exception())));
        };
        return this.debugLog(whenEvent, false);
    }

    public Function1<Throwable, Object> debugLogErrors$default$1() {
        return package$.MODULE$.always();
    }

    public Self debugLogLifecycle(boolean logStarts, boolean logStops) {
        return this.debugSpyLifecycle((Function1<Object, BoxedUnit>)(Function1 & Serializable)v1 -> {
            this.debugLogLifecycle$$anonfun$1(logStarts, BoxesRunTime.unboxToInt((Object)v1));
            return BoxedUnit.UNIT;
        }, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.debugLogLifecycle$$anonfun$2(logStops);
            return BoxedUnit.UNIT;
        });
    }

    public boolean debugLogLifecycle$default$1() {
        return true;
    }

    public boolean debugLogLifecycle$default$2() {
        return true;
    }

    public Self debugLogStarts() {
        return this.debugLogLifecycle(this.debugLogLifecycle$default$1(), false);
    }

    public Self debugLogStops() {
        return this.debugLogLifecycle(false, this.debugLogLifecycle$default$2());
    }

    public void log(String action, Option<Object> value, boolean useJsLogger) {
        String maybeColon = value.isDefined() ? ":" : "";
        String prefix = "" + this.observable().displayName() + " [" + action + "]" + maybeColon;
        if (useJsLogger) {
            org.scalajs.dom.package$.MODULE$.console().log(prefix, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(Any)value}));
        } else {
            Predef$.MODULE$.println((Object)("" + prefix + " " + value));
        }
    }

    public Self debugBreak(Function1<Try<A>, Object> when) {
        return this.debugSpy((Function1 & Serializable)value -> {
            DebuggableObservable.debugBreak$$anonfun$1(when, value);
            return BoxedUnit.UNIT;
        });
    }

    public Function1<Try<A>, Object> debugBreak$default$1() {
        return package$.MODULE$.always();
    }

    public Self debugBreakEvents(Function1<A, Object> when) {
        return this.debugSpyEvents((Function1 & Serializable)ev -> {
            DebuggableObservable.debugBreakEvents$$anonfun$1(when, ev);
            return BoxedUnit.UNIT;
        });
    }

    public Function1<A, Object> debugBreakEvents$default$1() {
        return package$.MODULE$.always();
    }

    public Self debugBreakErrors(Function1<Throwable, Object> when) {
        return this.debugSpyErrors((Function1<Throwable, BoxedUnit>)(Function1 & Serializable)err -> {
            DebuggableObservable.debugBreakErrors$$anonfun$1(when, err);
            return BoxedUnit.UNIT;
        });
    }

    public Function1<Throwable, Object> debugBreakErrors$default$1() {
        return package$.MODULE$.always();
    }

    public Self debugBreakLifecycle() {
        return this.debugSpyLifecycle((Function1<Object, BoxedUnit>)(Function1 & Serializable)v1 -> {
            scala.scalajs.js.special.package$.MODULE$.debugger();
            return BoxedUnit.UNIT;
        }, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            scala.scalajs.js.special.package$.MODULE$.debugger();
            return BoxedUnit.UNIT;
        });
    }

    public Self debugBreakStarts() {
        return this.debugSpyLifecycle((Function1<Object, BoxedUnit>)(Function1 & Serializable)v1 -> {
            scala.scalajs.js.special.package$.MODULE$.debugger();
            return BoxedUnit.UNIT;
        }, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            DebuggableObservable.debugBreakStarts$$anonfun$2();
            return BoxedUnit.UNIT;
        });
    }

    public Self debugBreakStops() {
        return this.debugSpyLifecycle((Function1<Object, BoxedUnit>)(Function1 & Serializable)v1 -> {
            DebuggableObservable.debugBreakStops$$anonfun$1(BoxesRunTime.unboxToInt((Object)v1));
            return BoxedUnit.UNIT;
        }, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            scala.scalajs.js.special.package$.MODULE$.debugger();
            return BoxedUnit.UNIT;
        });
    }

    private static final /* synthetic */ void debugSpyEvents$$anonfun$1(Function1 fn$1, Try x$1) {
        block0: {
            Try try_ = x$1;
            if (!(try_ instanceof Success)) break block0;
            Object ev = ((Success)try_).value();
            fn$1.apply(ev);
        }
    }

    private static final /* synthetic */ void debugSpyErrors$$anonfun$1(Function1 fn$2, Try x$1) {
        block0: {
            Try try_ = x$1;
            if (!(try_ instanceof Failure)) break block0;
            Throwable err = ((Failure)try_).exception();
            fn$2.apply((Object)err);
        }
    }

    private final /* synthetic */ void $anonfun$3(Function1 startFn$1) {
        startFn$1.apply((Object)BoxesRunTime.boxToInteger((int)Protected$.MODULE$.topoRank(this.observable())));
    }

    private static final /* synthetic */ void debugSpyStarts$$anonfun$1() {
    }

    private static final /* synthetic */ void debugSpyStops$$anonfun$1(int _$2) {
    }

    private final /* synthetic */ void debugLog$$anonfun$1(Function1 when$1, boolean useJsLogger$1, Try value) {
        if (BoxesRunTime.unboxToBoolean((Object)when$1.apply((Object)value))) {
            Try try_ = value;
            if (try_ instanceof Success) {
                Object ev = ((Success)try_).value();
                this.log("event", (Option<Object>)Some$.MODULE$.apply(ev), useJsLogger$1);
            } else if (try_ instanceof Failure) {
                Throwable err = ((Failure)try_).exception();
                this.log("error", (Option<Object>)Some$.MODULE$.apply((Object)err), useJsLogger$1);
            } else {
                throw new MatchError((Object)try_);
            }
        }
    }

    private final /* synthetic */ void debugLogLifecycle$$anonfun$1(boolean logStarts$1, int topoRank) {
        if (logStarts$1) {
            this.log("started", (Option<Object>)Some$.MODULE$.apply((Object)("topoRank = " + topoRank)), false);
        }
    }

    private final /* synthetic */ void debugLogLifecycle$$anonfun$2(boolean logStops$1) {
        if (logStops$1) {
            this.log("stopped", (Option<Object>)None$.MODULE$, false);
        }
    }

    private static final /* synthetic */ void debugBreak$$anonfun$1(Function1 when$4, Try value) {
        if (BoxesRunTime.unboxToBoolean((Object)when$4.apply((Object)value))) {
            scala.scalajs.js.special.package$.MODULE$.debugger();
        }
    }

    private static final /* synthetic */ void debugBreakEvents$$anonfun$1(Function1 when$5, Object ev) {
        if (BoxesRunTime.unboxToBoolean((Object)when$5.apply(ev))) {
            scala.scalajs.js.special.package$.MODULE$.debugger();
        }
    }

    private static final /* synthetic */ void debugBreakErrors$$anonfun$1(Function1 when$6, Throwable err) {
        if (BoxesRunTime.unboxToBoolean((Object)when$6.apply((Object)err))) {
            scala.scalajs.js.special.package$.MODULE$.debugger();
        }
    }

    private static final /* synthetic */ void debugBreakStarts$$anonfun$2() {
    }

    private static final /* synthetic */ void debugBreakStops$$anonfun$1(int _$5) {
    }
}

