/*
 * Decompiled with CFR 0.152.
 */
package com.raquo.airstream.ownership;

import com.raquo.airstream.JsArray;
import com.raquo.airstream.JsArray$;
import com.raquo.airstream.ownership.DynamicSubscription;
import com.raquo.airstream.ownership.OneTimeOwner;
import com.raquo.airstream.ownership.Owner;
import java.io.Serializable;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Array;
import scala.scalajs.js.Array$;
import scala.scalajs.js.Function1;

public class DynamicOwner {
    private final Function0<BoxedUnit> onAccessAfterKilled;
    private final JsArray<DynamicSubscription> subscriptions;
    private boolean isSafeToRemoveSubscription;
    private final Array<DynamicSubscription> pendingSubscriptionRemovals;
    private Option<Owner> _maybeCurrentOwner;
    private int numPrependedSubs;

    public DynamicOwner(Function0<BoxedUnit> onAccessAfterKilled) {
        this.onAccessAfterKilled = onAccessAfterKilled;
        this.subscriptions = JsArray$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamicSubscription[0]));
        this.isSafeToRemoveSubscription = true;
        this.pendingSubscriptionRemovals = Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamicSubscription[0]));
        this._maybeCurrentOwner = None$.MODULE$;
        this.numPrependedSubs = 0;
    }

    public Option<Owner> maybeCurrentOwner() {
        return this._maybeCurrentOwner;
    }

    public boolean isActive() {
        return this._maybeCurrentOwner.isDefined();
    }

    public boolean hasSubscriptions() {
        return this.numSubscriptions() != 0;
    }

    public int numSubscriptions() {
        return this.subscriptions.length();
    }

    public void activate() {
        if (!this.isActive()) {
            OneTimeOwner newOwner = new OneTimeOwner(this.onAccessAfterKilled);
            this._maybeCurrentOwner = Some$.MODULE$.apply((Object)newOwner);
            this.isSafeToRemoveSubscription = false;
            this.numPrependedSubs = 0;
            int originalNumSubs = this.subscriptions.length();
            for (int i = 0; i < originalNumSubs; ++i) {
                int ix = i + this.numPrependedSubs;
                DynamicSubscription sub = this.subscriptions.apply(ix);
                sub.onActivate(newOwner);
            }
        } else {
            throw new Exception("Can not activate " + this + ": it is already active");
        }
        this.removePendingSubscriptionsNow();
        this.isSafeToRemoveSubscription = true;
        this.numPrependedSubs = 0;
    }

    public void deactivate() {
        if (!this.isActive()) {
            throw new Exception("Can not deactivate DynamicOwner: it is not active");
        }
        this.isSafeToRemoveSubscription = false;
        this.subscriptions.forEach((Function1<DynamicSubscription, Object>)((Function1)_$1 -> {
            _$1.onDeactivate();
            return BoxedUnit.UNIT;
        }));
        this.removePendingSubscriptionsNow();
        this._maybeCurrentOwner.foreach((scala.Function1 & Serializable)_$2 -> {
            _$2._killSubscriptions();
            return BoxedUnit.UNIT;
        });
        this.removePendingSubscriptionsNow();
        this.isSafeToRemoveSubscription = true;
        this._maybeCurrentOwner = None$.MODULE$;
    }

    public void addSubscription(DynamicSubscription subscription, boolean prepend) {
        int n;
        if (prepend) {
            ++this.numPrependedSubs;
            n = this.subscriptions.unshift((Seq<DynamicSubscription>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamicSubscription[]{subscription}));
        } else {
            n = this.subscriptions.push((Seq<DynamicSubscription>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamicSubscription[]{subscription}));
        }
        this._maybeCurrentOwner.foreach((scala.Function1 & Serializable)o -> {
            subscription.onActivate(o);
            return BoxedUnit.UNIT;
        });
    }

    public void removeSubscription(DynamicSubscription subscription) {
        if (this.isSafeToRemoveSubscription) {
            this.removeSubscriptionNow(subscription);
        } else {
            this.pendingSubscriptionRemovals.push((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamicSubscription[]{subscription}));
        }
    }

    private void removeSubscriptionNow(DynamicSubscription subscription) {
        int index = this.subscriptions.indexOf(subscription);
        if (index != -1) {
            this.subscriptions.splice(index, 1, (Seq<DynamicSubscription>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamicSubscription[0]));
            if (this.isActive()) {
                subscription.onDeactivate();
            }
        } else {
            throw new Exception("Can not remove DynamicSubscription from DynamicOwner: subscription not found. Did you already kill it?");
        }
    }

    private void removePendingSubscriptionsNow() {
        while (this.pendingSubscriptionRemovals.length() > 0) {
            DynamicSubscription subscriptionToRemove = (DynamicSubscription)this.pendingSubscriptionRemovals.shift();
            this.removeSubscriptionNow(subscriptionToRemove);
        }
    }
}

