/*
 * Decompiled with CFR 0.152.
 */
package com.raquo.airstream.ownership;

import com.raquo.airstream.ownership.Owner;
import scala.Function0;
import scala.runtime.BoxedUnit;

public class Subscription {
    private final Owner owner;
    private final Function0<BoxedUnit> cleanup;
    private boolean isKilled;

    public Subscription(Owner owner, Function0<BoxedUnit> cleanup) {
        this.owner = owner;
        this.cleanup = cleanup;
        this.isKilled = false;
        owner.own(this);
    }

    public Owner owner() {
        return this.owner;
    }

    public void kill() {
        this.safeCleanup();
        this.owner().onKilledExternally(this);
    }

    public void onKilledByOwner() {
        this.safeCleanup();
    }

    private void safeCleanup() {
        if (this.isKilled) {
            throw new Exception("Can not kill Subscription: it was already killed.");
        }
        this.cleanup.apply();
        this.isKilled = true;
    }
}

