/*
 * Decompiled with CFR 0.152.
 */
package com.raquo.airstream.util;

import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Array;
import scala.scalajs.js.Array$;
import scala.scalajs.js.ArrayOps$;

public class JsPriorityQueue<A> {
    private final Function1<A, Object> getRank;
    private final Array<A> queue;

    public JsPriorityQueue(Function1<A, Object> getRank) {
        this.getRank = getRank;
        this.queue = Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public void enqueue(A item) {
        int itemRank = BoxesRunTime.unboxToInt((Object)this.getRank.apply(item));
        int insertAtIndex = 0;
        boolean foundHigherRank = false;
        while (insertAtIndex < this.queue.length() && !foundHigherRank) {
            if (BoxesRunTime.unboxToInt((Object)this.getRank.apply(this.queue.apply(insertAtIndex))) > itemRank) {
                foundHigherRank = true;
                continue;
            }
            ++insertAtIndex;
        }
        this.queue.splice(insertAtIndex, 0, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{item}));
    }

    public A dequeue() {
        if (!this.nonEmpty()) {
            throw new Exception("Unable to dequeue an empty JsPriorityQueue");
        }
        return (A)this.queue.shift();
    }

    public boolean contains(A item) {
        Array array = Any$.MODULE$.jsArrayOps(this.queue);
        return ArrayOps$.MODULE$.indexOf$extension(array, item, ArrayOps$.MODULE$.indexOf$default$2$extension(array)) != -1;
    }

    public int size() {
        return this.queue.length();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public List<A> debugQueue() {
        return Any$.MODULE$.wrapArray(this.queue).toList();
    }
}

