/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.statistics;

import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class MovingAverage {
    private final int period;
    private final Queue<Object> queue;

    public MovingAverage(int period, Queue<Object> queue) {
        this.period = period;
        this.queue = queue;
    }

    public MovingAverage(int period, Seq<Object> values) {
        this(period, (Queue<Object>)((Queue)Queue$.MODULE$.apply((Seq)values.slice(values.size() - period, values.size()))));
    }

    public void put(double n) {
        MovingAverage movingAverage = this;
        synchronized (movingAverage) {
            BoxedUnit boxedUnit;
            this.queue.enqueue((Object)BoxesRunTime.boxToDouble((double)n));
            if (this.queue.size() > this.period) {
                this.queue.dequeue();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public Option<Object> get() {
        None$ none$;
        MovingAverage movingAverage = this;
        synchronized (movingAverage) {
            none$ = this.queue.isEmpty() ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.queue.sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)this.queue.size())));
        }
        return none$;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public String toString() {
        return this.get().toString();
    }

    public Queue<Object> reset(Seq<Object> values) {
        Queue queue;
        MovingAverage movingAverage = this;
        synchronized (movingAverage) {
            this.queue.clear();
            queue = (Queue)this.queue.$plus$plus$eq((IterableOnce)values.slice(values.size() - this.period, values.size()));
        }
        return queue;
    }
}

