/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.collection;

import java.util.ArrayDeque;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Vector;

public class RingBuffer<T> {
    private final int size;
    private final ArrayDeque<T> queue;

    public RingBuffer(int size) {
        this.size = size;
        this.queue = new ArrayDeque(size);
    }

    public void put(T t) {
        ArrayDeque<T> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            if (this.queue.size() == this.size) {
                this.queue.removeLast();
            }
            this.queue.addFirst(t);
        }
    }

    public Vector<T> elements() {
        Vector vector;
        ArrayDeque<T> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            vector = ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.queue).asScala()).toVector();
        }
        return vector;
    }

    /*
     * WARNING - void declaration
     */
    public Vector<T> clear() {
        void var2_3;
        RingBuffer ringBuffer = this;
        synchronized (ringBuffer) {
            void var3_2;
            Vector<T> v = this.elements();
            this.queue.clear();
            var2_3 = var3_2;
        }
        return var2_3;
    }
}

