/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.console;

import cats.kernel.Order;
import java.io.File;
import java.io.Serializable;
import java.util.logging.Level;
import org.openmole.console.Command$;
import org.openmole.console.Console;
import org.openmole.console.Console$;
import org.openmole.core.compiler.REPL;
import org.openmole.core.compiler.package;
import org.openmole.core.dsl.package$;
import org.openmole.core.fileservice.FileService;
import org.openmole.core.module.Module;
import org.openmole.core.pluginmanager.PluginManager$;
import org.openmole.core.preference.Preference;
import org.openmole.core.project.ConsoleVariables;
import org.openmole.core.services.Services;
import org.openmole.core.tools.io.Prettifier$;
import org.openmole.core.workflow.composition.DSL;
import org.openmole.core.workflow.execution.Environment;
import org.openmole.core.workflow.execution.Environment$;
import org.openmole.core.workflow.execution.ExceptionEvent;
import org.openmole.core.workflow.mole.Mole;
import org.openmole.core.workflow.mole.MoleCapsule;
import org.openmole.core.workflow.mole.MoleExecution;
import org.openmole.core.workflow.tools.OptionalArgument;
import org.openmole.core.workflow.validation.Validation$;
import org.openmole.core.workspace.TmpDirectory;
import org.openmole.core.workspace.Workspace;
import org.openmole.tool.cache.Lazy;
import org.openmole.tool.crypto.Cypher;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Random;

public class Command {
    private final REPL console;
    private final ConsoleVariables variables;

    public static Seq<String> load$default$3() {
        return Command$.MODULE$.load$default$3();
    }

    public Command(REPL console, ConsoleVariables variables) {
        this.console = console;
        this.variables = variables;
    }

    public REPL console() {
        return this.console;
    }

    public ConsoleVariables variables() {
        return this.variables;
    }

    public void print(Mole mole) {
        Predef$.MODULE$.println((Object)("root: " + mole.root()));
        mole.transitions().foreach((Function1)(JProcedure1 & Serializable)x -> Predef$.MODULE$.println(x));
        mole.dataChannels().foreach((Function1)(JProcedure1 & Serializable)x -> Predef$.MODULE$.println(x));
    }

    public void print(MoleExecution moleExecution, boolean debug) {
        Predef$.MODULE$.println((Object)"\n--- Execution ---\n");
        Map statuses = moleExecution.capsuleStatuses((MoleExecution.SynchronisationContext)MoleExecution.SynchronisationContext$.MODULE$.default());
        scala.collection.immutable.Iterable msg = (scala.collection.immutable.Iterable)statuses.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                MoleCapsule capsule = (MoleCapsule)tuple2._1();
                MoleExecution.JobStatuses stat = (MoleExecution.JobStatuses)tuple2._2();
                return true;
            }
            return false;
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                MoleCapsule capsule = (MoleCapsule)tuple2._1();
                MoleExecution.JobStatuses stat = (MoleExecution.JobStatuses)tuple2._2();
                return capsule + ": " + stat.ready() + " ready, " + stat.running() + " running, " + stat.completed() + " completed";
            }
            throw new MatchError((Object)tuple2);
        });
        Predef$.MODULE$.println((Object)msg.mkString("\n"));
        Predef$.MODULE$.println((Object)"\n--- Errors ---\n");
        Option option = moleExecution.exception((MoleExecution.SynchronisationContext)MoleExecution.SynchronisationContext$.MODULE$.default());
        if (option instanceof Some) {
            MoleExecution.MoleExecutionFailed e = (MoleExecution.MoleExecutionFailed)((Some)option).value();
            Option option2 = MoleExecution.MoleExecutionFailed$.MODULE$.capsule(e);
            if (option2 instanceof Some) {
                MoleCapsule c = (MoleCapsule)((Some)option2).value();
                System.out.println("Mole execution failed while executing " + c + ":");
            } else if (None$.MODULE$.equals(option2)) {
                System.out.println("Mole execution failed:");
            } else {
                throw new MatchError((Object)option2);
            }
            System.out.println(this.exceptionToString(e.exception()));
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError((Object)option);
        }
        Predef$.MODULE$.println((Object)"\n--- Environments ---\n");
        moleExecution.allEnvironments().foreach((Function1)(JProcedure1 & Serializable)env -> {
            this.printEnvironment$1((Environment)env, debug);
            Predef$.MODULE$.println();
        });
    }

    public boolean print$default$2() {
        return false;
    }

    public Console.CompiledDSL load(File file, Seq<String> args, Services services) {
        return Command$.MODULE$.load(this.variables(), file, args, services);
    }

    public Seq<String> load$default$2() {
        return (Seq)scala.package$.MODULE$.Seq().empty();
    }

    public MoleExecution start(DSL dsl, Services services) {
        return Command$.MODULE$.start(dsl, package.CompilationContext$.MODULE$.apply(this.console()), services);
    }

    public MoleExecution start(Console.CompiledDSL dsl, Services services) {
        return Command$.MODULE$.start(dsl.dsl(), dsl.compilationContext(), services);
    }

    private String exceptionToString(Throwable e) {
        return Prettifier$.MODULE$.ExceptionPretiffier(e).stackString();
    }

    public Level stringToLevel(String s) {
        return Level.parse(s.toUpperCase());
    }

    public void verify(Mole mole, TmpDirectory newFile, FileService fileService) {
        Validation$.MODULE$.apply(mole, Validation$.MODULE$.apply$default$2(), Validation$.MODULE$.apply$default$3(), Validation$.MODULE$.apply$default$4(), newFile, fileService).foreach((Function1)(JProcedure1 & Serializable)x -> Predef$.MODULE$.println(x));
    }

    public String encrypted(Cypher cypher) {
        return package$.MODULE$.encrypt(Console$.MODULE$.askPassword(Console$.MODULE$.askPassword$default$1()), cypher);
    }

    public void version() {
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("You are running OpenMOLE " + org.openmole.core.buildinfo.package$.MODULE$.version() + " - " + org.openmole.core.buildinfo.package$.MODULE$.name() + "\n       |built on the " + org.openmole.core.buildinfo.package$.MODULE$.version().generationDate() + ".")));
    }

    public void modules(Option<Seq<String>> urls, Preference preference, Lazy<Random> randomProvider, TmpDirectory newFile, FileService fileService) {
        Set installedBundles = ((IterableOnceOps)PluginManager$.MODULE$.bundleHashes().map((Function1 & Serializable)_$4 -> _$4.toString())).toSet();
        ((IterableOnceOps)((SeqOps)((IterableOps)package$.MODULE$.optionalArgumentToOption(urls).getOrElse(() -> Command.modules$$anonfun$1(preference, randomProvider, newFile, fileService))).flatMap((Function1 & Serializable)url -> (IterableOnce)org.openmole.core.module.package$.MODULE$.modules(url).map((Function1 & Serializable)m -> m.name() + Command.installedString$1(installedBundles, m)))).sorted(package$.MODULE$.catsKernelOrderingForOrder((Order)package$.MODULE$.catsKernelStdOrderForString()))).foreach((Function1)(JProcedure1 & Serializable)x -> Predef$.MODULE$.println(x));
    }

    public Option<Seq<String>> modules$default$1() {
        return OptionalArgument.package.OptionalArgument$.MODULE$.noneToOptionalArgument(None$.MODULE$);
    }

    public void install(Seq<String> name, Preference preference, Lazy<Random> randomProvider, TmpDirectory newFile, Workspace workspace, FileService fileService) {
        this.install(name, this.install$default$2(), preference, randomProvider, newFile, workspace, fileService);
    }

    public void install(Seq<String> names, Option<Seq<String>> urls, Preference preference, Lazy<Random> randomProvider, TmpDirectory newFile, Workspace workspace, FileService fileService) {
        SeqOps seqOps;
        Seq toInstall = (Seq)((IterableOps)((IterableOps)package$.MODULE$.optionalArgumentToOption(urls).getOrElse(() -> Command.$anonfun$4(preference, randomProvider, newFile, fileService))).flatMap((Function1 & Serializable)url -> org.openmole.core.module.package$.MODULE$.selectableModules(url))).filter((Function1 & Serializable)sm -> names.contains((Object)sm.module().name()));
        if (toInstall.isEmpty()) {
            Predef$.MODULE$.println((Object)"The module(s) is/are already installed.");
            return;
        }
        Iterable<Tuple2<File, Throwable>> iterable = Console$.MODULE$.dealWithLoadError((Function0<Iterable<Tuple2<File, Throwable>>>)((Function0 & Serializable)() -> Command.install$$anonfun$1(newFile, workspace, toInstall)), true);
        if (iterable instanceof Seq && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)((Seq)iterable)), 0) == 0) {
            Predef$.MODULE$.println((Object)"The module(s) has/have been successfully installed, please restart the console to enable it/them.");
            return;
        }
        Iterable<Tuple2<File, Throwable>> e = iterable;
        Predef$.MODULE$.println((Object)"There was some errors during the installation, please restart the console to enable the installed module(s).");
    }

    public Option<Seq<String>> install$default$2() {
        return OptionalArgument.package.OptionalArgument$.MODULE$.noneToOptionalArgument(None$.MODULE$);
    }

    private static final Seq filtered$1(Environment environment$1, Level level$1) {
        return (Seq)Environment$.MODULE$.clearErrors(environment$1).filter((Function1 & Serializable)e -> e.level().intValue() >= level$1.intValue());
    }

    private static final String detail$1(ExceptionEvent error$1) {
        Option option = error$1.detail();
        if (None$.MODULE$.equals(option)) {
            return "";
        }
        if (option instanceof Some) {
            String m = (String)((Some)option).value();
            return "\n" + m + "\n";
        }
        throw new MatchError((Object)option);
    }

    private final void environmentErrors$1(Environment environment, Level level) {
        Command.filtered$1(environment, level).foreach((Function1)(JProcedure1 & Serializable)error -> Predef$.MODULE$.println((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(error.level().toString() + ": " + error.exception().getMessage() + Command.detail$1(error) + "\n             |" + this.exceptionToString(error.exception())))));
    }

    private static final int low$1(Seq errors$1) {
        return errors$1.count((Function1 & Serializable)_$1 -> _$1.level().intValue() <= Level.INFO.intValue());
    }

    private static final int warning$1(Seq errors$2) {
        return errors$2.count((Function1 & Serializable)_$2 -> _$2.level().intValue() == Level.WARNING.intValue());
    }

    private static final int severe$1(Seq errors$3) {
        return errors$3.count((Function1 & Serializable)_$3 -> _$3.level().intValue() == Level.SEVERE.intValue());
    }

    private final void printEnvironment$1(Environment environment, boolean debug) {
        Predef$.MODULE$.println((Object)(environment.simpleName() + ":"));
        Object[] objectArray = new Tuple2[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Submitted");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$u2192$extension((Object)string, (Object)BoxesRunTime.boxToLong((long)environment.submitted()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Running");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$u2192$extension((Object)string2, (Object)BoxesRunTime.boxToLong((long)environment.running()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Done");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$u2192$extension((Object)string3, (Object)BoxesRunTime.boxToLong((long)environment.done()));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Failed");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$u2192$extension((Object)string4, (Object)BoxesRunTime.boxToLong((long)environment.failed()));
        ((IterableOps)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                long number = BoxesRunTime.unboxToLong((Object)tuple2._2());
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                long number = BoxesRunTime.unboxToLong((Object)tuple2._2());
                Predef$.MODULE$.println((Object)("  " + label + ": " + number));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        Seq errors = Environment$.MODULE$.errors(environment);
        Predef$.MODULE$.println((Object)(Command.severe$1(errors) + " critical errors, " + Command.warning$1(errors) + " warning and " + Command.low$1(errors) + " low-importance errors. Use the errors() function to display them."));
        this.environmentErrors$1(environment, debug ? Level.FINE : Level.INFO);
    }

    private static final boolean installed$1(Set installedBundles$1, Seq components) {
        return components.toSet().$minus$minus((IterableOnce)installedBundles$1).isEmpty();
    }

    private static final Seq modules$$anonfun$1(Preference preference$2, Lazy randomProvider$2, TmpDirectory newFile$2, FileService fileService$2) {
        return org.openmole.core.module.package$.MODULE$.indexes(preference$2, randomProvider$2, newFile$2, fileService$2);
    }

    private static final String installedString$1(Set installedBundles$2, Module m$1) {
        if (Command.installed$1(installedBundles$2, (Seq)m$1.components().map((Function1 & Serializable)_$5 -> _$5.hash()))) {
            return " (installed)";
        }
        return "";
    }

    private static final Seq $anonfun$4(Preference preference$3, Lazy randomProvider$3, TmpDirectory newFile$3, FileService fileService$3) {
        return org.openmole.core.module.package$.MODULE$.indexes(preference$3, randomProvider$3, newFile$3, fileService$3);
    }

    private static final Iterable install$$anonfun$1(TmpDirectory newFile$4, Workspace workspace$2, Seq toInstall$1) {
        return org.openmole.core.module.package$.MODULE$.install(toInstall$1, newFile$4, workspace$2);
    }
}

