/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.concurrent.stm.InTxn;
import scala.concurrent.stm.MaybeTxn$;
import scala.concurrent.stm.RefLike;
import scala.concurrent.stm.Sink;
import scala.concurrent.stm.Source;
import scala.concurrent.stm.package$;
import scala.math.Fractional;
import scala.math.Integral;
import scala.math.Numeric;

public interface Ref<A>
extends RefLike<A, InTxn>,
Source<A>,
Sink<A> {
    @Override
    public View<A> single();

    public static interface View<A>
    extends Source.View<A>,
    Sink.View<A> {
        @Override
        public Ref<A> ref();

        public A swap(A var1);

        public boolean compareAndSet(A var1, A var2);

        public <B extends A> boolean compareAndSetIdentity(B var1, A var2);

        public void transform(Function1<A, A> var1);

        public A getAndTransform(Function1<A, A> var1);

        public A transformAndGet(Function1<A, A> var1);

        public static Object transformAndExtract$(View $this, Function1 f) {
            return $this.transformAndExtract(f);
        }

        default public <B> B transformAndExtract(Function1<A, Tuple2<A, B>> f) {
            return (B)package$.MODULE$.atomic().apply((Function1 & Serializable)txn -> this.ref().transformAndExtract(f, txn), MaybeTxn$.MODULE$.unknown());
        }

        public boolean transformIfDefined(PartialFunction<A, A> var1);

        public static void $plus$eq$(View $this, Object rhs, Numeric num) {
            $this.$plus$eq(rhs, num);
        }

        default public void $plus$eq(A rhs, Numeric<A> num) {
            this.transform((Function1 & Serializable)v -> num.plus(v, rhs));
        }

        public static void $minus$eq$(View $this, Object rhs, Numeric num) {
            $this.$minus$eq(rhs, num);
        }

        default public void $minus$eq(A rhs, Numeric<A> num) {
            this.transform((Function1 & Serializable)v -> num.minus(v, rhs));
        }

        public static void $times$eq$(View $this, Object rhs, Numeric num) {
            $this.$times$eq(rhs, num);
        }

        default public void $times$eq(A rhs, Numeric<A> num) {
            this.transform((Function1 & Serializable)v -> num.times(v, rhs));
        }

        public static void $div$eq$(View $this, Object rhs, Numeric num) {
            $this.$div$eq(rhs, num);
        }

        default public void $div$eq(A rhs, Numeric<A> num) {
            Numeric<A> numeric = num;
            if (numeric instanceof Fractional) {
                Fractional numF = (Fractional)numeric;
                this.transform((Function1 & Serializable)v -> numF.div(v, rhs));
            } else if (numeric instanceof Integral) {
                Integral numI = (Integral)numeric;
                this.transform((Function1 & Serializable)v -> numI.quot(v, rhs));
            } else {
                throw new MatchError(numeric);
            }
        }
    }
}

