/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.concurrent.stm.SinkLike;
import scala.concurrent.stm.SourceLike;
import scala.math.Fractional;
import scala.math.Integral;
import scala.math.Numeric;

public interface RefLike<A, Context>
extends SourceLike<A, Context>,
SinkLike<A, Context> {
    public A swap(A var1, Context var2);

    public void transform(Function1<A, A> var1, Context var2);

    public static Object transformAndGet$(RefLike $this, Function1 f, Object txn) {
        return $this.transformAndGet(f, txn);
    }

    /*
     * WARNING - void declaration
     */
    default public A transformAndGet(Function1<A, A> f, Context txn) {
        void var3_3;
        Object z = f.apply(this.get(txn));
        this.set(z, txn);
        return var3_3;
    }

    public static Object getAndTransform$(RefLike $this, Function1 f, Object txn) {
        return $this.getAndTransform(f, txn);
    }

    /*
     * WARNING - void declaration
     */
    default public A getAndTransform(Function1<A, A> f, Context txn) {
        void var3_3;
        Object z = this.get(txn);
        this.set(f.apply(z), txn);
        return var3_3;
    }

    public static Object transformAndExtract$(RefLike $this, Function1 f, Object txn) {
        return $this.transformAndExtract(f, txn);
    }

    default public <B> B transformAndExtract(Function1<A, Tuple2<A, B>> f, Context txn) {
        Tuple2 p = (Tuple2)f.apply(this.get(txn));
        this.set(p._1(), txn);
        return (B)p._2();
    }

    public boolean transformIfDefined(PartialFunction<A, A> var1, Context var2);

    public static void $plus$eq$(RefLike $this, Object rhs, Object txn, Numeric num) {
        $this.$plus$eq(rhs, txn, num);
    }

    default public void $plus$eq(A rhs, Context txn, Numeric<A> num) {
        this.transform((Function1 & Serializable)v -> num.plus(v, rhs), txn);
    }

    public static void $minus$eq$(RefLike $this, Object rhs, Object txn, Numeric num) {
        $this.$minus$eq(rhs, txn, num);
    }

    default public void $minus$eq(A rhs, Context txn, Numeric<A> num) {
        this.transform((Function1 & Serializable)v -> num.minus(v, rhs), txn);
    }

    public static void $times$eq$(RefLike $this, Object rhs, Object txn, Numeric num) {
        $this.$times$eq(rhs, txn, num);
    }

    default public void $times$eq(A rhs, Context txn, Numeric<A> num) {
        this.transform((Function1 & Serializable)v -> num.times(v, rhs), txn);
    }

    public static void $div$eq$(RefLike $this, Object rhs, Object txn, Numeric num) {
        $this.$div$eq(rhs, txn, num);
    }

    default public void $div$eq(A rhs, Context txn, Numeric<A> num) {
        Numeric<A> numeric = num;
        if (numeric instanceof Fractional) {
            Fractional numF = (Fractional)numeric;
            this.transform((Function1 & Serializable)v -> numF.div(v, rhs), txn);
        } else if (numeric instanceof Integral) {
            Integral numI = (Integral)numeric;
            this.transform((Function1 & Serializable)v -> numI.quot(v, rhs), txn);
        } else {
            throw new MatchError(numeric);
        }
    }
}

