/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import java.util.Arrays;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Symbol;
import scala.Tuple2;
import scala.concurrent.stm.Txn;
import scala.concurrent.stm.Txn$ExplicitRetryCause$;
import scala.concurrent.stm.Txn$OptimisticFailureCause$;
import scala.concurrent.stm.Txn$UncaughtExceptionCause$;
import scala.concurrent.stm.Txn$UnrecordedTxnCause$;
import scala.concurrent.stm.ccstm.CCSTM$;
import scala.concurrent.stm.ccstm.Handle;
import scala.concurrent.stm.ccstm.RetrySet;
import scala.concurrent.stm.ccstm.RetrySetBuilder;
import scala.concurrent.stm.ccstm.Stats;
import scala.concurrent.stm.ccstm.Stats$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class AccessHistory
implements ReadSet,
BargeSet,
WriteBuffer {
    private int _rCount;
    private Handle<?>[] _rHandles;
    private long[] _rVersions;
    private int _bCount;
    private Handle<?>[] _bHandles;
    private int _wUndoThreshold;
    private int _wCount;
    private int _wCapacity;
    private Object[] _wAnys;
    private int[] _wInts;
    private int[] _wDispatch;

    public AccessHistory() {
        int InitialReadCapacity = 1024;
        int MaxRetainedReadCapacity = 8192;
        this._rCount = 0;
        this._rHandles = null;
        this._rVersions = null;
        this.allocateReadSet();
        int InitialBargeCapacity = 1024;
        int MaxRetainedBargeCapacity = 8192;
        this._bCount = 0;
        this._bHandles = null;
        this.allocateBargeSet();
        int InitialWriteCapacity = 8;
        int MinAllocatedWriteCapacity = 512;
        int MaxRetainedWriteCapacity = 4096;
        this._wUndoThreshold = 0;
        this._wCount = 0;
        this._wCapacity = 8;
        this._wAnys = null;
        this._wInts = null;
        this._wDispatch = null;
        this.allocateWriteBuffer();
    }

    public abstract UndoLog undoLog();

    public void checkpointAccessHistory(int reusedReadThreshold) {
        this.checkpointReadSet(reusedReadThreshold);
        this.checkpointBargeSet();
        this.checkpointWriteBuffer();
    }

    public void mergeAccessHistory() {
        if (Stats$.MODULE$.nested() != null) {
            this.recordMerge();
        }
        this.mergeRetryTimeout();
        this.mergeWriteBuffer();
    }

    private void recordMerge() {
        Stats$.MODULE$.nested().commits().$plus$eq(1);
    }

    public void rollbackAccessHistory(int slot, Txn.RollbackCause cause) {
        if (Stats$.MODULE$.top() != null) {
            this.recordRollback(cause);
        }
        if (!(cause instanceof Txn.ExplicitRetryCause)) {
            this.rollbackReadSet();
            this.rollbackBargeSet(slot);
        }
        this.rollbackRetryTimeout(cause);
        this.rollbackWriteBuffer(slot);
    }

    private void recordRollback(Txn.RollbackCause cause) {
        Stats.Level stat = this.undoLog().parUndo() == null ? Stats$.MODULE$.top() : Stats$.MODULE$.nested();
        stat.rollbackReadSet().$plus$eq(this.readCount() - this.undoLog().prevReadCount());
        stat.rollbackBargeSet().$plus$eq(this.bargeCount() - this.undoLog().prevBargeCount());
        stat.rollbackWriteSet().$plus$eq(this.writeCount() - this.undoLog().prevWriteThreshold());
        Txn.RollbackCause rollbackCause = cause;
        if (rollbackCause instanceof Txn.ExplicitRetryCause) {
            Txn.ExplicitRetryCause explicitRetryCause = Txn$ExplicitRetryCause$.MODULE$.unapply((Txn.ExplicitRetryCause)rollbackCause);
            Option<Object> option = explicitRetryCause._1();
            stat.explicitRetries().$plus$eq(1);
        } else if (rollbackCause instanceof Txn.OptimisticFailureCause) {
            Txn.OptimisticFailureCause optimisticFailureCause = Txn$OptimisticFailureCause$.MODULE$.unapply((Txn.OptimisticFailureCause)rollbackCause);
            Symbol symbol = optimisticFailureCause._1();
            Option<Object> option = optimisticFailureCause._2();
            Symbol tag = symbol;
            stat.optimisticRetries().$plus$eq(tag);
        } else if (rollbackCause instanceof Txn.UncaughtExceptionCause) {
            Throwable throwable;
            Txn.UncaughtExceptionCause uncaughtExceptionCause = Txn$UncaughtExceptionCause$.MODULE$.unapply((Txn.UncaughtExceptionCause)rollbackCause);
            Throwable x = throwable = uncaughtExceptionCause._1();
            stat.failures().$plus$eq(x.getClass());
        } else if (rollbackCause instanceof Txn.UnrecordedTxnCause) {
            Txn.UnrecordedTxnCause unrecordedTxnCause = Txn$UnrecordedTxnCause$.MODULE$.unapply((Txn.UnrecordedTxnCause)rollbackCause);
            Object z = unrecordedTxnCause._1();
            stat.unrecordedTxns().$plus$eq(1);
        } else {
            throw new MatchError((Object)rollbackCause);
        }
    }

    public void resetAccessHistory() {
        if (Stats$.MODULE$.top() != null) {
            this.recordTopLevelCommit();
        }
        this.resetReadSet();
        this.resetBargeSet();
        this.resetWriteBuffer();
    }

    private void recordTopLevelCommit() {
        Stats.Level top = Stats$.MODULE$.top();
        top.commitReadSet().$plus$eq(this.readCount());
        top.commitBargeSet().$plus$eq(this.bargeCount());
        top.commitWriteSet().$plus$eq(this.writeCount());
        top.commits().$plus$eq(1);
    }

    public RetrySet takeRetrySet(int slot) {
        int i;
        for (i = 0; i < this._bCount; ++i) {
            this.rollbackHandle(this._bHandles[i], slot);
        }
        this.resetBargeSet();
        RetrySetBuilder accum = new RetrySetBuilder();
        for (i = 0; i < this._rCount; ++i) {
            accum.$plus$eq(this._rHandles[i], this._rVersions[i]);
        }
        this.resetReadSet();
        return accum.result();
    }

    private void mergeRetryTimeout() {
        UndoLog u = this.undoLog();
        UndoLog p = u.parUndo();
        p.addRetryTimeoutNanos(u.minRetryTimeoutNanos());
        p.consumedRetryDelta_$eq(p.consumedRetryDelta() + u.consumedRetryDelta());
    }

    private void rollbackRetryTimeout(Txn.RollbackCause cause) {
        block2: {
            Txn.RollbackCause rollbackCause;
            block1: {
                rollbackCause = cause;
                if (!(rollbackCause instanceof Txn.ExplicitRetryCause)) break block1;
                Txn.ExplicitRetryCause explicitRetryCause = Txn$ExplicitRetryCause$.MODULE$.unapply((Txn.ExplicitRetryCause)rollbackCause);
                Option<Object> option = explicitRetryCause._1();
                Option<Object> timeoutNanos = option;
                if (timeoutNanos.isDefined()) {
                    this.undoLog().addRetryTimeoutNanos(BoxesRunTime.unboxToLong((Object)timeoutNanos.get()));
                }
                if (this.undoLog().parUndo() == null) break block2;
                this.undoLog().parUndo().addRetryTimeoutNanos(this.undoLog().minRetryTimeoutNanos());
                break block2;
            }
            if (!(rollbackCause instanceof Txn.PermanentRollbackCause) || this.undoLog().parUndo() == null) break block2;
            UndoLog undoLog = this.undoLog().parUndo();
            undoLog.consumedRetryDelta_$eq(undoLog.consumedRetryDelta() + this.undoLog().consumedRetryDelta());
        }
    }

    @Override
    public int readCount() {
        return this._rCount;
    }

    @Override
    public Handle<?> readHandle(int i) {
        return this._rHandles[i];
    }

    @Override
    public long readVersion(int i) {
        return this._rVersions[i];
    }

    @Override
    public void recordRead(Handle<?> handle, long version) {
        int i = this._rCount;
        if (i == this._rHandles.length) {
            this.growReadSet();
        }
        this._rHandles[i] = handle;
        this._rVersions[i] = version;
        this._rCount = i + 1;
    }

    private void growReadSet() {
        this._rHandles = (Handle[])this.copyTo(this._rHandles, new Handle[this._rHandles.length * 2]);
        this._rVersions = (long[])this.copyTo(this._rVersions, new long[this._rVersions.length * 2]);
    }

    private <A> Object copyTo(Object src, Object dst) {
        System.arraycopy(src, 0, dst, 0, ScalaRunTime$.MODULE$.array_length(src));
        return dst;
    }

    private void checkpointReadSet(int reusedReadThreshold) {
        this.undoLog().prevReadCount_$eq(reusedReadThreshold >= 0 ? reusedReadThreshold : this._rCount);
    }

    private void rollbackReadSet() {
        int n;
        for (int i = n = this.undoLog().prevReadCount(); i < this._rCount; ++i) {
            this._rHandles[i] = null;
        }
        this._rCount = n;
    }

    private void resetReadSet() {
        if (this._rHandles.length > 8192) {
            this.allocateReadSet();
        } else {
            for (int i = 0; i < this._rCount; ++i) {
                this._rHandles[i] = null;
            }
        }
        this._rCount = 0;
    }

    private void allocateReadSet() {
        this._rHandles = new Handle[1024];
        this._rVersions = new long[1024];
    }

    @Override
    public UndoLog readLocate(int index) {
        return this.undoLog().readLocate(index);
    }

    @Override
    public int bargeCount() {
        return this._bCount;
    }

    @Override
    public Handle<?> bargeHandle(int i) {
        return this._bHandles[i];
    }

    @Override
    public void recordBarge(Handle<?> handle) {
        int i = this._bCount;
        if (i == this._bHandles.length) {
            this.growBargeSet();
        }
        this._bHandles[i] = handle;
        this._bCount = i + 1;
    }

    private void growBargeSet() {
        this._bHandles = (Handle[])this.copyTo(this._bHandles, new Handle[this._bHandles.length * 2]);
    }

    private void checkpointBargeSet() {
        this.undoLog().prevBargeCount_$eq(this._bCount);
    }

    private void rollbackBargeSet(int slot) {
        int n;
        for (int i = n = this.undoLog().prevBargeCount(); i < this._bCount; ++i) {
            this.rollbackHandle(this._bHandles[i], slot);
            this._bHandles[i] = null;
        }
        this._bCount = n;
    }

    private void resetBargeSet() {
        if (this._bCount > 0) {
            this.resetBargeSetNonEmpty();
        }
    }

    private void resetBargeSetNonEmpty() {
        if (this._bHandles.length > 8192) {
            this.allocateBargeSet();
        } else {
            for (int i = 0; i < this._bCount; ++i) {
                this._bHandles[i] = null;
            }
        }
        this._bCount = 0;
    }

    private void allocateBargeSet() {
        this._bHandles = new Handle[1024];
    }

    private void allocateWriteBuffer() {
        this._wAnys = new Object[this.bucketAnysLen(512)];
        this._wInts = new int[this.bucketIntsLen(512)];
        this._wDispatch = new int[512];
        Arrays.fill(this._wDispatch, 0, 8, -1);
    }

    private int refI(int i) {
        return 3 * i;
    }

    private int specValueI(int i) {
        return 3 * i + 1;
    }

    private int handleI(int i) {
        return 3 * i + 2;
    }

    private int offsetI(int i) {
        return 2 * i;
    }

    private int nextI(int i) {
        return 2 * i + 1;
    }

    private int bucketAnysLen(int c) {
        return 3 * (this.maxSizeForCap(c) + 1);
    }

    private int bucketIntsLen(int c) {
        return 2 * (this.maxSizeForCap(c) + 1);
    }

    private int maxSizeForCap(int c) {
        return c - c / 4;
    }

    private boolean shouldGrow(int s, int c) {
        return s > this.maxSizeForCap(c);
    }

    private boolean shouldGrow() {
        return this.shouldGrow(this._wCount, this._wCapacity);
    }

    private boolean shouldShrink(int s, int c) {
        return c > 8 && !this.shouldGrow(s, c / 4);
    }

    private boolean shouldShrink() {
        return this.shouldShrink(this._wCount, this._wCapacity);
    }

    private Object getRef(int i) {
        return this._wAnys[this.refI(i)];
    }

    @Override
    public final Handle<?> getWriteHandle(int i) {
        return (Handle)this._wAnys[this.handleI(i)];
    }

    @Override
    public final <T> T getWriteSpecValue(int i) {
        return (T)this._wAnys[this.specValueI(i)];
    }

    private int getOffset(int i) {
        return this._wInts[this.offsetI(i)];
    }

    private int getNext(int i) {
        return this._wInts[this.nextI(i)] >> 1;
    }

    @Override
    public final boolean wasWriteFreshOwner(int i) {
        return (this._wInts[this.nextI(i)] & 1) != 0;
    }

    private void setRef(int i, Object r) {
        this._wAnys[this.refI((int)i)] = r;
    }

    private void setHandle(int i, Handle<?> h) {
        this._wAnys[this.handleI((int)i)] = h;
    }

    public final <T> void setSpecValue(int i, T v) {
        this._wAnys[this.specValueI((int)i)] = v;
    }

    private void setOffset(int i, int o) {
        this._wInts[this.offsetI((int)i)] = o;
    }

    private void setNextAndFreshOwner(int i, int n, boolean freshOwner) {
        this._wInts[this.nextI((int)i)] = n << 1 | (freshOwner ? 1 : 0);
    }

    private void setNext(int i, int n) {
        this._wInts[this.nextI((int)i)] = n << 1 | this._wInts[this.nextI(i)] & 1;
    }

    private void setFreshOwner(int i, boolean freshOwner) {
        this.setNextAndFreshOwner(i, this.getNext(i), freshOwner);
    }

    @Override
    public int writeCount() {
        return this._wCount;
    }

    @Override
    public <T> T stableGet(Handle<T> handle) {
        int i = this.findWrite(handle);
        return i >= 0 ? this.getWriteSpecValue(i) : handle.data();
    }

    @Override
    public int findWrite(Handle<?> handle) {
        Object base = handle.base();
        int offset = handle.offset();
        return this.find(base, offset, this.computeSlot(base, offset));
    }

    private int computeSlot(Object base, int offset) {
        return this._wCapacity == 8 ? 0 : CCSTM$.MODULE$.hash(base, offset) & this._wCapacity - 1;
    }

    private int find(Object base, int offset, int slot) {
        int i = this._wDispatch[slot];
        while (i >= 0 && (base != this.getRef(i) || offset != this.getOffset(i))) {
            i = this.getNext(i);
        }
        return i;
    }

    @Override
    public <T> void put(Handle<T> handle, boolean freshOwner, T value) {
        int slot;
        int offset;
        Object base = handle.base();
        int i = this.find(base, offset = handle.offset(), slot = this.computeSlot(base, offset));
        if (i >= 0) {
            if (i < this._wUndoThreshold) {
                this.undoLog().logWrite(i, this.getWriteSpecValue(i));
            }
            this.setSpecValue(i, value);
        } else {
            this.append(base, offset, handle, freshOwner, value, slot);
        }
    }

    @Override
    public <T> T swap(Handle<T> handle, boolean freshOwner, T value) {
        int i = this.findOrAllocate(handle, freshOwner);
        T before = this.getWriteSpecValue(i);
        this.setSpecValue(i, value);
        return before;
    }

    @Override
    public <T, R extends T> boolean compareAndSetIdentity(Handle<T> handle, boolean freshOwner, R before, T after) {
        boolean bl;
        int i = this.findOrAllocate(handle, freshOwner);
        T v0 = this.getWriteSpecValue(i);
        if (before == v0) {
            this.setSpecValue(i, after);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public <T> T getAndTransform(Handle<T> handle, boolean freshOwner, Function1<T, T> func) {
        int i = this.findOrAllocate(handle, freshOwner);
        T before = this.getWriteSpecValue(i);
        this.setSpecValue(i, func.apply(before));
        return before;
    }

    @Override
    public <T> T transformAndGet(Handle<T> handle, boolean freshOwner, Function1<T, T> func) {
        int i = this.findOrAllocate(handle, freshOwner);
        Object after = func.apply(this.getWriteSpecValue(i));
        this.setSpecValue(i, after);
        return (T)after;
    }

    @Override
    public <T, V> V transformAndExtract(Handle<T> handle, boolean freshOwner, Function1<T, Tuple2<T, V>> func) {
        int i = this.findOrAllocate(handle, freshOwner);
        Tuple2 pair = (Tuple2)func.apply(this.getWriteSpecValue(i));
        this.setSpecValue(i, pair._1());
        return (V)pair._2();
    }

    @Override
    public int getAndAdd(Handle<Object> handle, boolean freshOwner, int delta) {
        int i = this.findOrAllocate(handle, freshOwner);
        int before = BoxesRunTime.unboxToInt(this.getWriteSpecValue(i));
        this.setSpecValue(i, BoxesRunTime.boxToInteger((int)(before + delta)));
        return before;
    }

    @Override
    public <T> void writeAppend(Handle<T> handle, boolean freshOwner, T value) {
        Object base = handle.base();
        int offset = handle.offset();
        int slot = this.computeSlot(base, offset);
        this.append(base, offset, handle, freshOwner, value, slot);
    }

    @Override
    public <T> void writeUpdate(int i, T value) {
        if (i < this._wUndoThreshold) {
            this.undoLog().logWrite(i, this.getWriteSpecValue(i));
        }
        this.setSpecValue(i, value);
    }

    private int findOrAllocate(Handle<?> handle, boolean freshOwner) {
        int i;
        Object base = handle.base();
        int offset = handle.offset();
        int slot = this.computeSlot(base, offset);
        if (!freshOwner && (i = this.find(base, offset, slot)) >= 0) {
            if (i < this._wUndoThreshold) {
                this.undoLog().logWrite(i, this.getWriteSpecValue(i));
            }
            return i;
        }
        return this.append(base, offset, handle, freshOwner, handle.data(), slot);
    }

    private int append(Object base, int offset, Handle<?> handle, boolean freshOwner, Object value, int slot) {
        int i = this._wCount;
        this.setRef(i, base);
        this.setSpecValue(i, value);
        this.setHandle(i, handle);
        this.setOffset(i, offset);
        this.setNextAndFreshOwner(i, this._wDispatch[slot], freshOwner);
        this._wDispatch[slot] = i;
        this._wCount = i + 1;
        if (this.shouldGrow()) {
            this.grow();
        }
        return i;
    }

    private void grow() {
        this._wCapacity *= 2;
        if (this._wCapacity > this._wDispatch.length) {
            this._wAnys = (Object[])this.copyTo(this._wAnys, new Object[this.bucketAnysLen(this._wCapacity)]);
            this._wInts = (int[])this.copyTo(this._wInts, new int[this.bucketIntsLen(this._wCapacity)]);
            this._wDispatch = new int[this._wCapacity];
        }
        this.rebuildDispatch();
    }

    private void rebuildDispatch() {
        Arrays.fill(this._wDispatch, 0, this._wCapacity, -1);
        int i = 0;
        while (i < this._wCount) {
            int slot = this.computeSlot(this.getRef(i), this.getOffset(i));
            this.setNext(i, this._wDispatch[slot]);
            this._wDispatch[slot] = i++;
        }
    }

    private void checkpointWriteBuffer() {
        this.undoLog().prevWriteThreshold_$eq(this._wUndoThreshold);
        this._wUndoThreshold = this._wCount;
    }

    private void mergeWriteBuffer() {
        this._wUndoThreshold = this.undoLog().prevWriteThreshold();
    }

    private void rollbackWriteBuffer(int slot) {
        int i;
        boolean completeRelink;
        this.undoLog().undoWrites(this);
        int e = this._wUndoThreshold;
        boolean bl = completeRelink = i >= 2 * e;
        for (i = this._wCount - 1; i >= e; --i) {
            if (this.wasWriteFreshOwner(i)) {
                this.rollbackHandle(this.getWriteHandle(i), slot);
            }
            if (!completeRelink) {
                this._wDispatch[this.computeSlot((Object)this.getRef((int)i), (int)this.getOffset((int)i))] = this.getNext(i);
            }
            this.setRef(i, null);
            this.setSpecValue(i, null);
            this.setHandle(i, null);
        }
        this._wCount = e;
        if (completeRelink) {
            while (this.shouldShrink()) {
                this._wCapacity /= 2;
            }
            this.rebuildDispatch();
        }
        this._wUndoThreshold = this.undoLog().prevWriteThreshold();
    }

    public void rollbackHandle(Handle<?> h, int slot) {
        this.rollbackHandle(h, slot, h.meta());
    }

    public void rollbackHandle(Handle<?> h, int slot, long m0) {
        long m = m0;
        while (CCSTM$.MODULE$.owner(m) == slot && !h.metaCAS(m, CCSTM$.MODULE$.withRollback(m))) {
            m = h.meta();
        }
    }

    private void resetWriteBuffer() {
        if (this._wCount > 0) {
            this.resetWriteBufferNonEmpty();
        }
    }

    private void resetWriteBufferNonEmpty() {
        if (this._wDispatch.length > 4096) {
            this.allocateWriteBuffer();
        } else {
            int i;
            int n = this.bucketAnysLen(this._wCount);
            for (i = 0; i < n; ++i) {
                this._wAnys[i] = null;
            }
            for (i = 0; i < 8; ++i) {
                this._wDispatch[i] = -1;
            }
        }
        this._wCount = 0;
        this._wCapacity = 8;
    }

    public void addLatestWritesAsReads(boolean convertToBarge) {
        int i;
        for (i = this.undoLog().prevBargeCount(); i < this._bCount; ++i) {
            Handle<?> h = this._bHandles[i];
            this.recordRead(h, CCSTM$.MODULE$.version(h.meta()));
        }
        for (i = this._wUndoThreshold; i < this._wCount; ++i) {
            Handle<?> h = this.getWriteHandle(i);
            if (!this.wasWriteFreshOwner(i)) continue;
            this.recordRead(h, CCSTM$.MODULE$.version(h.meta()));
            if (!convertToBarge) continue;
            this.setFreshOwner(i, false);
            this.recordBarge(h);
        }
    }

    public static interface BargeSet {
        public int bargeCount();

        public Handle<?> bargeHandle(int var1);

        public void recordBarge(Handle<?> var1);
    }

    public static interface ReadSet {
        public int readCount();

        public Handle<?> readHandle(int var1);

        public long readVersion(int var1);

        public void recordRead(Handle<?> var1, long var2);

        public UndoLog readLocate(int var1);
    }

    public static abstract class UndoLog {
        private long minRetryTimeoutNanos = Long.MAX_VALUE;
        private long consumedRetryDelta = 0L;
        private int prevReadCount = 0;
        private int prevBargeCount = 0;
        private int prevWriteThreshold = 0;
        private int _logSize = 0;
        private int[] _indices = null;
        private Object[] _prevValues = null;

        public abstract UndoLog parUndo();

        public long minRetryTimeoutNanos() {
            return this.minRetryTimeoutNanos;
        }

        public void minRetryTimeoutNanos_$eq(long x$1) {
            this.minRetryTimeoutNanos = x$1;
        }

        public long consumedRetryDelta() {
            return this.consumedRetryDelta;
        }

        public void consumedRetryDelta_$eq(long x$1) {
            this.consumedRetryDelta = x$1;
        }

        public int prevReadCount() {
            return this.prevReadCount;
        }

        public void prevReadCount_$eq(int x$1) {
            this.prevReadCount = x$1;
        }

        public int prevBargeCount() {
            return this.prevBargeCount;
        }

        public void prevBargeCount_$eq(int x$1) {
            this.prevBargeCount = x$1;
        }

        public int prevWriteThreshold() {
            return this.prevWriteThreshold;
        }

        public void prevWriteThreshold_$eq(int x$1) {
            this.prevWriteThreshold = x$1;
        }

        public void addRetryTimeoutNanos(long timeoutNanos) {
            this.minRetryTimeoutNanos_$eq(package$.MODULE$.min(this.minRetryTimeoutNanos(), timeoutNanos));
        }

        public final long consumedRetryTotal(long accum) {
            long z;
            UndoLog undoLog = this;
            long l = accum;
            while (true) {
                z = l + undoLog.consumedRetryDelta();
                if (undoLog.parUndo() == null) break;
                UndoLog undoLog2 = undoLog.parUndo();
                long l2 = z;
                undoLog = undoLog2;
                l = l2;
            }
            return z;
        }

        public long consumedRetryTotal$default$1() {
            return 0L;
        }

        public final UndoLog readLocate(int index) {
            UndoLog undoLog = this;
            while (index < undoLog.prevReadCount()) {
                undoLog = undoLog.parUndo();
            }
            return undoLog;
        }

        public void logWrite(int i, Object v) {
            if (this._indices == null || this._logSize == this._indices.length) {
                this.grow();
            }
            this._indices[this._logSize] = i;
            this._prevValues[this._logSize] = v;
            ++this._logSize;
        }

        private void grow() {
            if (this._logSize == 0) {
                this._indices = new int[16];
                this._prevValues = new Object[16];
            } else {
                this._indices = (int[])this.copyTo(this._indices, new int[this._indices.length * 2]);
                this._prevValues = (Object[])this.copyTo(this._prevValues, new Object[this._prevValues.length * 2]);
            }
        }

        private <A> Object copyTo(Object src, Object dst) {
            System.arraycopy(src, 0, dst, 0, ScalaRunTime$.MODULE$.array_length(src));
            return dst;
        }

        public void undoWrites(AccessHistory hist) {
            for (int i = this._logSize - 1; i >= 0; --i) {
                hist.setSpecValue(this._indices[i], this._prevValues[i]);
            }
        }
    }

    public static interface WriteBuffer {
        public int writeCount();

        public Handle<?> getWriteHandle(int var1);

        public <T> T getWriteSpecValue(int var1);

        public boolean wasWriteFreshOwner(int var1);

        public int findWrite(Handle<?> var1);

        public <T> T stableGet(Handle<T> var1);

        public <T> void put(Handle<T> var1, boolean var2, T var3);

        public <T> void writeAppend(Handle<T> var1, boolean var2, T var3);

        public <T> void writeUpdate(int var1, T var2);

        public <T> T swap(Handle<T> var1, boolean var2, T var3);

        public <T, R extends T> boolean compareAndSetIdentity(Handle<T> var1, boolean var2, R var3, T var4);

        public <T> T getAndTransform(Handle<T> var1, boolean var2, Function1<T, T> var3);

        public <T> T transformAndGet(Handle<T> var1, boolean var2, Function1<T, T> var3);

        public <T, V> V transformAndExtract(Handle<T> var1, boolean var2, Function1<T, Tuple2<T, V>> var3);

        public int getAndAdd(Handle<Object> var1, boolean var2, int var3);
    }
}

