/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.stm.InTxn;
import scala.concurrent.stm.InTxnEnd;
import scala.concurrent.stm.MaybeTxn;
import scala.concurrent.stm.NestingLevel;
import scala.concurrent.stm.Txn;
import scala.concurrent.stm.Txn$;
import scala.concurrent.stm.Txn$Committed$;
import scala.concurrent.stm.Txn$Committing$;
import scala.concurrent.stm.Txn$ExplicitRetryCause$;
import scala.concurrent.stm.Txn$OptimisticFailureCause$;
import scala.concurrent.stm.Txn$Prepared$;
import scala.concurrent.stm.Txn$Preparing$;
import scala.concurrent.stm.Txn$UncaughtExceptionCause$;
import scala.concurrent.stm.Txn$UnrecordedTxnCause$;
import scala.concurrent.stm.TxnExecutor;
import scala.concurrent.stm.ccstm.AccessHistory;
import scala.concurrent.stm.ccstm.CCSTM$;
import scala.concurrent.stm.ccstm.CommitBarrierImpl;
import scala.concurrent.stm.ccstm.Handle;
import scala.concurrent.stm.ccstm.InTxnImpl$;
import scala.concurrent.stm.ccstm.InTxnRefOps;
import scala.concurrent.stm.ccstm.RetrySet;
import scala.concurrent.stm.ccstm.RewindUnrecordedTxnError$;
import scala.concurrent.stm.ccstm.Stats$;
import scala.concurrent.stm.ccstm.TxnLevelImpl;
import scala.concurrent.stm.impl.AlternativeResult;
import scala.concurrent.stm.skel.RollbackError$;
import scala.concurrent.stm.skel.SimpleRandom$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.Scala3RunTime$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class InTxnImpl
extends InTxnRefOps {
    private List<Function1<InTxn, Object>> _alternatives = package$.MODULE$.Nil();
    private boolean _subsumptionAllowed = true;
    private long _cumulativeBlockingNanos = 0L;
    private boolean _barging = false;
    private long _bargeVersion = 0L;
    private int _slot = -1;
    private TxnLevelImpl _currentLevel = null;
    private Throwable _pendingFailure = null;
    private TxnLevelImpl _subsumptionParent = null;
    private int _priority = 0;
    private long _readVersion = 0L;
    private CommitBarrierImpl commitBarrier = null;

    public static InTxnImpl apply(MaybeTxn maybeTxn) {
        return InTxnImpl$.MODULE$.apply(maybeTxn);
    }

    public static Object childValue(Object object) {
        return InTxnImpl$.MODULE$.childValue(object);
    }

    public static void createMap(Thread thread, Object object) {
        InTxnImpl$.MODULE$.createMap(thread, object);
    }

    public static InTxnImpl currentOrNull(MaybeTxn maybeTxn) {
        return InTxnImpl$.MODULE$.currentOrNull(maybeTxn);
    }

    public static InTxnImpl dynCurrentOrNull() {
        return InTxnImpl$.MODULE$.dynCurrentOrNull();
    }

    public static ThreadLocal.ThreadLocalMap getMap(Thread thread) {
        return InTxnImpl$.MODULE$.getMap(thread);
    }

    public static InTxnImpl initialValue() {
        return InTxnImpl$.MODULE$.initialValue();
    }

    public static Object initialValue() {
        return InTxnImpl$.MODULE$.initialValue();
    }

    public static boolean isPresent() {
        return InTxnImpl$.MODULE$.isPresent();
    }

    public static void remove() {
        InTxnImpl$.MODULE$.remove();
    }

    @Override
    public boolean _barging() {
        return this._barging;
    }

    public void _barging_$eq(boolean x$1) {
        this._barging = x$1;
    }

    @Override
    public long _bargeVersion() {
        return this._bargeVersion;
    }

    public void _bargeVersion_$eq(long x$1) {
        this._bargeVersion = x$1;
    }

    @Override
    public int _slot() {
        return this._slot;
    }

    public void _slot_$eq(int x$1) {
        this._slot = x$1;
    }

    private int _priority() {
        return this._priority;
    }

    private void _priority_$eq(int x$0) {
        this._priority = x$0;
    }

    public CommitBarrierImpl commitBarrier() {
        return this.commitBarrier;
    }

    public void commitBarrier_$eq(CommitBarrierImpl x$1) {
        this.commitBarrier = x$1;
    }

    @Override
    public Txn.Status status() {
        return this._currentLevel.statusAsCurrent();
    }

    @Override
    public NestingLevel currentLevel() {
        if (this._subsumptionParent != null) {
            this._subsumptionAllowed = false;
            this._subsumptionParent.forceRollback(Txn$OptimisticFailureCause$.MODULE$.apply(Symbol$.MODULE$.apply("restart_to_materialize_current_level"), (Option<Object>)None$.MODULE$));
            throw RollbackError$.MODULE$;
        }
        return this._currentLevel;
    }

    public String toString() {
        return "InTxnImpl@" + RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(this.hashCode())) + "(" + (this._currentLevel == null ? "Detached" : this.status().toString()) + ", slot=" + this._slot() + ", subsumptionAllowed=" + this._subsumptionAllowed + ", priority=" + this._priority() + ", readCount=" + this.readCount() + ", bargeCount=" + this.bargeCount() + ", writeCount=" + this.writeCount() + ", readVersion=0x" + RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(this._readVersion)) + (this._barging() ? ", bargingVersion=0x" + RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(this._bargeVersion())) : "") + ", cumulativeBlockingNanos=" + this._cumulativeBlockingNanos + ", commitBarrier=" + this.commitBarrier() + ")";
    }

    @Override
    public TxnLevelImpl undoLog() {
        return this._currentLevel;
    }

    @Override
    public TxnLevelImpl internalCurrentLevel() {
        return this._currentLevel;
    }

    public void resolveWriteWriteConflict(TxnLevelImpl owningRoot, Object contended) {
        block3: {
            Txn.Status s;
            block4: {
                block2: {
                    this.requireActive();
                    if (this._priority() > owningRoot.txn()._priority()) break block2;
                    this.resolveAsWWLoser(owningRoot, contended, false, Symbol$.MODULE$.apply("owner_has_priority"));
                    break block3;
                }
                Txn.Status status = s = owningRoot.requestRollback(Txn$OptimisticFailureCause$.MODULE$.apply(Symbol$.MODULE$.apply("steal_by_higher_priority"), (Option<Object>)Some$.MODULE$.apply(contended)));
                Txn$Preparing$ txn$Preparing$ = Txn$Preparing$.MODULE$;
                if (!(status == null ? txn$Preparing$ != null : !status.equals(txn$Preparing$))) break block4;
                Txn.Status status2 = s;
                Txn$Committing$ txn$Committing$ = Txn$Committing$.MODULE$;
                if (status2 != null ? !status2.equals(txn$Committing$) : txn$Committing$ != null) break block3;
            }
            Txn.Status status = s;
            Txn$Preparing$ txn$Preparing$ = Txn$Preparing$.MODULE$;
            Symbol msg = Symbol$.MODULE$.apply(!(status != null ? !status.equals(txn$Preparing$) : txn$Preparing$ != null) ? "owner_is_preparing" : "owner_is_committing");
            this.resolveAsWWLoser(owningRoot, contended, true, msg);
        }
    }

    private void resolveAsWWLoser(TxnLevelImpl owningRoot, Object contended, boolean ownerIsCommitting, Symbol msg) {
        if (!this.shouldWaitAsWWLoser(owningRoot, ownerIsCommitting)) {
            this._currentLevel.forceRollback(Txn$OptimisticFailureCause$.MODULE$.apply(msg, (Option<Object>)Some$.MODULE$.apply(contended)));
            throw RollbackError$.MODULE$;
        }
    }

    private boolean shouldWaitAsWWLoser(TxnLevelImpl owningRoot, boolean ownerIsCommitting) {
        if (this.writeCount() == 0 && this.bargeCount() == 0 && !this.writeResourcesPresent()) {
            return true;
        }
        if (ownerIsCommitting) {
            return true;
        }
        if (this.commitBarrier() != null) {
            return false;
        }
        if (this._priority() == owningRoot.txn()._priority()) {
            return false;
        }
        return this._barging();
    }

    /*
     * WARNING - void declaration
     */
    public boolean pushAlternative(Function1<InTxn, Object> block) {
        void var2_2;
        boolean z = this._alternatives.isEmpty();
        this._alternatives = this._alternatives.$colon$colon(block);
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private List<Function1<InTxn, Object>> takeAlternatives() {
        void var1_1;
        List<Function1<InTxn, Object>> z = this._alternatives;
        this._alternatives = package$.MODULE$.Nil();
        return var1_1;
    }

    @Override
    public Nothing$ retry() throws InterruptedException {
        TxnLevelImpl txnLevelImpl = this._currentLevel;
        long timeout = txnLevelImpl.minEnclosingRetryTimeout(txnLevelImpl.minEnclosingRetryTimeout$default$1());
        if (timeout == Long.MAX_VALUE) {
            throw this.rollback(Txn$ExplicitRetryCause$.MODULE$.apply((Option<Object>)None$.MODULE$));
        }
        TxnLevelImpl txnLevelImpl2 = this._currentLevel;
        long consumed = txnLevelImpl2.consumedRetryTotal(txnLevelImpl2.consumedRetryTotal$default$1());
        if (this._cumulativeBlockingNanos < timeout + consumed) {
            throw this.rollback(Txn$ExplicitRetryCause$.MODULE$.apply((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(timeout + consumed)))));
        }
        TxnLevelImpl txnLevelImpl3 = this._currentLevel;
        txnLevelImpl3.consumedRetryDelta_$eq(txnLevelImpl3.consumedRetryDelta() + timeout);
        throw new InterruptedException();
    }

    @Override
    public void retryFor(long timeoutNanos) throws InterruptedException {
        TxnLevelImpl txnLevelImpl = this._currentLevel;
        long effectiveTimeout = txnLevelImpl.minEnclosingRetryTimeout(txnLevelImpl.minEnclosingRetryTimeout$default$1());
        if (effectiveTimeout < timeoutNanos) {
            throw this.retry();
        }
        TxnLevelImpl txnLevelImpl2 = this._currentLevel;
        long consumed = txnLevelImpl2.consumedRetryTotal(txnLevelImpl2.consumedRetryTotal$default$1());
        if (this._cumulativeBlockingNanos < timeoutNanos + consumed) {
            throw this.rollback(Txn$ExplicitRetryCause$.MODULE$.apply((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(timeoutNanos + consumed)))));
        }
        TxnLevelImpl txnLevelImpl3 = this._currentLevel;
        txnLevelImpl3.consumedRetryDelta_$eq(txnLevelImpl3.consumedRetryDelta() + timeoutNanos);
    }

    public <Z> Z atomic(TxnExecutor exec, Function1<InTxn, Z> block) throws InterruptedException {
        if (this._alternatives.nonEmpty()) {
            throw this.atomicWithAlternatives(exec, block);
        }
        return this._currentLevel == null ? this.topLevelAtomicImpl(exec, block) : this.nestedAtomicImpl(exec, block);
    }

    public <Z> Z atomicOneOf(TxnExecutor exec, Seq<Function1<InTxn, Z>> blocks) throws InterruptedException {
        if (this._alternatives.nonEmpty()) {
            throw new IllegalStateException("atomic.oneOf can't be mixed with orAtomic");
        }
        List b = blocks.toList();
        return this.atomicImpl(exec, (Function1)b.head(), (List)b.tail());
    }

    public <Z> Z unrecorded(TxnExecutor exec, Function1<InTxn, Z> block, Function1<Txn.RollbackCause, Z> outerFailure) throws InterruptedException {
        Object object;
        if (this._alternatives.nonEmpty()) {
            throw new IllegalStateException("atomic.unrecorded can't be mixed with orAtomic");
        }
        ObjectRef z = ObjectRef.create(null);
        try {
            object = this.atomicImpl(exec, (Function1<InTxn, Z>)(Function1 & Serializable)txn -> {
                Object object;
                z$1.elem = object = block.apply(txn);
                return Txn$.MODULE$.rollback(Txn$UnrecordedTxnCause$.MODULE$.apply(z$1.elem), (InTxnEnd)txn);
            }, (List<Function1<InTxn, Z>>)package$.MODULE$.Nil());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (RewindUnrecordedTxnError$.MODULE$.equals(throwable2)) {
                object = z.elem;
            }
            if (RollbackError$.MODULE$.equals(throwable2) && outerFailure != null) {
                object = outerFailure.apply((Object)((Txn.RolledBack)this._currentLevel.statusAsCurrent()).cause());
            }
            throw throwable;
        }
        return object;
    }

    @Override
    public Nothing$ rollback(Txn.RollbackCause cause) {
        if (this.isExplicitRetry(cause)) {
            this.addLatestWritesAsReads(this._barging());
        }
        this._currentLevel.forceRollback(cause);
        throw RollbackError$.MODULE$;
    }

    private void awaitRetry(long timeoutNanos) throws InterruptedException {
        if (this._slot() < 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        RetrySet rs = this.takeRetrySet(this._slot());
        this.detach();
        Throwable f = this._pendingFailure;
        if (f != null) {
            this._pendingFailure = null;
            throw f;
        }
        long remaining = timeoutNanos - (timeoutNanos == Long.MAX_VALUE ? 0L : this._cumulativeBlockingNanos);
        if (remaining <= 0L) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this._cumulativeBlockingNanos += rs.awaitRetry(remaining);
    }

    private boolean isExplicitRetry(Txn.Status status) {
        return this.isExplicitRetry(((Txn.RolledBack)status).cause());
    }

    private boolean isExplicitRetry(Txn.RollbackCause cause) {
        return cause instanceof Txn.ExplicitRetryCause;
    }

    private void clearAttemptHistory() {
        this._subsumptionAllowed = true;
        this._cumulativeBlockingNanos = 0L;
        this.commitBarrier_$eq(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private <Z> Z nestedAtomicImpl(TxnExecutor exec, Function1<InTxn, Z> block) {
        Z z;
        if (this._subsumptionAllowed) {
            TxnExecutor txnExecutor = exec;
            TxnExecutor txnExecutor2 = this._currentLevel.executor();
            if (!(txnExecutor != null ? !txnExecutor.equals(txnExecutor2) : txnExecutor2 != null)) {
                z = this.subsumedNestedAtomicImpl(block);
                return z;
            }
        }
        z = this.trueNestedAtomicImpl(exec, block);
        return z;
    }

    private <Z> Z subsumedNestedAtomicImpl(Function1<InTxn, Z> block) {
        Object object;
        boolean outermost;
        boolean bl = outermost = this._subsumptionParent == null;
        if (outermost) {
            this._subsumptionParent = this._currentLevel;
        }
        try {
            try {
                object = block.apply((Object)this);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable x;
                Throwable throwable3 = x = (throwable2 = throwable);
                RollbackError$ rollbackError$ = RollbackError$.MODULE$;
                if ((throwable3 == null ? rollbackError$ != null : !throwable3.equals(rollbackError$)) && !this._currentLevel.executor().isControlFlow(x)) {
                    this._subsumptionAllowed = false;
                    this._currentLevel.forceRollback(Txn$OptimisticFailureCause$.MODULE$.apply(Symbol$.MODULE$.apply("restart_to_enable_partial_rollback"), (Option<Object>)Some$.MODULE$.apply((Object)x)));
                    throw RollbackError$.MODULE$;
                }
                throw throwable;
            }
        }
        finally {
            if (outermost) {
                this._subsumptionParent = null;
            }
        }
        return (Z)object;
    }

    private <Z> Z trueNestedAtomicImpl(TxnExecutor exec, Function1<InTxn, Z> block) {
        int prevFailures = 0;
        while (true) {
            this._currentLevel.requireActive();
            TxnLevelImpl level = new TxnLevelImpl(this, exec, this._currentLevel, false);
            try {
                return this.nestedAttempt(prevFailures, level, block, -1);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (!RollbackError$.MODULE$.equals(throwable2)) {
                    throw throwable;
                }
                Txn.RollbackCause cause = ((Txn.RolledBack)level.status()).cause();
                if (this.isExplicitRetry(cause)) {
                    this._currentLevel.forceRollback(cause);
                    throw RollbackError$.MODULE$;
                }
                ++prevFailures;
            }
        }
        throw (Nothing$)BoxedUnit.UNIT;
    }

    private <Z> Z topLevelAtomicImpl(TxnExecutor exec, Function1<InTxn, Z> block) throws InterruptedException {
        this.clearAttemptHistory();
        int prevFailures = 0;
        while (true) {
            TxnLevelImpl level = new TxnLevelImpl(this, exec, null, false);
            try {
                return this.topLevelAttempt(prevFailures, level, block);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (!RollbackError$.MODULE$.equals(throwable2)) {
                    throw throwable;
                }
                if (this.isExplicitRetry(level.status())) {
                    long timeout = level.minRetryTimeoutNanos();
                    level = null;
                    this.awaitRetry(timeout);
                    prevFailures = 0;
                    continue;
                }
                ++prevFailures;
            }
        }
        throw (Nothing$)BoxedUnit.UNIT;
    }

    private Nothing$ atomicWithAlternatives(TxnExecutor exec, Function1<InTxn, Object> block) throws InterruptedException {
        Object z = this.atomicImpl(exec, block, this.takeAlternatives());
        throw new AlternativeResult(z);
    }

    private <Z> Z atomicImpl(TxnExecutor exec, Function1<InTxn, Z> block, List<Function1<InTxn, Z>> alternatives) throws InterruptedException {
        if (Stats$.MODULE$.top() != null) {
            this.recordAlternatives(alternatives);
        }
        if (this._currentLevel == null) {
            this.clearAttemptHistory();
        }
        int reusedReadThreshold = -1;
        long minRetryTimeout = Long.MAX_VALUE;
        while (true) {
            AccessHistory.UndoLog level = null;
            int prevFailures = 0;
            while (level == null) {
                Function1 & Serializable b;
                block11: {
                    if (this._currentLevel != null) {
                        this._currentLevel.requireActive();
                    }
                    boolean phantom = reusedReadThreshold >= 0;
                    level = new TxnLevelImpl(this, exec, this._currentLevel, phantom);
                    level.minRetryTimeoutNanos_$eq(minRetryTimeout);
                    try {
                        Function1 & Serializable intersect = b = phantom ? (Function1 & Serializable)_$1 -> this.atomicImpl(exec, (Function1)alternatives.head(), (List)alternatives.tail()) : block;
                        if (this._currentLevel == null) break block11;
                        return this.nestedAttempt(prevFailures, (TxnLevelImpl)level, b, reusedReadThreshold);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (!RollbackError$.MODULE$.equals(throwable2)) {
                            throw throwable;
                        }
                        if (this.isExplicitRetry(((TxnLevelImpl)level).status())) continue;
                        ++prevFailures;
                        reusedReadThreshold = -1;
                        level = null;
                        continue;
                    }
                }
                return this.topLevelAttempt(prevFailures, (TxnLevelImpl)level, b);
            }
            boolean phantom = reusedReadThreshold >= 0;
            minRetryTimeout = level.minRetryTimeoutNanos();
            if (!phantom && alternatives.nonEmpty()) {
                reusedReadThreshold = level.prevReadCount();
                continue;
            }
            level = null;
            if (this._currentLevel != null) {
                this._currentLevel.forceRollback(Txn$ExplicitRetryCause$.MODULE$.apply((Option<Object>)None$.MODULE$));
                throw RollbackError$.MODULE$;
            }
            this.awaitRetry(minRetryTimeout);
            minRetryTimeout = Long.MAX_VALUE;
            reusedReadThreshold = -1;
        }
        throw (Nothing$)BoxedUnit.UNIT;
    }

    private void recordAlternatives(List<?> alternatives) {
        (this._currentLevel == null ? Stats$.MODULE$.top() : Stats$.MODULE$.nested()).alternatives().$plus$eq(alternatives.size());
    }

    private <Z> Z nestedAttempt(int prevFailures, TxnLevelImpl level, Function1<InTxn, Z> block, int reusedReadThreshold) {
        Z z;
        this.nestedBegin(level, reusedReadThreshold);
        this.checkBarging(prevFailures);
        try {
            z = this.runBlock(block);
        }
        finally {
            this.rethrowFromStatus(this.nestedComplete());
        }
        return z;
    }

    private <Z> Z topLevelAttempt(int prevFailures, TxnLevelImpl level, Function1<InTxn, Z> block) throws InterruptedException {
        Z z;
        this.topLevelBegin(level);
        this.checkBarging(prevFailures);
        try {
            z = this.runBlock(block);
        }
        finally {
            this.rethrowFromStatus(this.topLevelComplete());
        }
        return z;
    }

    private void checkBarging(int prevFailures) {
        if (prevFailures == 0) {
            this._bargeVersion_$eq(this._readVersion);
        }
        if (prevFailures == CCSTM$.MODULE$.BargeAllThreshold()) {
            this._bargeVersion_$eq(0L);
        }
        this._barging_$eq(prevFailures >= CCSTM$.MODULE$.BargeRecentThreshold());
    }

    private void nestedBegin(TxnLevelImpl child, int reusedReadThreshold) {
        if (!this._currentLevel.pushIfActive(child)) {
            child.forceRollback(((Txn.RolledBack)this.status()).cause());
            throw RollbackError$.MODULE$;
        }
        this._currentLevel = child;
        this.checkpointCallbacks();
        this.checkpointAccessHistory(reusedReadThreshold);
    }

    private void topLevelBegin(TxnLevelImpl child) throws InterruptedException {
        if (this._slot() < 0) {
            this._priority_$eq(SimpleRandom$.MODULE$.nextInt());
            this._slot_$eq(CCSTM$.MODULE$.slotManager().assign(child, ~this._slot()));
            this._readVersion = CCSTM$.MODULE$.freshReadVersion();
        }
        this._currentLevel = child;
    }

    private <Z> Z runBlock(Function1<InTxn, Z> block) {
        Object object;
        try {
            object = block.apply((Object)this);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable x;
            Throwable throwable3 = x = (throwable2 = throwable);
            RollbackError$ rollbackError$ = RollbackError$.MODULE$;
            if ((throwable3 == null ? rollbackError$ != null : !throwable3.equals(rollbackError$)) && !this._currentLevel.executor().isControlFlow(x)) {
                this._currentLevel.forceRollback(Txn$UncaughtExceptionCause$.MODULE$.apply(x));
                object = null;
            }
            throw throwable;
        }
        return (Z)object;
    }

    private void rethrowFromStatus(Txn.Status status) {
        Txn.Status status2 = status;
        if (status2 instanceof Txn.RolledBack) {
            Txn.RolledBack rb = (Txn.RolledBack)status2;
            Txn.RollbackCause rollbackCause = rb.cause();
            if (rollbackCause instanceof Txn.UncaughtExceptionCause) {
                Throwable throwable;
                Txn.UncaughtExceptionCause uncaughtExceptionCause = Txn$UncaughtExceptionCause$.MODULE$.unapply((Txn.UncaughtExceptionCause)rollbackCause);
                Throwable x = throwable = uncaughtExceptionCause._1();
                throw x;
            }
            if (rollbackCause instanceof Txn.UnrecordedTxnCause) {
                throw RewindUnrecordedTxnError$.MODULE$;
            }
            if (rollbackCause instanceof Txn.TransientRollbackCause) {
                throw RollbackError$.MODULE$;
            }
            throw new MatchError((Object)rollbackCause);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Txn.Status nestedComplete() {
        Txn$Committed$ txn$Committed$;
        TxnLevelImpl child = this._currentLevel;
        if (child.attemptMerge()) {
            this.mergeAccessHistory();
            this._currentLevel = child.parUndo();
            txn$Committed$ = Txn$Committed$.MODULE$;
        } else {
            void var2_2;
            Txn.Status s = this.status();
            this.rollbackAccessHistory(this._slot(), ((Txn.RolledBack)s).cause());
            Function1[] handlers = this.rollbackCallbacks();
            this._currentLevel = child.parUndo();
            if (handlers != null) {
                this.fireAfterCompletionAndThrow(handlers, child.executor(), s, (Throwable)null);
            }
            txn$Committed$ = var2_2;
        }
        return txn$Committed$;
    }

    /*
     * WARNING - void declaration
     */
    private Txn.Status topLevelComplete() {
        Txn$Committed$ txn$Committed$;
        if (this.attemptTopLevelComplete()) {
            this.finishTopLevelCommit();
            txn$Committed$ = Txn$Committed$.MODULE$;
        } else {
            void var1_1;
            Txn.Status s = this.status();
            Txn.RollbackCause c = ((Txn.RolledBack)s).cause();
            if (this.isExplicitRetry(c)) {
                this.finishTopLevelRetry(s, c);
            } else {
                this.finishTopLevelRollback(s, c);
            }
            txn$Committed$ = var1_1;
        }
        return txn$Committed$;
    }

    private void finishTopLevelCommit() {
        this.resetAccessHistory();
        Function1[] handlers = this.resetCallbacks();
        TxnExecutor exec = this._currentLevel.executor();
        this.detach();
        Throwable f = this._pendingFailure;
        this._pendingFailure = null;
        this.fireAfterCompletionAndThrow(handlers, exec, (Txn.Status)Txn$Committed$.MODULE$, f);
    }

    private void finishTopLevelRollback(Txn.Status s, Txn.RollbackCause c) {
        this.rollbackAccessHistory(this._slot(), c);
        Function1[] handlers = this.rollbackCallbacks();
        TxnExecutor exec = this._currentLevel.executor();
        this.detach();
        Throwable f = this._pendingFailure;
        this._pendingFailure = null;
        this.fireAfterCompletionAndThrow(handlers, exec, s, f);
    }

    private void finishTopLevelRetry(Txn.Status s, Txn.RollbackCause c) {
        this.rollbackAccessHistory(this._slot(), c);
        Function1[] handlers = this.rollbackCallbacks();
        TxnExecutor exec = this._currentLevel.executor();
        this._currentLevel = null;
        if (this.writeCount() != 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (handlers != null) {
            this._pendingFailure = this.fireAfterCompletion(handlers, exec, s, this._pendingFailure);
        }
        if (this._pendingFailure != null) {
            this.takeRetrySet(this._slot());
            Throwable f = this._pendingFailure;
            this._pendingFailure = null;
            throw f;
        }
    }

    private void detach() {
        CCSTM$.MODULE$.slotManager().release(this._slot());
        this._slot_$eq(~this._slot());
        this._currentLevel = null;
    }

    private boolean attemptTopLevelComplete() {
        TxnLevelImpl root = this._currentLevel;
        this.fireBeforeCommitCallbacks();
        if (this.writeCount() == 0 && !this.writeResourcesPresent()) {
            if (this.bargeCount() > 0) {
                this.releaseBargeLocks();
            }
            return root.tryActiveToCommitted();
        }
        if (!root.tryActiveToPreparing() || !this.acquireLocks()) {
            return false;
        }
        long cv = CCSTM$.MODULE$.freshCommitVersion(this._readVersion);
        if (!this.revalidateImpl()) {
            return false;
        }
        this.fireWhilePreparingCallbacks();
        if (this.externalDecider() != null) {
            if (!root.tryPreparingToPrepared() || !this.consultExternalDecider()) {
                return false;
            }
            root.setCommitting();
        } else if (!root.tryPreparingToCommitting()) {
            return false;
        }
        this._pendingFailure = this.fireWhileCommittingCallbacks(this._currentLevel.executor());
        this.commitWrites(cv);
        root.setCommitted();
        return true;
    }

    private void releaseBargeLocks() {
        for (int i = this.bargeCount() - 1; i >= 0; --i) {
            this.rollbackHandle(this.bargeHandle(i), this._slot());
        }
    }

    private boolean acquireLocks() {
        for (int i = this.writeCount() - 1; i >= 0; --i) {
            Handle<?> handle = this.getWriteHandle(i);
            long m = 0L;
            do {
                if (CCSTM$.MODULE$.owner(m = handle.meta()) == this._slot() || m == CCSTM$.MODULE$.txnLocalMeta()) continue;
                return false;
            } while (!CCSTM$.MODULE$.changing(m) && !handle.metaCAS(m, CCSTM$.MODULE$.withChanging(m)));
        }
        return true;
    }

    private boolean consultExternalDecider() {
        try {
            if (!this.externalDecider().shouldCommit(this)) {
                this._currentLevel.forceRollback(Txn$OptimisticFailureCause$.MODULE$.apply(Symbol$.MODULE$.apply("external_decision"), (Option<Object>)None$.MODULE$));
            }
        }
        catch (Throwable x) {
            this._currentLevel.forceRollback(Txn$UncaughtExceptionCause$.MODULE$.apply(x));
        }
        return this.status() == Txn$Prepared$.MODULE$;
    }

    private void commitWrites(long cv) {
        int i;
        long wakeups = 0L;
        for (i = this.writeCount() - 1; i >= 0; --i) {
            Handle<?> handle = this.getWriteHandle(i);
            long m = handle.meta();
            if (CCSTM$.MODULE$.pendingWakeups(m)) {
                wakeups |= CCSTM$.MODULE$.wakeupManager().prepareToTrigger(handle);
            }
            Object v = this.getWriteSpecValue(i);
            if (this.wasWriteFreshOwner(i)) {
                handle.data_$eq(v);
                handle.meta_$eq(CCSTM$.MODULE$.withCommit(m, cv));
                continue;
            }
            handle.data_$eq(v);
        }
        for (i = this.bargeCount() - 1; i >= 0; --i) {
            Handle<?> handle = this.bargeHandle(i);
            long m = handle.meta();
            if (CCSTM$.MODULE$.changing(m)) {
                handle.meta_$eq(CCSTM$.MODULE$.withCommit(m, cv));
                continue;
            }
            this.rollbackHandle(handle, this._slot(), m);
        }
        if (wakeups != 0L) {
            CCSTM$.MODULE$.wakeupManager().trigger(wakeups);
        }
    }

    private boolean revalidateImpl() {
        for (int i = 0; i < this.readCount(); ++i) {
            Handle<?> h = this.readHandle(i);
            Symbol problem = this.checkRead(h, this.readVersion(i));
            if (problem == null) continue;
            ((NestingLevel)((Object)this.readLocate(i))).requestRollback(Txn$OptimisticFailureCause$.MODULE$.apply(problem, (Option<Object>)Some$.MODULE$.apply(h)));
            return false;
        }
        this.fireWhileValidating();
        return !(this.status() instanceof Txn.RolledBack);
    }

    private Symbol checkRead(Handle<?> handle, long ver) {
        while (true) {
            long m1 = handle.meta();
            if (!CCSTM$.MODULE$.changing(m1) || CCSTM$.MODULE$.owner(m1) == this._slot()) {
                if (CCSTM$.MODULE$.version(m1) != ver) {
                    return Symbol$.MODULE$.apply("stale_read");
                }
                return null;
            }
            if (CCSTM$.MODULE$.owner(m1) == CCSTM$.MODULE$.nonTxnSlot()) {
                return Symbol$.MODULE$.apply("read_vs_nontxn_write");
            }
            TxnLevelImpl o = CCSTM$.MODULE$.slotManager().lookup(CCSTM$.MODULE$.owner(m1));
            if (o == null) continue;
            Txn.Status s = o.status();
            long m2 = handle.meta();
            if (!CCSTM$.MODULE$.changing(m2) || CCSTM$.MODULE$.owner(m2) != CCSTM$.MODULE$.owner(m1)) continue;
            if (!(s instanceof Txn.RolledBack)) {
                return Symbol$.MODULE$.apply("read_vs_pending_commit");
            }
            CCSTM$.MODULE$.stealHandle(handle, m2, o);
        }
        throw (Nothing$)BoxedUnit.UNIT;
    }

    @Override
    public void requireActive() {
        TxnLevelImpl cur = this._currentLevel;
        if (cur == null) {
            throw new IllegalStateException("no active transaction");
        }
        cur.requireActive();
    }

    @Override
    public boolean isNewerThanReadVersion(long version) {
        return version > this._readVersion;
    }

    @Override
    public void revalidate(long minReadVersion) {
        this._readVersion = CCSTM$.MODULE$.freshReadVersion(minReadVersion);
        if (!this.revalidateImpl()) {
            throw RollbackError$.MODULE$;
        }
    }

    @Override
    public void forceRollback(Txn.RollbackCause cause) {
        this._currentLevel.forceRollback(cause);
    }

    @Override
    public void weakAwaitUnowned(Handle<?> handle, long m0) throws InterruptedException {
        CCSTM$.MODULE$.weakAwaitUnowned(handle, m0, this._currentLevel);
    }
}

