/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.Symbol$;
import scala.Tuple2;
import scala.concurrent.stm.NestingLevel;
import scala.concurrent.stm.Txn;
import scala.concurrent.stm.Txn$Active$;
import scala.concurrent.stm.Txn$OptimisticFailureCause$;
import scala.concurrent.stm.ccstm.AccessHistory;
import scala.concurrent.stm.ccstm.CCSTM$;
import scala.concurrent.stm.ccstm.Handle;
import scala.concurrent.stm.ccstm.TxnLocalImpl;
import scala.concurrent.stm.ccstm.UnrecordedRead;
import scala.concurrent.stm.skel.AbstractInTxn;
import scala.concurrent.stm.skel.CallbackList;
import scala.concurrent.stm.skel.RollbackError$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;

public abstract class InTxnRefOps
extends AccessHistory
implements AbstractInTxn {
    private Txn.ExternalDecider scala$concurrent$stm$skel$AbstractInTxn$$_decider;
    private boolean scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent;
    private CallbackList scala$concurrent$stm$skel$AbstractInTxn$$_beforeCommitList;
    private CallbackList scala$concurrent$stm$skel$AbstractInTxn$$_whileValidatingList;
    private CallbackList scala$concurrent$stm$skel$AbstractInTxn$$_whilePreparingList;
    private CallbackList scala$concurrent$stm$skel$AbstractInTxn$$_whileCommittingList;
    private CallbackList scala$concurrent$stm$skel$AbstractInTxn$$_afterCommitList;
    private CallbackList scala$concurrent$stm$skel$AbstractInTxn$$_afterRollbackList;

    public InTxnRefOps() {
        AbstractInTxn.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public Txn.ExternalDecider scala$concurrent$stm$skel$AbstractInTxn$$_decider() {
        return this.scala$concurrent$stm$skel$AbstractInTxn$$_decider;
    }

    @Override
    public boolean scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent() {
        return this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent;
    }

    public CallbackList scala$concurrent$stm$skel$AbstractInTxn$$_beforeCommitList() {
        return this.scala$concurrent$stm$skel$AbstractInTxn$$_beforeCommitList;
    }

    public CallbackList scala$concurrent$stm$skel$AbstractInTxn$$_whileValidatingList() {
        return this.scala$concurrent$stm$skel$AbstractInTxn$$_whileValidatingList;
    }

    public CallbackList scala$concurrent$stm$skel$AbstractInTxn$$_whilePreparingList() {
        return this.scala$concurrent$stm$skel$AbstractInTxn$$_whilePreparingList;
    }

    public CallbackList scala$concurrent$stm$skel$AbstractInTxn$$_whileCommittingList() {
        return this.scala$concurrent$stm$skel$AbstractInTxn$$_whileCommittingList;
    }

    public CallbackList scala$concurrent$stm$skel$AbstractInTxn$$_afterCommitList() {
        return this.scala$concurrent$stm$skel$AbstractInTxn$$_afterCommitList;
    }

    public CallbackList scala$concurrent$stm$skel$AbstractInTxn$$_afterRollbackList() {
        return this.scala$concurrent$stm$skel$AbstractInTxn$$_afterRollbackList;
    }

    @Override
    public void scala$concurrent$stm$skel$AbstractInTxn$$_decider_$eq(Txn.ExternalDecider x$1) {
        this.scala$concurrent$stm$skel$AbstractInTxn$$_decider = x$1;
    }

    @Override
    public void scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent_$eq(boolean x$1) {
        this.scala$concurrent$stm$skel$AbstractInTxn$$_callbacksPresent = x$1;
    }

    @Override
    public void scala$concurrent$stm$skel$AbstractInTxn$_setter_$scala$concurrent$stm$skel$AbstractInTxn$$_beforeCommitList_$eq(CallbackList x$0) {
        this.scala$concurrent$stm$skel$AbstractInTxn$$_beforeCommitList = x$0;
    }

    @Override
    public void scala$concurrent$stm$skel$AbstractInTxn$_setter_$scala$concurrent$stm$skel$AbstractInTxn$$_whileValidatingList_$eq(CallbackList x$0) {
        this.scala$concurrent$stm$skel$AbstractInTxn$$_whileValidatingList = x$0;
    }

    @Override
    public void scala$concurrent$stm$skel$AbstractInTxn$_setter_$scala$concurrent$stm$skel$AbstractInTxn$$_whilePreparingList_$eq(CallbackList x$0) {
        this.scala$concurrent$stm$skel$AbstractInTxn$$_whilePreparingList = x$0;
    }

    @Override
    public void scala$concurrent$stm$skel$AbstractInTxn$_setter_$scala$concurrent$stm$skel$AbstractInTxn$$_whileCommittingList_$eq(CallbackList x$0) {
        this.scala$concurrent$stm$skel$AbstractInTxn$$_whileCommittingList = x$0;
    }

    @Override
    public void scala$concurrent$stm$skel$AbstractInTxn$_setter_$scala$concurrent$stm$skel$AbstractInTxn$$_afterCommitList_$eq(CallbackList x$0) {
        this.scala$concurrent$stm$skel$AbstractInTxn$$_afterCommitList = x$0;
    }

    @Override
    public void scala$concurrent$stm$skel$AbstractInTxn$_setter_$scala$concurrent$stm$skel$AbstractInTxn$$_afterRollbackList_$eq(CallbackList x$0) {
        this.scala$concurrent$stm$skel$AbstractInTxn$$_afterRollbackList = x$0;
    }

    public abstract boolean _barging();

    public abstract long _bargeVersion();

    public abstract int _slot();

    public abstract boolean isNewerThanReadVersion(long var1);

    public abstract void revalidate(long var1);

    public abstract void forceRollback(Txn.RollbackCause var1);

    public abstract void weakAwaitUnowned(Handle<?> var1, long var2);

    private void revalidateIfRequired(long version) {
        if (this.isNewerThanReadVersion(version)) {
            this.revalidate(version);
        }
    }

    private long acquireOwnership(Handle<?> handle) throws InterruptedException {
        long m = handle.meta();
        if (CCSTM$.MODULE$.owner(m) == this._slot()) {
            return m;
        }
        while (true) {
            if (CCSTM$.MODULE$.owner(m) != CCSTM$.MODULE$.unownedSlot()) {
                this.weakAwaitUnowned(handle, m);
            } else if (handle.metaCAS(m, CCSTM$.MODULE$.withOwner(m, this._slot()))) {
                return m;
            }
            m = handle.meta();
        }
        throw (Nothing$)BoxedUnit.UNIT;
    }

    private boolean tryAcquireOwnership(Handle<?> handle, long m0) {
        return CCSTM$.MODULE$.owner(m0) == CCSTM$.MODULE$.unownedSlot() && handle.metaCAS(m0, CCSTM$.MODULE$.withOwner(m0, this._slot()));
    }

    public <T> T get(Handle<T> handle) throws InterruptedException {
        this.requireActive();
        long m1 = handle.meta();
        if (CCSTM$.MODULE$.owner(m1) == this._slot()) {
            return this.stableGet(handle);
        }
        if (this.readShouldBarge(m1)) {
            return this.bargingRead(handle);
        }
        long m0 = 0L;
        T value = null;
        do {
            m0 = m1;
            while (CCSTM$.MODULE$.changing(m0)) {
                this.weakAwaitUnowned(handle, m0);
                m0 = handle.meta();
            }
            this.revalidateIfRequired(CCSTM$.MODULE$.version(m0));
            value = handle.data();
            m1 = handle.meta();
        } while (CCSTM$.MODULE$.changingAndVersion(m0) != CCSTM$.MODULE$.changingAndVersion(m1));
        this.recordRead(handle, CCSTM$.MODULE$.version(m1));
        return value;
    }

    private boolean readShouldBarge(long meta) {
        return this._barging() && CCSTM$.MODULE$.version(meta) >= this._bargeVersion();
    }

    private <T> T bargingRead(Handle<T> handle) throws InterruptedException {
        long mPrev = this.acquireOwnership(handle);
        this.recordBarge(handle);
        this.revalidateIfRequired(CCSTM$.MODULE$.version(mPrev));
        return handle.data();
    }

    public <T, Z> Z getWith(Handle<T> handle, Function1<T, Z> f) throws InterruptedException {
        if (this._barging() && CCSTM$.MODULE$.version(handle.meta()) >= this._bargeVersion()) {
            return (Z)f.apply(this.get(handle));
        }
        this.requireActive();
        UnrecordedRead<T> u = this.unrecordedRead(handle);
        Object result = f.apply(u.value());
        if (!u.recorded()) {
            Function1<NestingLevel, BoxedUnit> callback = new Function1<NestingLevel, BoxedUnit>(handle, f, u, result, this){
                private final Handle handle$1;
                private final Function1 f$1;
                private final Object result$1;
                private UnrecordedRead _latestRead;
                private final InTxnRefOps $outer;
                {
                    this.handle$1 = handle$1;
                    this.f$1 = f$1;
                    this.result$1 = result$1;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this._latestRead = u$1;
                }

                public UnrecordedRead _latestRead() {
                    return this._latestRead;
                }

                public void _latestRead_$eq(UnrecordedRead x$1) {
                    this._latestRead = x$1;
                }

                public void apply(NestingLevel level) {
                    if (!this.isValid()) {
                        level.requestRollback(Txn$OptimisticFailureCause$.MODULE$.apply(Symbol$.MODULE$.apply("invalid_getWith"), (Option<Object>)Some$.MODULE$.apply((Object)this.handle$1)));
                    }
                }

                private boolean isValid() {
                    if (this._latestRead() == null || this._latestRead().stillValid()) {
                        return true;
                    }
                    long m1 = this.handle$1.meta();
                    if (CCSTM$.MODULE$.owner(m1) == this.$outer._slot()) {
                        this._latestRead_$eq(null);
                        return BoxesRunTime.equals((Object)this.result$1, (Object)this.f$1.apply(this.handle$1.data()));
                    }
                    this._latestRead_$eq(this.$outer.unrecordedRead(this.handle$1));
                    return BoxesRunTime.equals((Object)this.result$1, (Object)this.f$1.apply(this._latestRead().value()));
                }
            };
            this.whileValidating((Function1)callback);
        }
        return (Z)result;
    }

    public <T> T relaxedGet(Handle<T> handle, Function2<T, T, Object> equiv) throws InterruptedException {
        if (this._barging() && CCSTM$.MODULE$.version(handle.meta()) >= this._bargeVersion()) {
            return this.get(handle);
        }
        this.requireActive();
        UnrecordedRead<T> u = this.unrecordedRead(handle);
        T snapshot = u.value();
        if (!u.recorded()) {
            Function1<NestingLevel, BoxedUnit> callback = new Function1<NestingLevel, BoxedUnit>(handle, equiv, u, snapshot, this){
                private final Handle handle$1;
                private final Function2 equiv$1;
                private final Object snapshot$1;
                private UnrecordedRead _latestRead;
                private final InTxnRefOps $outer;
                {
                    this.handle$1 = handle$3;
                    this.equiv$1 = equiv$1;
                    this.snapshot$1 = snapshot$1;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this._latestRead = u$2;
                }

                public UnrecordedRead _latestRead() {
                    return this._latestRead;
                }

                public void _latestRead_$eq(UnrecordedRead x$1) {
                    this._latestRead = x$1;
                }

                public void apply(NestingLevel level) {
                    if (!this.isValid()) {
                        level.requestRollback(Txn$OptimisticFailureCause$.MODULE$.apply(Symbol$.MODULE$.apply("invalid_relaxed_get"), (Option<Object>)Some$.MODULE$.apply((Object)this.handle$1)));
                    }
                }

                private boolean isValid() {
                    if (this._latestRead() == null || this._latestRead().stillValid()) {
                        return true;
                    }
                    long m1 = this.handle$1.meta();
                    if (CCSTM$.MODULE$.owner(m1) == this.$outer._slot()) {
                        this._latestRead_$eq(null);
                        return BoxesRunTime.unboxToBoolean((Object)this.equiv$1.apply(this.snapshot$1, this.handle$1.data()));
                    }
                    this._latestRead_$eq(this.$outer.unrecordedRead(this.handle$1));
                    return BoxesRunTime.unboxToBoolean((Object)this.equiv$1.apply(this.snapshot$1, this._latestRead().value()));
                }
            };
            this.whileValidating((Function1)callback);
        }
        return snapshot;
    }

    public <T> UnrecordedRead<T> unrecordedRead(Handle<T> handle) throws InterruptedException {
        boolean bl;
        this.requireNotDecided();
        LongRef m1 = LongRef.create((long)handle.meta());
        ObjectRef v = ObjectRef.create(null);
        if (CCSTM$.MODULE$.owner(m1.elem) == this._slot()) {
            T t = this.stableGet(handle);
            v.elem = t;
            bl = true;
        } else {
            long m0 = 0L;
            do {
                long l;
                m0 = m1.elem;
                while (CCSTM$.MODULE$.changing(m0)) {
                    Txn.Status status = this.status();
                    Txn$Active$ txn$Active$ = Txn$Active$.MODULE$;
                    if (status == null ? txn$Active$ != null : !status.equals(txn$Active$)) {
                        this.forceRollback(Txn$OptimisticFailureCause$.MODULE$.apply(Symbol$.MODULE$.apply("late_invalid_unrecordedRead"), (Option<Object>)Some$.MODULE$.apply(handle)));
                        throw RollbackError$.MODULE$;
                    }
                    this.weakAwaitUnowned(handle, m0);
                    m0 = handle.meta();
                }
                if (this.isNewerThanReadVersion(CCSTM$.MODULE$.version(m0))) {
                    Txn.Status status = this.status();
                    Txn$Active$ txn$Active$ = Txn$Active$.MODULE$;
                    if (status == null ? txn$Active$ != null : !status.equals(txn$Active$)) {
                        this.forceRollback(Txn$OptimisticFailureCause$.MODULE$.apply(Symbol$.MODULE$.apply("late_invalid_unrecordedRead"), (Option<Object>)Some$.MODULE$.apply(handle)));
                        throw RollbackError$.MODULE$;
                    }
                    this.revalidate(CCSTM$.MODULE$.version(m0));
                }
                T t = handle.data();
                v.elem = t;
                m1.elem = l = handle.meta();
            } while (CCSTM$.MODULE$.changingAndVersion(m0) != CCSTM$.MODULE$.changingAndVersion(m1.elem));
            bl = false;
        }
        boolean rec = bl;
        return new UnrecordedRead<T>(handle, m1, v, rec, this){
            private final Handle handle$1;
            private final LongRef m1$1;
            private final ObjectRef v$1;
            private final boolean rec$1;
            private final InTxnRefOps $outer;
            {
                this.handle$1 = handle$8;
                this.m1$1 = m1$2;
                this.v$1 = v$2;
                this.rec$1 = rec$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object value() {
                return this.v$1.elem;
            }

            public boolean stillValid() {
                long m = this.handle$1.meta();
                return CCSTM$.MODULE$.version(m) == CCSTM$.MODULE$.version(this.m1$1.elem) && (!CCSTM$.MODULE$.changing(m) || CCSTM$.MODULE$.owner(m) == this.$outer._slot());
            }

            public boolean recorded() {
                return this.rec$1;
            }
        };
    }

    private boolean freshOwner(long mPrev) {
        return CCSTM$.MODULE$.owner(mPrev) == CCSTM$.MODULE$.unownedSlot();
    }

    public <T> void set(Handle<T> handle, T v) throws InterruptedException {
        this.requireActive();
        long mPrev = this.acquireOwnership(handle);
        boolean f = this.freshOwner(mPrev);
        this.put(handle, f, v);
        if (f) {
            this.revalidateIfRequired(CCSTM$.MODULE$.version(mPrev));
        }
    }

    public <T> T swap(Handle<T> handle, T v) throws InterruptedException {
        this.requireActive();
        long mPrev = this.acquireOwnership(handle);
        boolean f = this.freshOwner(mPrev);
        T v0 = this.swap(handle, f, v);
        if (f) {
            this.revalidateIfRequired(CCSTM$.MODULE$.version(mPrev));
        }
        return v0;
    }

    public <T> boolean trySet(Handle<T> handle, T v) {
        this.requireActive();
        long m0 = handle.meta();
        if (CCSTM$.MODULE$.owner(m0) == this._slot()) {
            this.put(handle, false, v);
            return true;
        }
        if (!this.tryAcquireOwnership(handle, m0)) {
            return false;
        }
        this.put(handle, true, v);
        this.revalidateIfRequired(CCSTM$.MODULE$.version(m0));
        return true;
    }

    public <T> boolean compareAndSet(Handle<T> handle, T before, T after) throws InterruptedException {
        return this.transformIfDefined(handle, new PartialFunction<T, T>(before, after){
            private final Object before$1;
            private final Object after$1;
            {
                this.before$1 = before$3;
                this.after$1 = after$3;
                PartialFunction.$init$((PartialFunction)this);
            }

            public boolean isDefinedAt(Object v) {
                return BoxesRunTime.equals((Object)this.before$1, (Object)v);
            }

            public Object apply(Object v) {
                return this.after$1;
            }
        });
    }

    public <T, R extends T> boolean compareAndSetIdentity(Handle<T> handle, R before, T after) throws InterruptedException {
        return before == handle.data() ? this.acquiringCASI(handle, before, after) : this.unrecordedCASI(handle, before, after);
    }

    private <T, R extends T> boolean acquiringCASI(Handle<T> handle, R before, T after) throws InterruptedException {
        this.requireActive();
        long mPrev = this.acquireOwnership(handle);
        boolean f = this.freshOwner(mPrev);
        boolean z = this.compareAndSetIdentity(handle, f, before, after);
        if (f) {
            this.revalidateIfRequired(CCSTM$.MODULE$.version(mPrev));
        }
        return z;
    }

    private <T, R extends T> boolean unrecordedCASI(Handle<T> handle, R before, T after) throws InterruptedException {
        return this.transformIfDefined(handle, new PartialFunction<T, T>(before, after){
            private final Object before$1;
            private final Object after$1;
            {
                this.before$1 = before$4;
                this.after$1 = after$4;
                PartialFunction.$init$((PartialFunction)this);
            }

            public boolean isDefinedAt(Object v) {
                return this.before$1 == v;
            }

            public Object apply(Object v) {
                return this.after$1;
            }
        });
    }

    public <T> T getAndTransform(Handle<T> handle, Function1<T, T> func) throws InterruptedException {
        this.requireActive();
        long mPrev = this.acquireOwnership(handle);
        boolean f = this.freshOwner(mPrev);
        T v0 = this.getAndTransform(handle, f, func);
        if (f) {
            this.revalidateIfRequired(CCSTM$.MODULE$.version(mPrev));
        }
        return v0;
    }

    public <T> T transformAndGet(Handle<T> handle, Function1<T, T> func) throws InterruptedException {
        this.requireActive();
        long mPrev = this.acquireOwnership(handle);
        boolean f = this.freshOwner(mPrev);
        T v1 = this.transformAndGet(handle, f, func);
        if (f) {
            this.revalidateIfRequired(CCSTM$.MODULE$.version(mPrev));
        }
        return v1;
    }

    public <T, V> V transformAndExtract(Handle<T> handle, Function1<T, Tuple2<T, V>> func) throws InterruptedException {
        this.requireActive();
        long mPrev = this.acquireOwnership(handle);
        boolean f = this.freshOwner(mPrev);
        V v1 = this.transformAndExtract(handle, f, func);
        if (f) {
            this.revalidateIfRequired(CCSTM$.MODULE$.version(mPrev));
        }
        return v1;
    }

    public <T> boolean transformIfDefined(Handle<T> handle, PartialFunction<T, T> pf) throws InterruptedException {
        boolean bl;
        this.requireActive();
        UnrecordedRead<T> u = this.unrecordedRead(handle);
        if (!pf.isDefinedAt(u.value())) {
            if (!u.recorded()) {
                Function1<NestingLevel, BoxedUnit> callback = new Function1<NestingLevel, BoxedUnit>(handle, pf, u, this){
                    private final Handle handle$1;
                    private final PartialFunction pf$1;
                    private UnrecordedRead _latestRead;
                    private final InTxnRefOps $outer;
                    {
                        this.handle$1 = handle$6;
                        this.pf$1 = pf$1;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this._latestRead = u$3;
                    }

                    public UnrecordedRead _latestRead() {
                        return this._latestRead;
                    }

                    public void _latestRead_$eq(UnrecordedRead x$1) {
                        this._latestRead = x$1;
                    }

                    public void apply(NestingLevel level) {
                        if (!this.isValid()) {
                            level.requestRollback(Txn$OptimisticFailureCause$.MODULE$.apply(Symbol$.MODULE$.apply("invalid_getWith"), (Option<Object>)Some$.MODULE$.apply((Object)this.handle$1)));
                        }
                    }

                    private boolean isValid() {
                        boolean bl;
                        if (!this._latestRead().stillValid()) {
                            this._latestRead_$eq(this.$outer.unrecordedRead(this.handle$1));
                            bl = !this.pf$1.isDefinedAt(this._latestRead().value());
                        } else {
                            bl = true;
                        }
                        return bl;
                    }
                };
                this.whileValidating((Function1)callback);
            }
            bl = false;
        } else {
            T v = this.get(handle);
            if (!u.stillValid() && !pf.isDefinedAt(v)) {
                bl = false;
            } else {
                this.set(handle, pf.apply(v));
                bl = true;
            }
        }
        return bl;
    }

    public int getAndAdd(Handle<Object> handle, int delta) throws InterruptedException {
        this.requireActive();
        long mPrev = this.acquireOwnership(handle);
        boolean f = this.freshOwner(mPrev);
        int v0 = this.getAndAdd(handle, f, delta);
        if (f) {
            this.revalidateIfRequired(CCSTM$.MODULE$.version(mPrev));
        }
        return v0;
    }

    public int txnLocalFind(TxnLocalImpl<?> local) {
        return this.findWrite(local);
    }

    public <T> T txnLocalGet(int index) {
        return this.getWriteSpecValue(index);
    }

    public <T> void txnLocalInsert(TxnLocalImpl<T> local, T v) {
        this.writeAppend(local, false, v);
    }

    public <T> void txnLocalUpdate(int index, T v) {
        this.writeUpdate(index, v);
    }
}

