/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import java.util.concurrent.TimeUnit;
import scala.concurrent.stm.ccstm.CCSTM$;
import scala.concurrent.stm.ccstm.Handle;
import scala.concurrent.stm.ccstm.Stats$;
import scala.concurrent.stm.ccstm.WakeupManager;
import scala.math.package$;

public class RetrySet {
    private final int size;
    private final Handle<?>[] handles;
    private final long[] versions;

    public RetrySet(int size, Handle<?>[] handles, long[] versions) {
        this.size = size;
        this.handles = handles;
        this.versions = versions;
    }

    public int size() {
        return this.size;
    }

    public long awaitRetry(long timeoutNanos) throws InterruptedException {
        if (this.size() == 0 && timeoutNanos == Long.MAX_VALUE) {
            throw new IllegalStateException("explicit retries cannot succeed because cumulative read set is empty");
        }
        long begin = System.nanoTime();
        long d = begin + timeoutNanos;
        long deadline = d < 0L ? Long.MAX_VALUE : d;
        this.attemptAwait(deadline);
        long actualElapsed = System.nanoTime() - begin;
        if (Stats$.MODULE$.top() != null) {
            Stats$.MODULE$.top().retrySet().$plus$eq(this.size());
            long millis = TimeUnit.NANOSECONDS.toMillis(actualElapsed);
            Stats$.MODULE$.top().retryWaitElapsed().$plus$eq((int)millis);
        }
        return package$.MODULE$.min(actualElapsed, deadline - begin);
    }

    private boolean attemptAwait(long nanoDeadline) throws InterruptedException {
        int spins = 0;
        while (this.size() > 0 && spins < CCSTM$.MODULE$.SpinCount() + CCSTM$.MODULE$.YieldCount()) {
            if (this.changed()) {
                return true;
            }
            if ((spins += this.size()) <= CCSTM$.MODULE$.SpinCount()) continue;
            Thread.yield();
            if (nanoDeadline == Long.MAX_VALUE || System.nanoTime() <= nanoDeadline) continue;
            return false;
        }
        return this.blockingAttemptAwait(nanoDeadline, this.blockingAttemptAwait$default$2(), this.blockingAttemptAwait$default$3());
    }

    private boolean blockingAttemptAwait(long nanoDeadline, WakeupManager.Event event, int i) throws InterruptedException {
        boolean bl;
        RetrySet retrySet = this;
        int n = i;
        while (true) {
            if (n < 0) {
                if (!event.tryAwaitUntil(nanoDeadline)) {
                    bl = false;
                    break;
                }
                if (!retrySet.changed()) continue;
                bl = true;
                break;
            }
            Handle<?> h = retrySet.handles[n];
            if (!event.addSource(h)) {
                if (!retrySet.changed()) continue;
                bl = true;
                break;
            }
            if (!retrySet.addPendingWakeup(h, retrySet.versions[n])) {
                bl = true;
                break;
            }
            RetrySet retrySet2 = retrySet;
            int n2 = n - 1;
            retrySet = retrySet2;
            n = n2;
        }
        return bl;
    }

    private WakeupManager.Event blockingAttemptAwait$default$2() {
        return CCSTM$.MODULE$.wakeupManager().subscribe();
    }

    private int blockingAttemptAwait$default$3() {
        return this.size() - 1;
    }

    private boolean addPendingWakeup(Handle<?> handle, long ver) {
        boolean bl;
        RetrySet retrySet = this;
        while (true) {
            long m;
            if (CCSTM$.MODULE$.changing(m = handle.meta()) || CCSTM$.MODULE$.version(m) != ver) {
                bl = false;
                break;
            }
            if (!CCSTM$.MODULE$.pendingWakeups(m) && !handle.metaCAS(m, CCSTM$.MODULE$.withPendingWakeups(m))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean changed() {
        for (int i = this.size() - 1; i >= 0; --i) {
            long m = this.handles[i].meta();
            if (!CCSTM$.MODULE$.changing(m) && CCSTM$.MODULE$.version(m) == this.versions[i]) continue;
            return true;
        }
        return false;
    }
}

