/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import scala.concurrent.stm.ccstm.CCSTM$;
import scala.concurrent.stm.ccstm.Handle;
import scala.concurrent.stm.ccstm.RetrySet;

public final class RetrySetBuilder {
    private int _size;
    private Handle<?>[] _handles;
    private long[] _versions;
    private int[] _next;
    private int[] _dispatch;

    public RetrySetBuilder() {
        int InitialCap = 16;
        this._size = 0;
        this._handles = new Handle[this.maxSizeForCap(16) + 1];
        this._versions = new long[this.maxSizeForCap(16) + 1];
        this._next = new int[this.maxSizeForCap(16) + 1];
        this._dispatch = new int[16];
    }

    private int maxSizeForCap(int cap) {
        return cap - cap / 4;
    }

    public int size() {
        return this._size;
    }

    public void $plus$eq(Handle<?> handle, long version) {
        int slot = CCSTM$.MODULE$.hash(handle.base(), handle.offset()) & this._dispatch.length - 1;
        this.addImpl(slot, this._dispatch[slot], handle, version);
    }

    private void addImpl(int slot, int i, Handle<?> handle, long version) {
        RetrySetBuilder retrySetBuilder = this;
        int n = i;
        while (true) {
            if (n == 0) {
                retrySetBuilder.append(slot, handle, version);
                break;
            }
            if (retrySetBuilder.hEq(retrySetBuilder._handles[n - 1], handle)) break;
            RetrySetBuilder retrySetBuilder2 = retrySetBuilder;
            int n2 = retrySetBuilder._next[n - 1];
            retrySetBuilder = retrySetBuilder2;
            n = n2;
        }
    }

    private void append(int slot, Handle<?> handle, long version) {
        int i;
        this._size = i = this._size + 1;
        this._handles[i - 1] = handle;
        this._versions[i - 1] = version;
        this._next[i - 1] = this._dispatch[slot];
        this._dispatch[slot] = i;
        if (this._size > this.maxSizeForCap(this._dispatch.length)) {
            this.grow();
        }
    }

    private void grow() {
        int s = this._size;
        Handle<?>[] hh = this._handles;
        long[] vv = this._versions;
        this._size = 0;
        int c = this._dispatch.length * 2;
        this._handles = new Handle[this.maxSizeForCap(c) + 1];
        this._versions = new long[this.maxSizeForCap(c) + 1];
        this._next = new int[this.maxSizeForCap(c) + 1];
        this._dispatch = new int[c];
        for (int i = 0; i < s; ++i) {
            Handle<?> h = hh[i];
            this.append(CCSTM$.MODULE$.hash(h.base(), h.offset()) & c - 1, h, vv[i]);
        }
    }

    private boolean hEq(Handle<?> a, Handle<?> b) {
        return a == b || a.base() == b.base() && a.offset() == b.offset();
    }

    public RetrySet result() {
        this._dispatch = null;
        this._next = null;
        return new RetrySet(this._size, this._handles, this._versions);
    }
}

