/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import scala.Function0;
import scala.concurrent.package$;
import scala.concurrent.stm.CommitBarrier$MemberCycle$;
import scala.concurrent.stm.Txn;
import scala.concurrent.stm.Txn$Active$;
import scala.concurrent.stm.Txn$Committed$;
import scala.concurrent.stm.Txn$Committing$;
import scala.concurrent.stm.Txn$Prepared$;
import scala.concurrent.stm.Txn$Preparing$;
import scala.concurrent.stm.Txn$RolledBack$;
import scala.concurrent.stm.TxnExecutor;
import scala.concurrent.stm.ccstm.AccessHistory;
import scala.concurrent.stm.ccstm.CommitBarrierImpl;
import scala.concurrent.stm.ccstm.InTxnImpl;
import scala.concurrent.stm.ccstm.InTxnImpl$;
import scala.concurrent.stm.ccstm.Stats$;
import scala.concurrent.stm.ccstm.TxnLevelImpl$;
import scala.concurrent.stm.skel.AbstractNestingLevel;
import scala.concurrent.stm.skel.RollbackError$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.java8.JFunction0;

public class TxnLevelImpl
extends AccessHistory.UndoLog
implements AbstractNestingLevel {
    private int _beforeCommitSize;
    private int _whileValidatingSize;
    private int _whilePreparingSize;
    private int _whileCommittingSize;
    private int _afterCommitSize;
    private int _afterRollbackSize;
    private final InTxnImpl txn;
    private final TxnExecutor executor;
    private final TxnLevelImpl parUndo;
    private final boolean phantom;
    private final AbstractNestingLevel parLevel;
    private final AbstractNestingLevel root;
    private volatile TxnLevelImpl _blockedBy;
    private volatile Object _state;
    private volatile boolean _waiters;

    public static void addBlockedBarrierMember(InTxnImpl inTxnImpl, TxnLevelImpl txnLevelImpl) {
        TxnLevelImpl$.MODULE$.addBlockedBarrierMember(inTxnImpl, txnLevelImpl);
    }

    public static void notifyBlockedBarrierMembers() {
        TxnLevelImpl$.MODULE$.notifyBlockedBarrierMembers();
    }

    public static void removeBlockedBarrierMember(InTxnImpl inTxnImpl) {
        TxnLevelImpl$.MODULE$.removeBlockedBarrierMember(inTxnImpl);
    }

    public TxnLevelImpl(InTxnImpl txn, TxnExecutor executor, TxnLevelImpl parUndo, boolean phantom) {
        this.txn = txn;
        this.executor = executor;
        this.parUndo = parUndo;
        this.phantom = phantom;
        AbstractNestingLevel.$init$(this);
        this.parLevel = parUndo == null || !parUndo.phantom() ? parUndo : parUndo.parLevel();
        this.root = this.parLevel() == null ? this : this.parLevel().root();
        this._blockedBy = null;
        this._state = null;
        this._waiters = false;
    }

    @Override
    public int _beforeCommitSize() {
        return this._beforeCommitSize;
    }

    @Override
    public int _whileValidatingSize() {
        return this._whileValidatingSize;
    }

    @Override
    public int _whilePreparingSize() {
        return this._whilePreparingSize;
    }

    @Override
    public int _whileCommittingSize() {
        return this._whileCommittingSize;
    }

    @Override
    public int _afterCommitSize() {
        return this._afterCommitSize;
    }

    @Override
    public int _afterRollbackSize() {
        return this._afterRollbackSize;
    }

    @Override
    public void _beforeCommitSize_$eq(int x$1) {
        this._beforeCommitSize = x$1;
    }

    @Override
    public void _whileValidatingSize_$eq(int x$1) {
        this._whileValidatingSize = x$1;
    }

    @Override
    public void _whilePreparingSize_$eq(int x$1) {
        this._whilePreparingSize = x$1;
    }

    @Override
    public void _whileCommittingSize_$eq(int x$1) {
        this._whileCommittingSize = x$1;
    }

    @Override
    public void _afterCommitSize_$eq(int x$1) {
        this._afterCommitSize = x$1;
    }

    @Override
    public void _afterRollbackSize_$eq(int x$1) {
        this._afterRollbackSize = x$1;
    }

    @Override
    public InTxnImpl txn() {
        return this.txn;
    }

    @Override
    public TxnExecutor executor() {
        return this.executor;
    }

    @Override
    public TxnLevelImpl parUndo() {
        return this.parUndo;
    }

    public boolean phantom() {
        return this.phantom;
    }

    @Override
    public AbstractNestingLevel parLevel() {
        return this.parLevel;
    }

    @Override
    public AbstractNestingLevel root() {
        return this.root;
    }

    private TxnLevelImpl _blockedBy() {
        return this._blockedBy;
    }

    private void _blockedBy_$eq(TxnLevelImpl x$0) {
        this._blockedBy = x$0;
    }

    private Object _state() {
        return this._state;
    }

    private void _state_$eq(Object x$0) {
        this._state = x$0;
    }

    public AtomicReferenceFieldUpdater<TxnLevelImpl, Object> scala$concurrent$stm$ccstm$TxnLevelImpl$$newStateUpdater() {
        return AtomicReferenceFieldUpdater.newUpdater(TxnLevelImpl.class, Object.class, "_state");
    }

    public final long minEnclosingRetryTimeout(long accum) {
        long z;
        TxnLevelImpl txnLevelImpl = this;
        long l = accum;
        while (true) {
            z = scala.math.package$.MODULE$.min(l, BoxesRunTime.unboxToLong((Object)txnLevelImpl.executor().retryTimeoutNanos().getOrElse(TxnLevelImpl::$anonfun$1)));
            if (txnLevelImpl.parUndo() == null) break;
            TxnLevelImpl txnLevelImpl2 = txnLevelImpl.parUndo();
            long l2 = z;
            txnLevelImpl = txnLevelImpl2;
            l = l2;
        }
        return z;
    }

    public long minEnclosingRetryTimeout$default$1() {
        return Long.MAX_VALUE;
    }

    @Override
    public final Txn.Status status() {
        Txn.Status status;
        block2: {
            Object raw;
            TxnLevelImpl txnLevelImpl = this;
            while (true) {
                if ((raw = txnLevelImpl._state()) == null) {
                    status = Txn$Active$.MODULE$;
                    break block2;
                }
                if (raw != "merged") break;
                txnLevelImpl = txnLevelImpl.parUndo();
            }
            status = raw instanceof TxnLevelImpl ? Txn$Active$.MODULE$ : (Txn.Status)raw;
        }
        return status;
    }

    public void setCommitting() {
        this._state_$eq(Txn$Committing$.MODULE$);
    }

    public void setCommitted() {
        this._state_$eq(Txn$Committed$.MODULE$);
        this.notifyCompleted();
    }

    /*
     * WARNING - void declaration
     */
    public boolean tryActiveToCommitted() {
        void var1_1;
        boolean f = TxnLevelImpl$.scala$concurrent$stm$ccstm$TxnLevelImpl$$$stateUpdater.compareAndSet(this, null, Txn$Committed$.MODULE$);
        if (f) {
            this.notifyCompleted();
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean tryActiveToPreparing() {
        void var1_1;
        boolean f = TxnLevelImpl$.scala$concurrent$stm$ccstm$TxnLevelImpl$$$stateUpdater.compareAndSet(this, null, Txn$Preparing$.MODULE$);
        if (f && this.txn().commitBarrier() != null) {
            TxnLevelImpl$.MODULE$.notifyBlockedBarrierMembers();
        }
        return (boolean)var1_1;
    }

    public boolean tryPreparingToPrepared() {
        return TxnLevelImpl$.scala$concurrent$stm$ccstm$TxnLevelImpl$$$stateUpdater.compareAndSet(this, Txn$Preparing$.MODULE$, Txn$Prepared$.MODULE$);
    }

    public boolean tryPreparingToCommitting() {
        return TxnLevelImpl$.scala$concurrent$stm$ccstm$TxnLevelImpl$$$stateUpdater.compareAndSet(this, Txn$Preparing$.MODULE$, Txn$Committing$.MODULE$);
    }

    public Txn.Status statusAsCurrent() {
        Object raw = this._state();
        return raw == null ? Txn$Active$.MODULE$ : (Txn.Status)raw;
    }

    private void notifyCompleted() {
        if (this._waiters) {
            TxnLevelImpl txnLevelImpl = this;
            synchronized (txnLevelImpl) {
                this.notifyAll();
            }
        }
    }

    private boolean hasMemberCycle(CommitBarrierImpl cb, TxnLevelImpl src) {
        boolean bl;
        TxnLevelImpl txnLevelImpl = this;
        TxnLevelImpl txnLevelImpl2 = src;
        while (true) {
            if (txnLevelImpl2._state() instanceof Txn.RolledBack) {
                bl = false;
                break;
            }
            TxnLevelImpl next = txnLevelImpl2._blockedBy();
            if (next == null) {
                CommitBarrierImpl commitBarrierImpl = txnLevelImpl2.txn().commitBarrier();
                CommitBarrierImpl commitBarrierImpl2 = cb;
                if (!(commitBarrierImpl != null ? !commitBarrierImpl.equals(commitBarrierImpl2) : commitBarrierImpl2 != null)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            TxnLevelImpl txnLevelImpl3 = txnLevelImpl;
            TxnLevelImpl txnLevelImpl4 = next;
            txnLevelImpl = txnLevelImpl3;
            txnLevelImpl2 = txnLevelImpl4;
        }
        return bl;
    }

    private boolean isRolledBack() {
        return this._state() instanceof Txn.RolledBack;
    }

    public void awaitCompleted(TxnLevelImpl waiter, Object debugInfo) throws InterruptedException {
        block14: {
            if (this.parUndo() != null) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            this._waiters = true;
            if (Stats$.MODULE$.top() != null) {
                Stats$.MODULE$.top().blockingAcquires().$plus$eq(1);
            }
            if (waiter != null) {
                CommitBarrierImpl cb = waiter.txn().commitBarrier();
                try {
                    waiter._blockedBy_$eq(this);
                    TxnLevelImpl$.MODULE$.notifyBlockedBarrierMembers();
                    if (cb != null) {
                        TxnLevelImpl$.MODULE$.addBlockedBarrierMember(waiter.txn(), this);
                    }
                    TxnLevelImpl txnLevelImpl = this;
                    synchronized (txnLevelImpl) {
                        BoxedUnit boxedUnit = !this.status().completed() && !waiter.isRolledBack() ? (BoxedUnit)package$.MODULE$.blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.awaitCompleted$$anonfun$1(waiter, debugInfo, cb))) : BoxedUnit.UNIT;
                        break block14;
                    }
                }
                finally {
                    if (cb != null) {
                        TxnLevelImpl$.MODULE$.removeBlockedBarrierMember(waiter.txn());
                    }
                    waiter._blockedBy_$eq(null);
                }
            }
            TxnLevelImpl txnLevelImpl = this;
            synchronized (txnLevelImpl) {
                BoxedUnit boxedUnit = !this.status().completed() ? (BoxedUnit)package$.MODULE$.blocking((Function0)((JFunction0.mcV.sp & Serializable)this::awaitCompleted$$anonfun$2)) : BoxedUnit.UNIT;
            }
        }
    }

    public void requireActive() {
        if (this._state() != null) {
            this.slowRequireActive();
        }
    }

    private void slowRequireActive() {
        Txn.Status status = this.status();
        if (status instanceof Txn.RolledBack) {
            Txn.RolledBack rolledBack = Txn$RolledBack$.MODULE$.unapply((Txn.RolledBack)status);
            Txn.RollbackCause rollbackCause = rolledBack._1();
            throw RollbackError$.MODULE$;
        }
        Txn.Status s = status;
        throw new IllegalStateException(s.toString());
    }

    public boolean pushIfActive(TxnLevelImpl child) {
        return TxnLevelImpl$.scala$concurrent$stm$ccstm$TxnLevelImpl$$$stateUpdater.compareAndSet(this, null, child);
    }

    /*
     * WARNING - void declaration
     */
    public boolean attemptMerge() {
        void var1_1;
        boolean f;
        boolean bl = f = this._state() == null && TxnLevelImpl$.scala$concurrent$stm$ccstm$TxnLevelImpl$$$stateUpdater.compareAndSet(this, null, "merged");
        if (this.parUndo()._state() == this) {
            TxnLevelImpl$.scala$concurrent$stm$ccstm$TxnLevelImpl$$$stateUpdater.compareAndSet(this.parUndo(), this, null);
        }
        return (boolean)var1_1;
    }

    public void forceRollback(Txn.RollbackCause cause) {
        Txn.Status s = this.rollbackImpl(Txn$RolledBack$.MODULE$.apply(cause));
        if (!(s instanceof Txn.RolledBack)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
    }

    @Override
    public Txn.Status requestRollback(Txn.RollbackCause cause) {
        if (cause instanceof Txn.ExplicitRetryCause) {
            throw new IllegalArgumentException("explicit retry is not available via requestRollback");
        }
        return this.rollbackImpl(Txn$RolledBack$.MODULE$.apply(cause));
    }

    private Txn.Status rollbackImpl(Txn.RolledBack rb) {
        Txn.Status status;
        block3: {
            Object raw;
            TxnLevelImpl txnLevelImpl = this;
            while (true) {
                if ((raw = txnLevelImpl._state()) == null || txnLevelImpl.canAttemptLocalRollback(raw)) {
                    if (!TxnLevelImpl$.scala$concurrent$stm$ccstm$TxnLevelImpl$$$stateUpdater.compareAndSet(txnLevelImpl, raw, rb)) continue;
                    txnLevelImpl.notifyCompleted();
                    status = rb;
                    break block3;
                }
                if (raw == "merged") {
                    txnLevelImpl = txnLevelImpl.parUndo();
                    continue;
                }
                if (!(raw instanceof TxnLevelImpl)) break;
                ((TxnLevelImpl)raw).rollbackImpl(rb);
            }
            status = (Txn.Status)raw;
        }
        return status;
    }

    private boolean canAttemptLocalRollback(Object raw) {
        boolean bl;
        Object object = raw;
        if (Txn$Prepared$.MODULE$.equals(object)) {
            bl = InTxnImpl$.MODULE$.get() == this.txn();
        } else if (object instanceof Txn.Status) {
            Txn.Status s = (Txn.Status)object;
            bl = !s.decided();
        } else if (object instanceof TxnLevelImpl) {
            TxnLevelImpl ch = (TxnLevelImpl)object;
            bl = ch.rolledBackOrMerged();
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean rolledBackOrMerged() {
        boolean bl;
        Object object = this._state();
        if ("merged".equals(object)) {
            bl = true;
        } else if (object instanceof Txn.RolledBack) {
            Txn.RolledBack rolledBack = Txn$RolledBack$.MODULE$.unapply((Txn.RolledBack)object);
            Txn.RollbackCause rollbackCause = rolledBack._1();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final long $anonfun$1() {
        return Long.MAX_VALUE;
    }

    private final void awaitCompleted$$anonfun$1(TxnLevelImpl waiter$1, Object debugInfo$1, CommitBarrierImpl cb$1) {
        while (!this.status().completed() && !waiter$1.isRolledBack()) {
            if (cb$1 != null && this.hasMemberCycle(cb$1, waiter$1)) {
                cb$1.cancelAll(CommitBarrier$MemberCycle$.MODULE$.apply(debugInfo$1));
            }
            this.wait();
        }
    }

    private final void awaitCompleted$$anonfun$2() {
        while (!this.status().completed()) {
            this.wait();
        }
    }
}

