/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import java.util.concurrent.atomic.AtomicReferenceArray;
import scala.concurrent.stm.ccstm.SlotLock;
import scala.concurrent.stm.ccstm.SlotLock$;
import scala.concurrent.stm.skel.SimpleRandom$;
import scala.runtime.Scala3RunTime$;

public final class TxnSlotManager<T> {
    private final int range;
    private final int reservedSlots;
    private final AtomicReferenceArray<Object> slots;

    public <T> TxnSlotManager(int range, int reservedSlots) {
        this.range = range;
        this.reservedSlots = reservedSlots;
        if (!(range >= 16 & (range & range - 1) == 0)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (range < reservedSlots + 16) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.slots = new AtomicReferenceArray(range);
    }

    private int nextSlot(int tries) {
        return (SimpleRandom$.MODULE$.nextInt() << 4 | -tries >> 1 & 0xF) & this.range - 1;
    }

    /*
     * WARNING - void declaration
     */
    public int assign(T txn, int slotHint) throws InterruptedException {
        void var3_3;
        int s = (slotHint & 0xFFFFFFF0 | slotHint + 1 & 0xF) & this.range - 1;
        int tries = 0;
        while (s < this.reservedSlots || this.slots.get(s) != null || !this.slots.compareAndSet(s, null, txn)) {
            s = this.nextSlot(tries);
            if (++tries <= 100) continue;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread.yield();
        }
        return (int)var3_3;
    }

    public T lookup(int slot) {
        return this.unwrap(this.slots.get(slot));
    }

    private T unwrap(Object e) {
        Object object;
        Object object2 = e;
        if (object2 instanceof SlotLock) {
            Object txn;
            SlotLock slotLock = SlotLock$.MODULE$.unapply((SlotLock)object2);
            Object object3 = slotLock._1();
            int n = slotLock._2();
            object = txn = object3;
        } else {
            Object txn;
            object = txn = object2;
        }
        return (T)object;
    }

    public T beginLookup(int slot) {
        Object e = null;
        while ((e = this.slots.get(slot)) != null && !this.slots.compareAndSet(slot, e, this.locked(e))) {
        }
        return this.unwrap(e);
    }

    private Object locked(Object e) {
        SlotLock slotLock;
        Object object = e;
        if (object instanceof SlotLock) {
            SlotLock slotLock2 = SlotLock$.MODULE$.unapply((SlotLock)object);
            Object object2 = slotLock2._1();
            int n = slotLock2._2();
            Object txn = object2;
            int rc = n;
            slotLock = SlotLock$.MODULE$.apply(txn, rc + 1);
        } else {
            Object txn = object;
            slotLock = SlotLock$.MODULE$.apply(txn, 1);
        }
        return slotLock;
    }

    public void endLookup(int slot, T observed) {
        if (observed != null) {
            this.release(slot);
        }
    }

    public void release(int slot) {
        Object e = null;
        while (!this.slots.compareAndSet(slot, e = this.slots.get(slot), this.unlocked(e))) {
        }
    }

    private Object unlocked(Object e) {
        Object object;
        Object object2 = e;
        if (object2 instanceof SlotLock) {
            SlotLock slotLock = SlotLock$.MODULE$.unapply((SlotLock)object2);
            Object object3 = slotLock._1();
            int n = slotLock._2();
            Object txn = object3;
            if (1 == n) {
                object = txn;
            } else {
                Object txn2 = object3;
                int rc = n;
                object = SlotLock$.MODULE$.apply(txn2, rc - 1);
            }
        } else {
            object = null;
        }
        return object;
    }
}

