/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.ccstm;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import scala.Function0;
import scala.concurrent.package$;
import scala.concurrent.stm.ccstm.CCSTM$;
import scala.concurrent.stm.ccstm.Handle;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.java8.JFunction0;

public final class WakeupManager {
    private final int numChannels;
    public final int scala$concurrent$stm$ccstm$WakeupManager$$numSources;
    public final AtomicLongArray scala$concurrent$stm$ccstm$WakeupManager$$pending;
    private final AtomicReferenceArray<EventImpl> events;

    public WakeupManager(int numChannels, int numSources) {
        this.numChannels = numChannels;
        this.scala$concurrent$stm$ccstm$WakeupManager$$numSources = numSources;
        if (numChannels <= 0 || numChannels > 64 || (numChannels & numChannels - 1) != 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (numSources <= 0 || (numSources & numSources - 1) != 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        int ChannelSpacing = 16;
        this.scala$concurrent$stm$ccstm$WakeupManager$$pending = new AtomicLongArray(numSources);
        this.events = new AtomicReferenceArray(numChannels * 16);
    }

    public WakeupManager() {
        this(64, 512);
    }

    /*
     * WARNING - void declaration
     */
    public long prepareToTrigger(Handle<?> handle) {
        void var3_3;
        int i = CCSTM$.MODULE$.hash(handle.base(), handle.metaOffset()) & this.scala$concurrent$stm$ccstm$WakeupManager$$numSources - 1;
        long z = 0L;
        while ((z = this.scala$concurrent$stm$ccstm$WakeupManager$$pending.get(i)) != 0L && !this.scala$concurrent$stm$ccstm$WakeupManager$$pending.compareAndSet(i, z, 0L)) {
        }
        return (long)var3_3;
    }

    public void trigger(long wakeups) {
        int channel = 0;
        long w = wakeups;
        while (w != 0L) {
            int s = Long.numberOfTrailingZeros(w);
            w >>>= s;
            this.trigger(channel += s);
            w >>>= 1;
            ++channel;
        }
    }

    private void trigger(int channel) {
        int i = channel * 16;
        EventImpl e = this.events.get(i);
        if (e != null) {
            e.trigger();
            this.events.compareAndSet(i, e, null);
        }
    }

    public Event subscribe() {
        return this.subscribe(CCSTM$.MODULE$.hash(Thread.currentThread()) & this.numChannels - 1);
    }

    private EventImpl subscribe(int channel) {
        int i = channel * 16;
        while (true) {
            EventImpl existing = this.events.get(i);
            if (existing != null && !existing.triggered()) {
                return existing;
            }
            EventImpl fresh = new EventImpl(this, channel);
            if (!this.events.compareAndSet(i, existing, fresh)) continue;
            return fresh;
        }
        throw (Nothing$)BoxedUnit.UNIT;
    }

    public static interface Event {
        public boolean triggered();

        public boolean addSource(Handle<?> var1);

        public void await() throws InterruptedException;

        public boolean tryAwaitUntil(long var1) throws InterruptedException;
    }

    public class EventImpl
    extends AbstractQueuedSynchronizer
    implements Event {
        private final long mask;
        private final WakeupManager $outer;

        public EventImpl(WakeupManager $outer, int channel) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.mask = 1L << channel;
            this.setState(1);
        }

        @Override
        public int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        public boolean tryReleaseShared(int releases) {
            return this.getState() == 1 && this.compareAndSetState(1, 0);
        }

        @Override
        public boolean triggered() {
            return this.getState() == 0;
        }

        @Override
        public boolean addSource(Handle<?> handle) {
            boolean bl;
            if (this.triggered()) {
                bl = false;
            } else {
                int i = CCSTM$.MODULE$.hash(handle.base(), handle.metaOffset()) & this.$outer.scala$concurrent$stm$ccstm$WakeupManager$$numSources - 1;
                long p = this.$outer.scala$concurrent$stm$ccstm$WakeupManager$$pending.get(i);
                while ((p & this.mask) == 0L && !this.$outer.scala$concurrent$stm$ccstm$WakeupManager$$pending.compareAndSet(i, p, p | this.mask)) {
                    if (this.triggered()) {
                        return false;
                    }
                    p = this.$outer.scala$concurrent$stm$ccstm$WakeupManager$$pending.get(i);
                }
                bl = true;
            }
            return bl;
        }

        @Override
        public void await() throws InterruptedException {
            boolean f = this.tryAwaitUntil(Long.MAX_VALUE);
            if (!f) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
        }

        @Override
        public boolean tryAwaitUntil(long nanoDeadline) throws InterruptedException {
            boolean bl;
            if (this.triggered()) {
                bl = true;
            } else if (nanoDeadline == Long.MAX_VALUE) {
                package$.MODULE$.blocking((Function0)((JFunction0.mcV.sp & Serializable)this::tryAwaitUntil$$anonfun$1));
                bl = true;
            } else {
                long remaining = nanoDeadline - System.nanoTime();
                bl = remaining > 0L && BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.blocking(() -> this.tryAwaitUntil$$anonfun$2(remaining)));
            }
            return bl;
        }

        public void trigger() {
            this.releaseShared(1);
        }

        public final WakeupManager scala$concurrent$stm$ccstm$WakeupManager$EventImpl$$$outer() {
            return this.$outer;
        }

        private final void tryAwaitUntil$$anonfun$1() {
            this.acquireSharedInterruptibly(1);
        }

        private final boolean tryAwaitUntil$$anonfun$2(long remaining$1) {
            return this.tryAcquireSharedNanos(1, remaining$1);
        }
    }
}

